/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.PixelGraphics2D;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphicsConstants;

public abstract class VectorGraphics
extends Graphics2D
implements VectorGraphicsConstants {
    private static Hashtable symbols = new Hashtable(15);
    private static Hashtable alignments;

    public abstract void setProperties(Properties var1);

    protected abstract void initProperties(Properties var1);

    protected abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public abstract Color getPropertyColor(String var1);

    public abstract Rectangle getPropertyRectangle(String var1);

    public abstract Dimension getPropertyDimension(String var1);

    public abstract int getPropertyInt(String var1);

    public abstract double getPropertyDouble(String var1);

    public abstract boolean isProperty(String var1);

    public abstract void clearRect(int var1, int var2, int var3, int var4);

    public abstract void clipRect(int var1, int var2, int var3, int var4);

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract Graphics create();

    public Graphics create(int n2, int n3, int n4, int n5) {
        return super.create(n2, n3, n4, n5);
    }

    public abstract void dispose();

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, ImageObserver var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, Color var4, ImageObserver var5);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, ImageObserver var10);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, ImageObserver var11);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public abstract void drawPolygon(int[] var1, int[] var2, int var3);

    public abstract void drawPolyline(int[] var1, int[] var2, int var3);

    public abstract void drawRect(int var1, int var2, int var3, int var4);

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawString(AttributedCharacterIterator var1, int var2, int var3);

    public abstract void drawString(String var1, int var2, int var3);

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public abstract void fillPolygon(int[] var1, int[] var2, int var3);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract Shape getClip();

    public abstract Rectangle getClipBounds();

    public abstract Rectangle getClipBounds(Rectangle var1);

    public abstract Color getColor();

    public abstract Font getFont();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void setClip(int var1, int var2, int var3, int var4);

    public abstract void setClip(Shape var1);

    public abstract void setColor(Color var1);

    public abstract void setFont(Font var1);

    public abstract void setPaintMode();

    public abstract void setXORMode(Color var1);

    public abstract String toString();

    public abstract void translate(int var1, int var2);

    public abstract void addRenderingHints(Map var1);

    public abstract void clip(Shape var1);

    public abstract void draw(Shape var1);

    public abstract void drawGlyphVector(GlyphVector var1, float var2, float var3);

    public abstract void drawImage(BufferedImage var1, BufferedImageOp var2, int var3, int var4);

    public abstract boolean drawImage(Image var1, AffineTransform var2, ImageObserver var3);

    public abstract void drawRenderableImage(RenderableImage var1, AffineTransform var2);

    public abstract void drawRenderedImage(RenderedImage var1, AffineTransform var2);

    public abstract void drawString(AttributedCharacterIterator var1, float var2, float var3);

    public abstract void drawString(String var1, float var2, float var3);

    public abstract void fill(Shape var1);

    protected void fill(Shape shape, Paint paint) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        BufferedImage bufferedImage = new BufferedImage((int)Math.ceil(rectangle2D.getWidth()) + 1, (int)Math.ceil(rectangle2D.getHeight()) + 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        graphics2D.fill(graphics2D.getDeviceConfiguration().getBounds());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setPaint(paint);
        graphics2D.translate(-rectangle2D.getMinX(), -rectangle2D.getMinY());
        graphics2D.fill(shape);
        graphics2D.dispose();
        Shape shape2 = this.getClip();
        this.clip(shape);
        this.drawImage((Image)bufferedImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), null);
        this.setClip(shape2);
    }

    public abstract Color getBackground();

    public abstract Composite getComposite();

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public abstract FontRenderContext getFontRenderContext();

    public abstract Paint getPaint();

    public abstract Object getRenderingHint(RenderingHints.Key var1);

    public abstract RenderingHints getRenderingHints();

    public abstract Stroke getStroke();

    public abstract AffineTransform getTransform();

    public abstract boolean hit(Rectangle var1, Shape var2, boolean var3);

    public abstract void rotate(double var1);

    public abstract void rotate(double var1, double var3, double var5);

    public abstract void scale(double var1, double var3);

    public abstract void setBackground(Color var1);

    public abstract void setComposite(Composite var1);

    public abstract void setPaint(Paint var1);

    public abstract void setRenderingHint(RenderingHints.Key var1, Object var2);

    public abstract void setRenderingHints(Map var1);

    public abstract void setStroke(Stroke var1);

    public abstract void setTransform(AffineTransform var1);

    public abstract void shear(double var1, double var3);

    public abstract void transform(AffineTransform var1);

    public abstract void translate(double var1, double var3);

    public abstract void clearRect(double var1, double var3, double var5, double var7);

    public abstract void clipRect(double var1, double var3, double var5, double var7);

    public abstract Graphics create(double var1, double var3, double var5, double var7);

    public abstract void drawArc(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void drawLine(double var1, double var3, double var5, double var7);

    public abstract void drawOval(double var1, double var3, double var5, double var7);

    public abstract void drawPolygon(double[] var1, double[] var2, int var3);

    public abstract void drawPolyline(double[] var1, double[] var2, int var3);

    public abstract void drawRect(double var1, double var3, double var5, double var7);

    public abstract void drawRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void drawSymbol(int var1, int var2, int var3, int var4);

    public abstract void drawSymbol(double var1, double var3, double var5, int var7);

    public abstract void fillSymbol(int var1, int var2, int var3, int var4);

    public abstract void fillSymbol(double var1, double var3, double var5, int var7);

    public abstract void fillAndDrawSymbol(int var1, int var2, int var3, int var4, Color var5);

    public abstract void fillAndDrawSymbol(double var1, double var3, double var5, int var7, Color var8);

    public abstract void drawString(String var1, double var2, double var4);

    public abstract void drawString(TagString var1, double var2, double var4);

    public abstract void drawString(String var1, double var2, double var4, int var6, int var7);

    public abstract void drawString(TagString var1, double var2, double var4, int var6, int var7);

    public abstract void drawString(String var1, double var2, double var4, int var6, int var7, boolean var8, Color var9, double var10, boolean var12, Color var13);

    public abstract void drawString(TagString var1, double var2, double var4, int var6, int var7, boolean var8, Color var9, double var10, boolean var12, Color var13);

    public abstract void endExport();

    public abstract void fillAndDraw(Shape var1, Color var2);

    public abstract void fillArc(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void fillOval(double var1, double var3, double var5, double var7);

    public abstract void fillPolygon(double[] var1, double[] var2, int var3);

    public abstract void fillRect(double var1, double var3, double var5, double var7);

    public abstract void fillRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract int getColorMode();

    public abstract String getCreator();

    public abstract boolean isDeviceIndependent();

    public abstract void printComment(String var1);

    public abstract void setClip(double var1, double var3, double var5, double var7);

    public abstract void setColorMode(int var1);

    public abstract void setCreator(String var1);

    public abstract void setDeviceIndependent(boolean var1);

    public abstract void setLineWidth(int var1);

    public abstract void setLineWidth(double var1);

    public abstract void startExport();

    public static VectorGraphics create(Graphics graphics) {
        if (graphics != null && !(graphics instanceof VectorGraphics)) {
            return new PixelGraphics2D(graphics);
        }
        return (VectorGraphics)graphics;
    }

    public static int getTextAlignment(String string) {
        Integer n2 = (Integer)alignments.get(string.toLowerCase());
        return n2 != null ? n2 : 2;
    }

    public static int getSymbol(String string) {
        Integer n2 = (Integer)symbols.get(string.toLowerCase());
        return n2 != null ? n2 : 2;
    }

    public static double getYalignment(double d2, double d3, double d4, int n2) {
        switch (n2) {
            case 1: {
                d2 = d2 + d3 - d4;
                break;
            }
            case 2: {
                d2 = d2 + (d3 + d4) / 2.0 - d4;
                break;
            }
            case 3: {
                d2 -= d4;
                break;
            }
        }
        return d2;
    }

    public static double getXalignment(double d2, double d3, int n2) {
        switch (n2) {
            case 2: {
                d2 -= d3 / 2.0;
                break;
            }
            case 3: {
                d2 -= d3;
                break;
            }
        }
        return d2;
    }

    static {
        symbols.put("vline", new Integer(0));
        symbols.put("hline", new Integer(1));
        symbols.put("plus", new Integer(2));
        symbols.put("cross", new Integer(3));
        symbols.put("star", new Integer(4));
        symbols.put("circle", new Integer(5));
        symbols.put("box", new Integer(6));
        symbols.put("up_triangle", new Integer(7));
        symbols.put("dn_triangle", new Integer(8));
        symbols.put("diamond", new Integer(9));
        alignments = new Hashtable(6);
        alignments.put("baseline", new Integer(0));
        alignments.put("left", new Integer(1));
        alignments.put("top", new Integer(1));
        alignments.put("middle", new Integer(2));
        alignments.put("center", new Integer(2));
        alignments.put("right", new Integer(3));
        alignments.put("bottom", new Integer(3));
    }
}

