/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArrayPath
implements Shape {
    private double[] xPoints;
    private double[] yPoints;
    private int nPoints;
    private boolean closed;
    private int resolution;

    public ArrayPath(double[] dArray, double[] dArray2, int n2, boolean bl, int n3) {
        this.xPoints = dArray;
        this.yPoints = dArray2;
        this.nPoints = n2;
        this.closed = bl;
        this.resolution = n3;
    }

    public boolean contains(double d2, double d3) {
        return false;
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return true;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }

    public Rectangle2D getBounds2D() {
        double d2;
        double d3;
        double d4;
        double d5;
        int n2 = this.nPoints;
        if (n2 > 0) {
            d4 = d5 = this.yPoints[--n2];
            d2 = d3 = this.xPoints[n2];
            while (n2 > 0) {
                double d6 = this.yPoints[--n2];
                double d7 = this.xPoints[n2];
                if (d7 < d2) {
                    d2 = d7;
                }
                if (d6 < d4) {
                    d4 = d6;
                }
                if (d7 > d3) {
                    d3 = d7;
                }
                if (!(d6 > d5)) continue;
                d5 = d6;
            }
        } else {
            d5 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            d2 = 0.0;
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        double[] dArray = this.xPoints;
        double[] dArray2 = this.yPoints;
        if (affineTransform != null) {
            dArray = new double[this.nPoints];
            dArray2 = new double[this.nPoints];
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            for (int i2 = 0; i2 < this.nPoints; ++i2) {
                ((Point2D)double_).setLocation(this.xPoints[i2], this.yPoints[i2]);
                affineTransform.transform(double_, double_2);
                dArray[i2] = ((Point2D)double_2).getX();
                dArray2[i2] = ((Point2D)double_2).getY();
            }
        }
        return new ArrayPathIterator(dArray, dArray2, this.nPoints, this.closed, this.resolution);
    }

    private class ArrayPathIterator
    implements PathIterator {
        private double[] xPoints;
        private double[] yPoints;
        private double lastX;
        private double lastY;
        private int nPoints;
        private boolean closed;
        private int resolution;
        private int currentPoint;
        private boolean isDone;

        private ArrayPathIterator(double[] dArray, double[] dArray2, int n2, boolean bl, int n3) {
            this.xPoints = dArray;
            this.yPoints = dArray2;
            this.nPoints = n2;
            this.closed = bl;
            this.resolution = n3;
            this.currentPoint = 0;
            this.isDone = n2 == 0;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void next() {
            ++this.currentPoint;
            while (this.currentPoint < this.nPoints - 1 && Math.abs(this.xPoints[this.currentPoint] - this.lastX) < (double)this.resolution && Math.abs(this.yPoints[this.currentPoint] - this.lastY) < (double)this.resolution) {
                ++this.currentPoint;
            }
            if (this.closed && this.currentPoint == this.nPoints - 1 && Math.abs(this.xPoints[this.currentPoint] - this.xPoints[0]) < (double)this.resolution && Math.abs(this.yPoints[this.currentPoint] - this.yPoints[0]) < (double)this.resolution) {
                ++this.currentPoint;
            }
            this.isDone = this.closed ? this.currentPoint > this.nPoints : this.currentPoint >= this.nPoints;
        }

        public int currentSegment(double[] dArray) {
            if (this.closed && this.currentPoint == this.nPoints) {
                return 4;
            }
            dArray[0] = this.lastX = this.xPoints[this.currentPoint];
            dArray[1] = this.lastY = this.yPoints[this.currentPoint];
            return this.currentPoint == 0 ? 0 : 1;
        }

        public int currentSegment(float[] fArray) {
            if (this.closed && this.currentPoint == this.nPoints) {
                return 4;
            }
            this.lastX = this.xPoints[this.currentPoint];
            this.lastY = this.yPoints[this.currentPoint];
            fArray[0] = (float)this.lastX;
            fArray[1] = (float)this.lastY;
            return this.currentPoint == 0 ? 0 : 1;
        }

        public int getWindingRule() {
            return 1;
        }
    }
}

