/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.zip;

import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.io.CipherOutputStream;
import com.fr.zip4j.io.DeflaterOutputStream;
import com.fr.zip4j.io.SplitOutputStream;
import com.fr.zip4j.io.ZipOutputStream;
import com.fr.zip4j.model.EndCentralDirRecord;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.model.ZipParameters;
import com.fr.zip4j.progress.ProgressMonitor;
import com.fr.zip4j.util.ArchiveMaintainer;
import com.fr.zip4j.util.CRCUtil;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ZipEngine {
    private ZipModel zipModel;

    public ZipEngine(ZipModel zipModel) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null in ZipEngine constructor");
        }
        this.zipModel = zipModel;
    }

    public void addFiles(final ArrayList arrayList, final ZipParameters zipParameters, final ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (arrayList == null || zipParameters == null) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (arrayList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        progressMonitor.setCurrentOperation(0);
        progressMonitor.setState(1);
        progressMonitor.setResult(1);
        if (bl) {
            progressMonitor.setTotalWork(this.calculateTotalWork(arrayList, zipParameters));
            progressMonitor.setFileName(((File)arrayList.get(0)).getAbsolutePath());
            Thread thread = new Thread("Zip4j"){

                public void run() {
                    try {
                        ZipEngine.this.initAddFiles(arrayList, zipParameters, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initAddFiles(arrayList, zipParameters, progressMonitor);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initAddFiles(ArrayList var1_1, ZipParameters var2_2, ProgressMonitor var3_3) throws ZipException {
        block43: {
            block40: {
                block42: {
                    block38: {
                        block36: {
                            block37: {
                                if (var1_1 == null) throw new ZipException("one of the input parameters is null when adding files");
                                if (var2_2 == null) {
                                    throw new ZipException("one of the input parameters is null when adding files");
                                }
                                if (var1_1.size() <= 0) {
                                    throw new ZipException("no files to add");
                                }
                                if (this.zipModel.getEndCentralDirRecord() == null) {
                                    this.zipModel.setEndCentralDirRecord(this.createEndOfCentralDirectoryRecord());
                                }
                                var4_4 = null;
                                var5_5 = null;
                                try {
                                    try {
                                        this.checkParameters(var2_2);
                                        this.removeFilesIfExists(var1_1, var2_2, var3_3);
                                        var6_6 = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
                                        var7_9 = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
                                        var4_4 = new ZipOutputStream(var7_9, this.zipModel);
                                        if (var6_6) {
                                            if (this.zipModel.getEndCentralDirRecord() == null) {
                                                throw new ZipException("invalid end of central directory record");
                                            }
                                            var7_9.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                                        }
                                        var8_10 = new byte[4096];
                                        var9_11 = -1;
                                        for (var10_12 = 0; var10_12 < var1_1.size(); ++var10_12) {
                                            if (var3_3.isCancelAllTasks()) {
                                                var3_3.setResult(3);
                                                var3_3.setState(0);
                                                var13_14 = null;
                                                if (var5_5 == null) break block36;
                                                break block37;
                                            }
                                            var11_13 = (ZipParameters)var2_2.clone();
                                            var3_3.setFileName(((File)var1_1.get(var10_12)).getAbsolutePath());
                                            if (!((File)var1_1.get(var10_12)).isDirectory()) {
                                                if (var11_13.isEncryptFiles() && var11_13.getEncryptionMethod() == 0) {
                                                    var3_3.setCurrentOperation(3);
                                                    var11_13.setSourceFileCRC((int)CRCUtil.computeFileCRC(((File)var1_1.get(var10_12)).getAbsolutePath(), var3_3));
                                                    var3_3.setCurrentOperation(0);
                                                    if (var3_3.isCancelAllTasks()) {
                                                        var3_3.setResult(3);
                                                        var3_3.setState(0);
                                                        break block38;
                                                    }
                                                }
                                                if (Zip4jUtil.getFileLengh((File)var1_1.get(var10_12)) == 0L) {
                                                    var11_13.setCompressionMethod(0);
                                                }
                                            }
                                            var4_4.putNextEntry((File)var1_1.get(var10_12), var11_13);
                                            if (((File)var1_1.get(var10_12)).isDirectory()) {
                                                var4_4.closeEntry();
                                                continue;
                                            }
                                            var5_5 = new FileInputStream((File)var1_1.get(var10_12));
                                            while ((var9_11 = var5_5.read(var8_10)) != -1) {
                                                if (var3_3.isCancelAllTasks()) {
                                                    var3_3.setResult(3);
                                                    var3_3.setState(0);
                                                    var13_16 = null;
                                                    if (var5_5 != null) {
                                                        try {
                                                            var5_5.close();
                                                        }
                                                        catch (IOException var14_21) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (var4_4 == null) return;
                                                    try {
                                                        var4_4.close();
                                                        return;
                                                    }
                                                    catch (IOException var14_21) {
                                                        // empty catch block
                                                    }
                                                    return;
                                                }
                                                var4_4.write(var8_10, 0, var9_11);
                                                var3_3.updateWorkCompleted(var9_11);
                                            }
                                            var4_4.closeEntry();
                                            if (var5_5 == null) continue;
                                            var5_5.close();
                                        }
                                        var4_4.finish();
                                        var3_3.endProgressMonitorSuccess();
                                        break block40;
                                    }
                                    catch (ZipException var6_7) {
                                        var3_3.endProgressMonitorError(var6_7);
                                        throw var6_7;
                                    }
                                    catch (Exception var6_8) {
                                        var3_3.endProgressMonitorError(var6_8);
                                        throw new ZipException(var6_8);
                                    }
                                }
                                catch (Throwable var12_24) {
                                    block41: {
                                        var13_18 = null;
                                        if (var5_5 != null) {
                                            ** try [egrp 2[TRYBLOCK] [13 : 538->546)] { 
lbl91:
                                            // 1 sources

                                            var5_5.close();
                                            break block41;
lbl93:
                                            // 1 sources

                                            catch (IOException var14_23) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var4_4 == null) throw var12_24;
                                    ** try [egrp 3[TRYBLOCK] [14 : 553->561)] { 
lbl98:
                                    // 1 sources

                                    var4_4.close();
                                    throw var12_24;
lbl100:
                                    // 1 sources

                                    catch (IOException var14_23) {
                                        // empty catch block
                                    }
                                    throw var12_24;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [13 : 538->546)] { 
lbl105:
                            // 1 sources

                            var5_5.close();
                            break block36;
lbl107:
                            // 1 sources

                            catch (IOException var14_19) {
                                // empty catch block
                            }
                        }
                        if (var4_4 == null) return;
                        ** try [egrp 3[TRYBLOCK] [14 : 553->561)] { 
lbl112:
                        // 1 sources

                        var4_4.close();
                        return;
lbl114:
                        // 1 sources

                        catch (IOException var14_19) {
                            // empty catch block
                        }
                        return;
                    }
                    var13_15 = null;
                    if (var5_5 != null) {
                        ** try [egrp 2[TRYBLOCK] [13 : 538->546)] { 
lbl121:
                        // 1 sources

                        var5_5.close();
                        break block42;
lbl123:
                        // 1 sources

                        catch (IOException var14_20) {
                            // empty catch block
                        }
                    }
                }
                if (var4_4 == null) return;
                ** try [egrp 3[TRYBLOCK] [14 : 553->561)] { 
lbl128:
                // 1 sources

                var4_4.close();
                return;
lbl130:
                // 1 sources

                catch (IOException var14_20) {
                    // empty catch block
                }
                return;
            }
            var13_17 = null;
            if (var5_5 != null) {
                ** try [egrp 2[TRYBLOCK] [13 : 538->546)] { 
lbl137:
                // 1 sources

                var5_5.close();
                break block43;
lbl139:
                // 1 sources

                catch (IOException var14_22) {
                    // empty catch block
                }
            }
        }
        if (var4_4 == null) return;
        try {}
        catch (IOException var14_22) {}
        var4_4.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addStreamToZip(InputStream inputStream, ZipParameters zipParameters) throws ZipException {
        if (inputStream == null) throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        if (zipParameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        }
        CipherOutputStream cipherOutputStream = null;
        try {
            try {
                this.checkParameters(zipParameters);
                boolean bl = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
                SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
                cipherOutputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
                if (bl) {
                    if (this.zipModel.getEndCentralDirRecord() == null) {
                        throw new ZipException("invalid end of central directory record");
                    }
                    splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                byte[] byArray = new byte[4096];
                int n2 = -1;
                ((DeflaterOutputStream)cipherOutputStream).putNextEntry(null, zipParameters);
                if (!zipParameters.getFileNameInZip().endsWith("/") && !zipParameters.getFileNameInZip().endsWith("\\")) {
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        ((ZipOutputStream)cipherOutputStream).write(byArray, 0, n2);
                    }
                }
                ((DeflaterOutputStream)cipherOutputStream).closeEntry();
                ((DeflaterOutputStream)cipherOutputStream).finish();
            }
            catch (ZipException zipException) {
                throw zipException;
            }
            catch (Exception exception) {
                throw new ZipException(exception);
            }
            Object var9_10 = null;
            if (cipherOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (cipherOutputStream == null) throw throwable;
            try {
                cipherOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        cipherOutputStream.close();
        return;
    }

    public void addFolderToZip(File file, ZipParameters zipParameters, ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (file == null || zipParameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add folder to zip");
        }
        if (!Zip4jUtil.checkFileExists(file.getAbsolutePath())) {
            throw new ZipException("input folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new ZipException("input file is not a folder, user addFileToZip method to add files");
        }
        if (!Zip4jUtil.checkFileReadAccess(file.getAbsolutePath())) {
            throw new ZipException("cannot read folder: " + file.getAbsolutePath());
        }
        String string = null;
        string = zipParameters.isIncludeRootFolder() ? (file.getAbsolutePath() != null ? (file.getAbsoluteFile().getParentFile() != null ? file.getAbsoluteFile().getParentFile().getAbsolutePath() : "") : (file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : "")) : file.getAbsolutePath();
        zipParameters.setDefaultFolderPath(string);
        ArrayList<File> arrayList = Zip4jUtil.getFilesInDirectoryRec(file, zipParameters.isReadHiddenFiles());
        if (zipParameters.isIncludeRootFolder()) {
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
            }
            arrayList.add(file);
        }
        this.addFiles(arrayList, zipParameters, progressMonitor, bl);
    }

    private void checkParameters(ZipParameters zipParameters) throws ZipException {
        if (zipParameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (zipParameters.getCompressionMethod() != 0 && zipParameters.getCompressionMethod() != 8) {
            throw new ZipException("unsupported compression type");
        }
        if (zipParameters.getCompressionMethod() == 8 && zipParameters.getCompressionLevel() < 0 && zipParameters.getCompressionLevel() > 9) {
            throw new ZipException("invalid compression level. compression level dor deflate should be in the range of 0-9");
        }
        if (zipParameters.isEncryptFiles()) {
            if (zipParameters.getEncryptionMethod() != 0 && zipParameters.getEncryptionMethod() != 99) {
                throw new ZipException("unsupported encryption method");
            }
            if (zipParameters.getPassword() == null || zipParameters.getPassword().length <= 0) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            zipParameters.setAesKeyStrength(-1);
            zipParameters.setEncryptionMethod(-1);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeFilesIfExists(ArrayList var1_1, ZipParameters var2_2, ProgressMonitor var3_3) throws ZipException {
        block17: {
            block16: {
                if (this.zipModel == null) return;
                if (this.zipModel.getCentralDirectory() == null) return;
                if (this.zipModel.getCentralDirectory().getFileHeaders() == null) return;
                if (this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
                    return;
                }
                var4_4 = null;
                try {
                    try {
                        for (var5_5 = 0; var5_5 < var1_1.size(); ++var5_5) {
                            var6_7 = (File)var1_1.get(var5_5);
                            var7_8 = Zip4jUtil.getRelativeFileName(var6_7.getAbsolutePath(), var2_2.getRootFolderInZip(), var2_2.getDefaultFolderPath());
                            var8_9 = Zip4jUtil.getFileHeader(this.zipModel, var7_8);
                            if (var8_9 == null) continue;
                            if (var4_4 != null) {
                                var4_4.close();
                                var4_4 = null;
                            }
                            var9_10 = new ArchiveMaintainer();
                            var3_3.setCurrentOperation(2);
                            var10_11 = var9_10.initRemoveZipFile(this.zipModel, var8_9, var3_3);
                            if (var3_3.isCancelAllTasks()) {
                                var3_3.setResult(3);
                                var3_3.setState(0);
                                var15_13 = null;
                                if (var4_4 == null) return;
                                break block16;
                            }
                            var3_3.setCurrentOperation(0);
                            if (var4_4 != null) continue;
                            var4_4 = this.prepareFileOutputStream();
                            if (var10_11 == null || var10_11.get("offsetCentralDir") == null) continue;
                            var11_12 = -1L;
                            try {
                                var11_12 = Long.parseLong((String)var10_11.get("offsetCentralDir"));
                            }
                            catch (NumberFormatException var13_19) {
                                throw new ZipException("NumberFormatException while parsing offset central directory. Cannot update already existing file header");
                            }
                            catch (Exception var13_20) {
                                throw new ZipException("Error while parsing offset central directory. Cannot update already existing file header");
                            }
                            if (var11_12 < 0L) continue;
                            var4_4.seek(var11_12);
                        }
                        break block17;
                    }
                    catch (IOException var5_6) {
                        throw new ZipException(var5_6);
                    }
                }
                catch (Throwable var14_21) {
                    var15_15 = null;
                    if (var4_4 == null) throw var14_21;
                    try {
                        var4_4.close();
                        throw var14_21;
                    }
                    catch (IOException var16_18) {
                        // empty catch block
                    }
                    throw var14_21;
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 300->308)] { 
lbl57:
            // 1 sources

            var4_4.close();
            return;
lbl59:
            // 1 sources

            catch (IOException var16_16) {
                // empty catch block
            }
            return;
        }
        var15_14 = null;
        if (var4_4 == null) return;
        try {}
        catch (IOException var16_17) {}
        var4_4.close();
        return;
    }

    private RandomAccessFile prepareFileOutputStream() throws ZipException {
        String string = this.zipModel.getZipFile();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("invalid output path");
        }
        try {
            File file = new File(string);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            return new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
    }

    private EndCentralDirRecord createEndOfCentralDirectoryRecord() {
        EndCentralDirRecord endCentralDirRecord = new EndCentralDirRecord();
        endCentralDirRecord.setSignature(101010256L);
        endCentralDirRecord.setNoOfThisDisk(0);
        endCentralDirRecord.setTotNoOfEntriesInCentralDir(0);
        endCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(0);
        endCentralDirRecord.setOffsetOfStartOfCentralDir(0L);
        return endCentralDirRecord;
    }

    private long calculateTotalWork(ArrayList arrayList, ZipParameters zipParameters) throws ZipException {
        if (arrayList == null) {
            throw new ZipException("file list is null, cannot calculate total work");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string;
            FileHeader fileHeader;
            if (!(arrayList.get(i2) instanceof File) || !((File)arrayList.get(i2)).exists()) continue;
            l2 = zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == 0 ? (l2 += Zip4jUtil.getFileLengh((File)arrayList.get(i2)) * 2L) : (l2 += Zip4jUtil.getFileLengh((File)arrayList.get(i2)));
            if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0 || (fileHeader = Zip4jUtil.getFileHeader(this.zipModel, string = Zip4jUtil.getRelativeFileName(((File)arrayList.get(i2)).getAbsolutePath(), zipParameters.getRootFolderInZip(), zipParameters.getDefaultFolderPath()))) == null) continue;
            l2 += Zip4jUtil.getFileLengh(new File(this.zipModel.getZipFile())) - fileHeader.getCompressedSize();
        }
        return l2;
    }
}

