/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.util;

import com.fr.zip4j.exception.ZipException;
import java.io.DataInput;
import java.io.IOException;

public class Raw {
    public static long readLongLittleEndian(byte[] byArray, int n2) {
        long l2 = 0L;
        l2 |= (long)(byArray[n2 + 7] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2 + 6] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2 + 5] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2 + 4] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2 + 3] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2 + 2] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2 + 1] & 0xFF);
        l2 <<= 8;
        return l2 |= (long)(byArray[n2] & 0xFF);
    }

    public static int readLeInt(DataInput dataInput, byte[] byArray) throws ZipException {
        try {
            dataInput.readFully(byArray, 0, 4);
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) << 16;
    }

    public static int readShortLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    public static final short readShortBigEndian(byte[] byArray, int n2) {
        short s2 = 0;
        s2 = (short)(s2 | byArray[n2] & 0xFF);
        s2 = (short)(s2 << 8);
        s2 = (short)(s2 | byArray[n2 + 1] & 0xFF);
        return s2;
    }

    public static int readIntLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF | (byArray[n2 + 3] & 0xFF) << 8) << 16;
    }

    public static byte[] toByteArray(int n2, int n3) {
        byte[] byArray = new byte[n3];
        byte[] byArray2 = Raw.toByteArray(n2);
        for (int i2 = 0; i2 < byArray2.length && i2 < n3; ++i2) {
            byArray[i2] = byArray2[i2];
        }
        return byArray;
    }

    public static byte[] toByteArray(int n2) {
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        return byArray;
    }

    public static final void writeShortLittleEndian(byte[] byArray, int n2, short s2) {
        byArray[n2 + 1] = (byte)(s2 >>> 8);
        byArray[n2] = (byte)(s2 & 0xFF);
    }

    public static final void writeIntLittleEndian(byte[] byArray, int n2, int n3) {
        byArray[n2 + 3] = (byte)(n3 >>> 24);
        byArray[n2 + 2] = (byte)(n3 >>> 16);
        byArray[n2 + 1] = (byte)(n3 >>> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public static void writeLongLittleEndian(byte[] byArray, int n2, long l2) {
        byArray[n2 + 7] = (byte)(l2 >>> 56);
        byArray[n2 + 6] = (byte)(l2 >>> 48);
        byArray[n2 + 5] = (byte)(l2 >>> 40);
        byArray[n2 + 4] = (byte)(l2 >>> 32);
        byArray[n2 + 3] = (byte)(l2 >>> 24);
        byArray[n2 + 2] = (byte)(l2 >>> 16);
        byArray[n2 + 1] = (byte)(l2 >>> 8);
        byArray[n2] = (byte)(l2 & 0xFFL);
    }

    public static byte bitArrayToByte(int[] nArray) throws ZipException {
        if (nArray == null) {
            throw new ZipException("bit array is null, cannot calculate byte from bits");
        }
        if (nArray.length != 8) {
            throw new ZipException("invalid bit array length, cannot calculate byte");
        }
        if (!Raw.checkBits(nArray)) {
            throw new ZipException("invalid bits provided, bits contain other values than 0 or 1");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = (int)((double)n2 + Math.pow(2.0, i2) * (double)nArray[i2]);
        }
        return (byte)n2;
    }

    private static boolean checkBits(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == 0 || nArray[i2] == 1) continue;
            return false;
        }
        return true;
    }

    public static void prepareBuffAESIVBytes(byte[] byArray, int n2, int n3) {
        byArray[0] = (byte)n2;
        byArray[1] = (byte)(n2 >> 8);
        byArray[2] = (byte)(n2 >> 16);
        byArray[3] = (byte)(n2 >> 24);
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        byArray[11] = 0;
        byArray[12] = 0;
        byArray[13] = 0;
        byArray[14] = 0;
        byArray[15] = 0;
    }

    public static byte[] convertCharArrayToByteArray(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            byArray[i2] = (byte)cArray[i2];
        }
        return byArray;
    }
}

