/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.crypto;

import com.fr.zip4j.crypto.IEncrypter;
import com.fr.zip4j.crypto.PBKDF2.MacBasedPRF;
import com.fr.zip4j.crypto.PBKDF2.PBKDF2Engine;
import com.fr.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import com.fr.zip4j.crypto.engine.AESEngine;
import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.util.Raw;
import java.util.Random;

public class AESEncrpyter
implements IEncrypter {
    private char[] password;
    private int keyStrength;
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private int KEY_LENGTH;
    private int MAC_LENGTH;
    private int SALT_LENGTH;
    private final int PASSWORD_VERIFIER_LENGTH = 2;
    private byte[] aesKey;
    private byte[] macKey;
    private byte[] derivedPasswordVerifier;
    private byte[] saltBytes;
    private boolean finished;
    private int nonce = 1;
    private int loopCount = 0;
    private byte[] iv;
    private byte[] counterBlock;

    public AESEncrpyter(char[] cArray, int n2) throws ZipException {
        if (cArray == null || cArray.length == 0) {
            throw new ZipException("input password is empty or null in AES encrypter constructor");
        }
        if (n2 != 1 && n2 != 3) {
            throw new ZipException("Invalid key strength in AES encrypter constructor");
        }
        this.password = cArray;
        this.keyStrength = n2;
        this.finished = false;
        this.counterBlock = new byte[16];
        this.iv = new byte[16];
        this.init();
    }

    private void init() throws ZipException {
        switch (this.keyStrength) {
            case 1: {
                this.KEY_LENGTH = 16;
                this.MAC_LENGTH = 16;
                this.SALT_LENGTH = 8;
                break;
            }
            case 3: {
                this.KEY_LENGTH = 32;
                this.MAC_LENGTH = 32;
                this.SALT_LENGTH = 16;
                break;
            }
            default: {
                throw new ZipException("invalid aes key strength, cannot determine key sizes");
            }
        }
        this.saltBytes = AESEncrpyter.generateSalt(this.SALT_LENGTH);
        byte[] byArray = this.deriveKey(this.saltBytes, this.password);
        if (byArray == null || byArray.length != this.KEY_LENGTH + this.MAC_LENGTH + 2) {
            throw new ZipException("invalid key generated, cannot decrypt file");
        }
        this.aesKey = new byte[this.KEY_LENGTH];
        this.macKey = new byte[this.MAC_LENGTH];
        this.derivedPasswordVerifier = new byte[2];
        System.arraycopy(byArray, 0, this.aesKey, 0, this.KEY_LENGTH);
        System.arraycopy(byArray, this.KEY_LENGTH, this.macKey, 0, this.MAC_LENGTH);
        System.arraycopy(byArray, this.KEY_LENGTH + this.MAC_LENGTH, this.derivedPasswordVerifier, 0, 2);
        this.aesEngine = new AESEngine(this.aesKey);
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(this.macKey);
    }

    private byte[] deriveKey(byte[] byArray, char[] cArray) throws ZipException {
        try {
            PBKDF2Parameters pBKDF2Parameters = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", byArray, 1000);
            PBKDF2Engine pBKDF2Engine = new PBKDF2Engine(pBKDF2Parameters);
            byte[] byArray2 = pBKDF2Engine.deriveKey(cArray, this.KEY_LENGTH + this.MAC_LENGTH + 2);
            return byArray2;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public int encryptData(byte[] byArray) throws ZipException {
        if (byArray == null) {
            throw new ZipException("input bytes are null, cannot perform AES encrpytion");
        }
        return this.encryptData(byArray, 0, byArray.length);
    }

    public int encryptData(byte[] byArray, int n2, int n3) throws ZipException {
        if (this.finished) {
            throw new ZipException("AES Encrypter is in finished state (A non 16 byte block has already been passed to encrypter)");
        }
        if (n3 % 16 != 0) {
            this.finished = true;
        }
        for (int i2 = n2; i2 < n2 + n3; i2 += 16) {
            this.loopCount = i2 + 16 <= n2 + n3 ? 16 : n2 + n3 - i2;
            Raw.prepareBuffAESIVBytes(this.iv, this.nonce, 16);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int i3 = 0; i3 < this.loopCount; ++i3) {
                byArray[i2 + i3] = (byte)(byArray[i2 + i3] ^ this.counterBlock[i3]);
            }
            this.mac.update(byArray, i2, this.loopCount);
            ++this.nonce;
        }
        return n3;
    }

    private static byte[] generateSalt(int n2) throws ZipException {
        if (n2 != 8 && n2 != 16) {
            throw new ZipException("invalid salt size, cannot generate salt");
        }
        int n3 = 0;
        if (n2 == 8) {
            n3 = 2;
        }
        if (n2 == 16) {
            n3 = 4;
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            Random random = new Random();
            int n4 = random.nextInt();
            byArray[0 + i2 * 4] = (byte)(n4 >> 24);
            byArray[1 + i2 * 4] = (byte)(n4 >> 16);
            byArray[2 + i2 * 4] = (byte)(n4 >> 8);
            byArray[3 + i2 * 4] = (byte)n4;
        }
        return byArray;
    }

    public byte[] getFinalMac() {
        byte[] byArray = this.mac.doFinal();
        byte[] byArray2 = new byte[10];
        System.arraycopy(byArray, 0, byArray2, 0, 10);
        return byArray2;
    }

    public byte[] getDerivedPasswordVerifier() {
        return this.derivedPasswordVerifier;
    }

    public void setDerivedPasswordVerifier(byte[] byArray) {
        this.derivedPasswordVerifier = byArray;
    }

    public byte[] getSaltBytes() {
        return this.saltBytes;
    }

    public void setSaltBytes(byte[] byArray) {
        this.saltBytes = byArray;
    }

    public int getSaltLength() {
        return this.SALT_LENGTH;
    }

    public int getPasswordVeriifierLength() {
        return 2;
    }
}

