/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.web.excel;

import com.fr.base.FRContext;
import com.fr.stable.StableUtils;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.write.web.excel.SubmitProcess;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ExcelSubmitManager {
    public static final Map PROCESS_TABLE = new HashMap(64);
    private static Timer EXCEL_SUBMIT_TIMER = null;
    public static final String PROCESS_ID = "processid";
    public static final Map PROCESS_TASK_QUEUE = new HashMap(64);
    private static final long FILE_TIMEOUT = 3600000L;
    private static final long SIMPLE_TIMEOUT = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTimeoutProcesss() {
        ArrayList<SubmitProcess> arrayList = new ArrayList<SubmitProcess>();
        Object object = ExcelSubmitManager.class;
        synchronized (ExcelSubmitManager.class) {
            Object object2;
            Map.Entry entry;
            Set set = PROCESS_TABLE.entrySet();
            Iterator iterator = set.iterator();
            long l2 = System.currentTimeMillis();
            while (iterator.hasNext()) {
                entry = iterator.next();
                object2 = (SubmitProcess)entry.getValue();
                if (((SubmitProcess)object2).getProcessState() == 0) {
                    if (l2 - ((SubmitProcess)object2).getDealTime() <= 0x6DDD00L) continue;
                    if (((SubmitProcess)object2).getFilePath() != null) {
                        arrayList.add((SubmitProcess)object2);
                    }
                    iterator.remove();
                    continue;
                }
                if (((SubmitProcess)object2).getFilePath() != null) {
                    if (l2 - ((SubmitProcess)object2).getDealTime() <= 3600000L) continue;
                    arrayList.add((SubmitProcess)object2);
                    iterator.remove();
                    continue;
                }
                if (l2 - ((SubmitProcess)object2).getDealTime() <= 300000L) continue;
                iterator.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                entry = object = (SubmitProcess)arrayList.get(i2);
                synchronized (entry) {
                    try {
                        if (((SubmitProcess)object).getFilePath() == null) {
                            continue;
                        }
                        object2 = new File(((SubmitProcess)object).getFilePath());
                        StableUtils.deleteFile((File)object2);
                        ((SubmitProcess)object).setFilePath(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubmitProcess getSubmitProcess(String string) throws Exception {
        Class<ExcelSubmitManager> clazz = ExcelSubmitManager.class;
        synchronized (ExcelSubmitManager.class) {
            if (string == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (SubmitProcess)PROCESS_TABLE.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSubmitProcess(String string) throws Exception {
        Class<ExcelSubmitManager> clazz = ExcelSubmitManager.class;
        synchronized (ExcelSubmitManager.class) {
            if (string == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            PROCESS_TABLE.remove(string);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTaskQueue(String string, String string2) {
        Class<ExcelSubmitManager> clazz = ExcelSubmitManager.class;
        synchronized (ExcelSubmitManager.class) {
            if (string == null || string2 == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Object v2 = PROCESS_TASK_QUEUE.get(string);
            if (v2 == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                PROCESS_TASK_QUEUE.put(string, arrayList);
            } else {
                ArrayList arrayList = (ArrayList)v2;
                arrayList.add(string2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAheadInQueue(String string, String string2) {
        Class<ExcelSubmitManager> clazz = ExcelSubmitManager.class;
        synchronized (ExcelSubmitManager.class) {
            if (string == null || string2 == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean bl = false;
            Object v2 = PROCESS_TASK_QUEUE.get(string);
            if (v2 != null) {
                ArrayList arrayList = (ArrayList)v2;
                bl = arrayList.indexOf(string2) == 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTaskQueue(String string, String string2) {
        Class<ExcelSubmitManager> clazz = ExcelSubmitManager.class;
        synchronized (ExcelSubmitManager.class) {
            if (string == null || string2 == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Object v2 = PROCESS_TASK_QUEUE.get(string);
            if (v2 == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            ArrayList arrayList = (ArrayList)v2;
            arrayList.remove(string2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        try {
            EXCEL_SUBMIT_TIMER = new Timer();
            EXCEL_SUBMIT_TIMER.schedule(new TimerTask(){

                public void run() {
                    ExcelSubmitManager.removeTimeoutProcesss();
                }
            }, 900000L, 1200000L);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("ExcelSubmit timeout schedule init failed! " + exception.getMessage(), exception);
        }
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                try {
                    if (EXCEL_SUBMIT_TIMER != null) {
                        EXCEL_SUBMIT_TIMER.cancel();
                    }
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error("cancel timer-2 failed");
                }
            }
        });
    }
}

