/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.web.chwriter;

import com.fr.base.DynamicUnitList;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.cache.Attachment;
import com.fr.data.TableDataSource;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.MultiFileEditor;
import com.fr.form.ui.TreeEditor;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetDependProvider;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.report.ECReport;
import com.fr.report.web.button.write.AppendRowButton;
import com.fr.report.web.button.write.DeleteRowButton;
import com.fr.report.worksheet.CalculatableReport;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.write.web.chwriter.WriteCellWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WriteOfflineCellWriter
extends WriteCellWriter {
    private DynamicUnitList columnWidthList;
    private DynamicUnitList rowHeightList;

    public WriteOfflineCellWriter(Repository repository, int n2, CalculatableReport calculatableReport) {
        super(repository, n2, calculatableReport);
        this.columnWidthList = ReportHelper.getColumnWidthList((ECReport)((Object)calculatableReport));
        this.rowHeightList = ReportHelper.getRowHeightList((ECReport)((Object)calculatableReport));
    }

    protected void processWidget(WebReportCase webReportCase, CellElement cellElement, Widget widget, Object object, ColumnRow columnRow, Calculator calculator) {
        super.processWidget(webReportCase, cellElement, widget, object, columnRow, calculator);
        if (widget instanceof AppendRowButton) {
            this.resTag.attr("fixCell", ((AppendRowButton)widget).getFixCell() + "");
            this.resTag.attr("fixCount", ((AppendRowButton)widget).getCount() + "");
        } else if (widget instanceof DeleteRowButton) {
            this.resTag.attr("fixCell", ((DeleteRowButton)widget).getFixCell() + "");
        }
    }

    protected JSONObject widget2ConfigWithJSONStyle(Widget widget, Object object, ColumnRow columnRow, CellElement cellElement, int n2, String string, Calculator calculator) throws JSONException {
        Map map;
        Object object2;
        if (widget instanceof DateEditor && object != null && !(object instanceof Timestamp)) {
            object2 = object.toString();
            if (StringUtils.isNotBlank((String)object2)) {
                try {
                    if (object instanceof Date) {
                        object = DateUtils.DATEFORMAT1.format((Date)object);
                    }
                }
                catch (Throwable throwable) {
                    object = object2;
                }
            } else {
                object = object2;
            }
        }
        object2 = widget.createJSONConfig(this.repo, calculator, null);
        ((JSONObject)object2).put("value", widget.value2Config(object, this.repo.getCalculator()));
        this.createItems(widget, (JSONObject)object2, calculator);
        ((JSONObject)object2).put("sessionID", RepositoryHelper.getSessionIDInfor(this.repo).getSessionID());
        ((JSONObject)object2).put("location", ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow()));
        ((JSONObject)object2).put("reportIndex", n2);
        if (widget instanceof WidgetDependProvider && (map = ((WidgetDependProvider)((Object)widget)).getDependenceMap()) != null) {
            ((JSONObject)object2).put("dependenceMap", map);
        }
        if (widget instanceof MultiFileEditor && (object instanceof FArray || object instanceof Attachment || object instanceof Image)) {
            ((JSONObject)object2).put("attachment", true);
        }
        ((JSONObject)object2).put("fontSize", cellElement.getStyle().getFRFont().getSize());
        ((JSONObject)object2).put("widgetUrl", "");
        return object2;
    }

    private void createItems(Widget widget, JSONObject jSONObject, Calculator calculator) {
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(this.repo);
        HttpServletRequest httpServletRequest = this.repo.getHttpServletRequest();
        calculator.setAttribute(TableDataSource.KEY, (Object)sessionIDInfor.getTableDataSource());
        if (widget instanceof FieldEditor) {
            try {
                JSONArray jSONArray = widget instanceof TreeEditor ? ((TreeEditor)widget).loadDirectTreeData(sessionIDInfor, calculator, httpServletRequest) : ((FieldEditor)widget).createJSONData(sessionIDInfor, calculator, httpServletRequest);
                jSONObject.put("items", jSONArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Object unwrapLobs(CellElement cellElement, Object object) {
        Style style = cellElement.getStyle();
        Object object2 = super.unwrapLobs(cellElement, object);
        if (object2 instanceof Painter) {
            int n2 = this.columnWidthList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan()).toPixI(96);
            int n3 = this.rowHeightList.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan()).toPixI(96);
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            ((Painter)object2).paint(graphics2D, n2, n3, 96, style);
            graphics2D.dispose();
            object2 = bufferedImage;
        }
        return object2;
    }
}

