/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.FRContext;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.base.background.ImageBackground;
import com.fr.base.background.TextureBackground;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.BackgroundImageDisplayModeProcessor;
import com.fr.stable.fun.ImageLayoutDescriptionProcessor;
import com.fr.stable.fun.ServletURLTransformer;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.Browser;
import com.fr.web.ImageDataUrlCacheManager;
import com.fr.web.utils.WebUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.servlet.http.HttpServletRequest;

public class BaseHTMLWriterUtils {
    private static final int IMAGE_WIDTH = 174;
    private static final int IMAGE_HEIGHT = 126;
    private static final int DEFAULT_SIZE = 160;

    private BaseHTMLWriterUtils() {
    }

    public static JSONObject jsonBackground(Background background, Repository repository) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (background instanceof ColorBackground) {
            stringBuffer.append(StableUtils.javaColorToCSSColor(((ColorBackground)background).getColor()));
        } else if (background instanceof ImageBackground) {
            ImageBackground imageBackground = (ImageBackground)background;
            BackgroundImageDisplayModeProcessor backgroundImageDisplayModeProcessor = (BackgroundImageDisplayModeProcessor)ExtraClassManager.getInstance().getSingle("BackgroundImageDisplayModeProcessor");
            string = backgroundImageDisplayModeProcessor != null ? backgroundImageDisplayModeProcessor.changeBackgroudImageDisplayMode(repository, imageBackground.getDefaultImage(), "image") : repository.checkoutObject(imageBackground.getDefaultImage(), "image");
            stringBuffer.append("url(").append(string).append(") ");
            stringBuffer.append(BaseHTMLWriterUtils.createImageLayoutDescription(imageBackground.getLayout()));
        } else if (background != null) {
            int n2;
            int n3;
            if (background instanceof TextureBackground) {
                n3 = 174;
                n2 = 126;
            } else {
                n3 = 160;
                n2 = 160;
            }
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n3, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            background.paint(graphics2D, repository, new Rectangle2D.Double(0.0, 0.0, n3, n2));
            bufferedImage.flush();
            graphics2D.dispose();
            string = repository.checkoutObject(bufferedImage, "image");
            stringBuffer.append("url(").append(repository.checkoutObject(bufferedImage, "image")).append(") ").append("repeat ");
        }
        return BaseHTMLWriterUtils.createBackgroundJson(stringBuffer, string, background, repository);
    }

    private static JSONObject createBackgroundJson(StringBuffer stringBuffer, String string, Background background, Repository repository) {
        JSONObject jSONObject = new JSONObject();
        if (stringBuffer.length() > 0) {
            try {
                if (BaseHTMLWriterUtils.need2AdjustBackgroundImage(background)) {
                    int n2 = ((ImageBackground)background).getLayout();
                    if (repository.getBrowser().isLowIEVersion()) {
                        jSONObject.put("type", n2);
                        jSONObject.put("url", string);
                        jSONObject.put("background", stringBuffer.toString());
                        jSONObject.put("background-repeat", "no-repeat");
                        jSONObject.put("background-image", "none");
                        jSONObject.put("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + string + "',sizingMethod='scale')");
                    } else {
                        jSONObject.put("background", stringBuffer.toString());
                        if (n2 == 4) {
                            jSONObject.put("background-size", "contain");
                        } else if (n2 == 2) {
                            jSONObject.put("background-size", "100% 100%");
                        }
                    }
                } else if (background instanceof GradientBackground) {
                    if (repository.getBrowser().isLowIEVersion()) {
                        jSONObject.put("type", 2);
                        jSONObject.put("url", string);
                        jSONObject.put("background", stringBuffer.toString());
                        jSONObject.put("background-repeat", "no-repeat");
                        jSONObject.put("background-image", "none");
                        jSONObject.put("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + string + "',sizingMethod='scale')");
                    } else {
                        jSONObject.put("background", stringBuffer.toString());
                        jSONObject.put("background-size", "100% 100%");
                    }
                } else {
                    jSONObject.put("background", stringBuffer.toString());
                }
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return jSONObject;
    }

    private static boolean need2AdjustBackgroundImage(Background background) {
        if (background instanceof ImageBackground) {
            int n2 = ((ImageBackground)background).getLayout();
            return n2 == 4 || n2 == 2;
        }
        return false;
    }

    private static String createImageLayoutDescription(int n2) {
        String string;
        ImageLayoutDescriptionProcessor imageLayoutDescriptionProcessor = (ImageLayoutDescriptionProcessor)ExtraClassManager.getInstance().getSingle("ImageLayoutDescriptionProcessor");
        if (imageLayoutDescriptionProcessor != null && StringUtils.isNotEmpty(string = imageLayoutDescriptionProcessor.getCustomLayoutDescription(n2))) {
            return string;
        }
        if (n2 == 3 || n2 == 4) {
            return "no-repeat";
        }
        if (n2 == 1) {
            return "no-repeat center";
        }
        if (n2 == 0) {
            return "repeat";
        }
        if (n2 == 2) {
            return "no-repeat center";
        }
        return "";
    }

    public static void writeBackground(Tag tag, Background background, Dimension dimension, boolean bl, Repository repository) {
        if (background == null) {
            return;
        }
        if (background instanceof ColorBackground) {
            tag.css("background-color", StableUtils.javaColorToCSSColor(((ColorBackground)background).getColor()));
        } else {
            int n2 = dimension.width;
            int n3 = dimension.height;
            if (n2 == 0 || n3 == 0) {
                return;
            }
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            background.paint(graphics2D, repository, new Rectangle2D.Double(0.0, 0.0, n2, n3));
            bufferedImage.flush();
            graphics2D.dispose();
            if (!bl) {
                tag.css("background-repeat", "no-repeat");
                tag.css("background-size", "100% 100%");
            }
            boolean bl2 = background instanceof ImageBackground;
            Point point = new Point(-1, -1);
            if (bl2) {
                point = ((ImageBackground)background).getCellPoint();
                int n4 = ((ImageBackground)background).getLayout4Draw();
                bl2 = n4 == 1 || n4 == 4;
            }
            BaseHTMLWriterUtils.writeTagWithImageBackground(tag, bufferedImage, repository, bl2, point);
        }
    }

    private static void writeTagWithImageBackground(Tag tag, Image image, Repository repository, boolean bl, Point point) {
        Object object;
        String string = "";
        BackgroundImageDisplayModeProcessor backgroundImageDisplayModeProcessor = (BackgroundImageDisplayModeProcessor)ExtraClassManager.getInstance().getSingle("BackgroundImageDisplayModeProcessor");
        if (backgroundImageDisplayModeProcessor != null) {
            string = backgroundImageDisplayModeProcessor.changeBackgroudImageDisplayMode(repository, image, "image");
        } else {
            object = repository.getSessionID();
            int n2 = WebUtils.getHTTPRequestIntParameter((HttpServletRequest)repository.getHttpServletRequest(), (String)"reportIndex", (int)0);
            string = ImageDataUrlCacheManager.getInstance().getImageDataUrl((String)object, n2, point);
            if (string == null) {
                string = repository.checkoutObject(image, "image");
            }
        }
        object = (Browser)repository.getBrowser();
        if (bl && ((Browser)object).isLowIEVersionQuicksModel()) {
            tag.css("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + string + "',sizingMethod='image')");
        } else if (repository.getDevice().isMobile()) {
            tag.css("background", string);
        } else {
            tag.css("background-image", "url(" + string + ")");
            tag.css("background-repeat", "no-repeat");
            if (((Browser)object).isLowIEVersionQuicksModel() && !bl) {
                tag.css("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + string + "',sizingMethod='scale')");
            }
        }
    }

    public static Tag createImageTag4RepoWithCheckVml(Image image, Dimension dimension, Repository repository) {
        Tag tag = BaseHTMLWriterUtils.createNormaImageTag(image, dimension, repository);
        if (repository.getBrowser().shouldConsiderVML()) {
            tag.attr("onload", "FR.correctPNG(this)");
        }
        return tag;
    }

    public static Tag createImageTagFromParentTag4RepoWithCheckVml(Image image, Dimension dimension, Repository repository, Tag tag) {
        JSONObject jSONObject;
        if (tag == null) {
            return BaseHTMLWriterUtils.createImageTag4RepoWithCheckVml(image, dimension, repository);
        }
        String string = tag.getAttr("cv");
        try {
            jSONObject = string != null ? new JSONObject(string) : JSONObject.create();
        }
        catch (Exception exception) {
            jSONObject = JSONObject.create();
        }
        if (jSONObject.opt("attach_id") != null) {
            ServletURLTransformer servletURLTransformer = (ServletURLTransformer)ExtraClassManager.getInstance().getSingle("ServletURLTransformer");
            String string2 = repository.getServletURL();
            if (servletURLTransformer != null) {
                string2 = servletURLTransformer.prefixForImage(string2, "image");
            }
            return new Tag("img").css("width", dimension.width + "px").css("height", dimension.height + "px").css("border", "0").attr("src", string2 + "?op=fr_attach&cmd=ah_image&id=" + jSONObject.opt("attach_id"));
        }
        return BaseHTMLWriterUtils.createImageTag4RepoWithCheckVml(image, dimension, repository);
    }

    public static Tag createImageTag4RepoWithoutCheckVml(Image image, Dimension dimension, Repository repository) {
        return BaseHTMLWriterUtils.createNormaImageTag(image, dimension, repository);
    }

    public static Tag createEmptyImageTag4RepoWithoutCheckVml(Dimension dimension, Repository repository) {
        return BaseHTMLWriterUtils.createNormaImageTag(null, dimension, repository);
    }

    private static Tag createNormaImageTag(Image image, Dimension dimension, Repository repository) {
        return new Tag("img").css("width", dimension.width + "px").css("height", dimension.height + "px").css("border", "0").attr("src", image == null ? repository.checkoutObject(null, "image") : repository.checkoutObject(image, "image"));
    }
}

