/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.events;

import com.fr.third.javax.xml.namespace.NamespaceContext;
import com.fr.third.javax.xml.namespace.QName;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.events.Attribute;
import com.fr.third.javax.xml.stream.events.DummyEvent;
import com.fr.third.javax.xml.stream.events.Namespace;
import com.fr.third.javax.xml.stream.events.StartElement;
import com.fr.third.javax.xml.stream.util.ReadOnlyIterator;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StartElementEvent
extends DummyEvent
implements StartElement {
    private Map fAttributes;
    private List fNamespaces;
    private NamespaceContext fNamespaceContext = null;
    private QName fQName;

    public StartElementEvent(String string, String string2, String string3) {
        this(new QName(string2, string3, string));
    }

    public StartElementEvent(QName qName) {
        this.fQName = qName;
        this.init();
    }

    public StartElementEvent(StartElement startElement) {
        this(startElement.getName());
        this.addAttributes(startElement.getAttributes());
        this.addNamespaceAttributes(startElement.getNamespaces());
    }

    protected void init() {
        this.setEventType(1);
        this.fAttributes = new HashMap();
        this.fNamespaces = new ArrayList();
    }

    public QName getName() {
        return this.fQName;
    }

    public void setName(QName qName) {
        this.fQName = qName;
    }

    public Iterator getAttributes() {
        if (this.fAttributes != null) {
            Collection collection = this.fAttributes.values();
            return new ReadOnlyIterator(collection.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Iterator getNamespaces() {
        if (this.fNamespaces != null) {
            return new ReadOnlyIterator(this.fNamespaces.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Attribute getAttributeByName(QName qName) {
        if (qName == null) {
            return null;
        }
        return (Attribute)this.fAttributes.get(qName);
    }

    public String getNamespace() {
        return this.fQName.getNamespaceURI();
    }

    public String getNamespaceURI(String string) {
        if (this.getNamespace() != null && this.fQName.getPrefix().equals(string)) {
            return this.getNamespace();
        }
        if (this.fNamespaceContext != null) {
            return this.fNamespaceContext.getNamespaceURI(string);
        }
        return null;
    }

    public String toString() {
        Attribute attribute;
        Iterator iterator;
        String string = "<" + this.nameAsString();
        if (this.fAttributes != null) {
            iterator = this.getAttributes();
            attribute = null;
            while (iterator.hasNext()) {
                attribute = (Attribute)iterator.next();
                string = String.valueOf(string) + " " + attribute.toString();
            }
        }
        if (this.fNamespaces != null) {
            iterator = this.fNamespaces.iterator();
            attribute = null;
            while (iterator.hasNext()) {
                attribute = (Namespace)iterator.next();
                string = String.valueOf(string) + " " + attribute.toString();
            }
        }
        string = String.valueOf(string) + ">";
        return string;
    }

    public String nameAsString() {
        if ("".equals(this.fQName.getNamespaceURI())) {
            return this.fQName.getLocalPart();
        }
        if (this.fQName.getPrefix() != null) {
            return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getPrefix() + ":" + this.fQName.getLocalPart();
        }
        return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getLocalPart();
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.fNamespaceContext = namespaceContext;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
    }

    void addAttribute(Attribute attribute) {
        if (attribute.isNamespace()) {
            this.fNamespaces.add(attribute);
        } else {
            this.fAttributes.put(attribute.getName(), attribute);
        }
    }

    /*
     * Unable to fully structure code
     */
    void addAttributes(Iterator var1_1) {
        if (var1_1 != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (Attribute)var1_1.next();
            this.fAttributes.put(var2_2.getName(), var2_2);
lbl6:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl7:
        // 1 sources

    }

    void addNamespaceAttribute(Namespace namespace) {
        if (namespace == null) {
            return;
        }
        this.fNamespaces.add(namespace);
    }

    /*
     * Unable to fully structure code
     */
    void addNamespaceAttributes(Iterator var1_1) {
        if (var1_1 != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (Namespace)var1_1.next();
            this.fNamespaces.add(var2_2);
lbl6:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl7:
        // 1 sources

    }
}

