/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.XMLEventReader;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.XMLStreamReader;
import com.fr.third.javax.xml.stream.events.EntityReference;
import com.fr.third.javax.xml.stream.events.XMLEvent;
import com.fr.third.javax.xml.stream.events.XMLEventAllocatorImpl;
import com.fr.third.javax.xml.stream.util.XMLEventAllocator;
import java.util.NoSuchElementException;

public class XMLEventReaderImpl
implements XMLEventReader {
    protected XMLStreamReader fXMLReader;
    protected XMLEventAllocator fXMLEventAllocator;
    private XMLEvent fPeekedEvent;
    private XMLEvent fLastEvent;

    public XMLEventReaderImpl(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.fXMLReader = xMLStreamReader;
        this.fXMLEventAllocator = (XMLEventAllocator)xMLStreamReader.getProperty("com.fr.third.javax.xml.stream.allocator");
        if (this.fXMLEventAllocator == null) {
            this.fXMLEventAllocator = new XMLEventAllocatorImpl();
        }
        this.fPeekedEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
    }

    public boolean hasNext() {
        if (this.fPeekedEvent != null) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.fXMLReader.hasNext();
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
        return bl;
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            this.fLastEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            return this.fLastEvent;
        }
        if (this.fXMLReader.hasNext()) {
            this.fXMLReader.next();
            this.fLastEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
            return this.fLastEvent;
        }
        this.fLastEvent = null;
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws XMLStreamException {
        this.fXMLReader.close();
    }

    public String getElementText() throws XMLStreamException {
        if (this.fLastEvent.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.fLastEvent.getLocation());
        }
        if (this.fPeekedEvent != null) {
            XMLEvent xMLEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            int n2 = xMLEvent.getEventType();
            String string = null;
            if (n2 == 4 || n2 == 6 || n2 == 12) {
                string = xMLEvent.asCharacters().getData();
            } else if (n2 == 9) {
                string = ((EntityReference)xMLEvent).getDeclaration().getReplacementText();
            } else if (n2 != 5 && n2 != 3) {
                if (n2 == 1) {
                    throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", xMLEvent.getLocation());
                }
                if (n2 == 2) {
                    return "";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            xMLEvent = this.nextEvent();
            while (xMLEvent.getEventType() != 2) {
                if (n2 == 4 || n2 == 6 || n2 == 12) {
                    string = xMLEvent.asCharacters().getData();
                } else if (n2 == 9) {
                    string = ((EntityReference)xMLEvent).getDeclaration().getReplacementText();
                } else if (n2 != 5 && n2 != 3) {
                    if (n2 == 8) {
                        throw new XMLStreamException("unexpected end of document when reading element text content");
                    }
                    if (n2 == 1) {
                        throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", xMLEvent.getLocation());
                    }
                    throw new XMLStreamException("Unexpected event type " + n2, xMLEvent.getLocation());
                }
                if (string == null || string.length() <= 0) continue;
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return this.fXMLReader.getElementText();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.fXMLReader.getProperty(string);
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            XMLEvent xMLEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            int n2 = xMLEvent.getEventType();
            if (xMLEvent.isCharacters() && xMLEvent.asCharacters().isWhiteSpace() || n2 == 3 || n2 == 5) {
                xMLEvent = this.nextEvent();
                n2 = xMLEvent.getEventType();
            }
            while (xMLEvent.isCharacters() && xMLEvent.asCharacters().isWhiteSpace() || n2 == 3 || n2 == 5) {
                xMLEvent = this.nextEvent();
                n2 = xMLEvent.getEventType();
            }
            if (n2 != 1 && n2 != 2) {
                throw new XMLStreamException("expected start or end tag", xMLEvent.getLocation());
            }
            return xMLEvent;
        }
        this.fXMLReader.nextTag();
        return this.fXMLEventAllocator.allocate(this.fXMLReader);
    }

    public Object next() {
        XMLEvent xMLEvent = null;
        try {
            xMLEvent = this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            this.fLastEvent = null;
            throw new NoSuchElementException();
        }
        return xMLEvent;
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            return this.fPeekedEvent;
        }
        if (this.hasNext()) {
            this.fXMLReader.next();
            this.fPeekedEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
            return this.fPeekedEvent;
        }
        return null;
    }
}

