/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.Entity;
import com.fr.third.javax.xml.stream.PropertyManager;
import com.fr.third.javax.xml.stream.StaxEntityResolverWrapper;
import com.fr.third.javax.xml.stream.StaxXMLInputSource;
import com.fr.third.javax.xml.stream.XMLEntityHandler;
import com.fr.third.javax.xml.stream.XMLEntityReader;
import com.fr.third.javax.xml.stream.XMLEntityReaderImpl;
import com.fr.third.javax.xml.stream.XMLEntityStorage;
import com.fr.third.javax.xml.stream.XMLErrorReporter;
import com.fr.third.javax.xml.stream.xerces.impl.io.ASCIIReader;
import com.fr.third.javax.xml.stream.xerces.impl.io.UCSReader;
import com.fr.third.javax.xml.stream.xerces.impl.io.UTF8Reader;
import com.fr.third.javax.xml.stream.xerces.util.EncodingMap;
import com.fr.third.javax.xml.stream.xerces.util.SymbolTable;
import com.fr.third.javax.xml.stream.xerces.util.URI;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import com.fr.third.javax.xml.stream.xerces.util.XMLResourceIdentifierImpl;
import com.fr.third.javax.xml.stream.xerces.xni.XMLResourceIdentifier;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponent;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLConfigurationException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLEntityResolver;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

public class XMLEntityManager
implements XMLComponent,
XMLEntityResolver {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    public static final int DEFAULT_INTERNAL_BUFFER_SIZE = 1024;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String STAX_ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/stax-entity-resolver";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String BUFFER_SIZE = "http://apache.org/xml/properties/input-buffer-size";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/warn-on-duplicate-entitydef"};
    private static final Boolean[] FEATURE_DEFAULTS;
    private static final String[] RECOGNIZED_PROPERTIES;
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String XMLEntity;
    private static final String DTDEntity;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_ENTITIES = false;
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_RESOLVER = false;
    protected boolean fValidation;
    protected boolean fExternalGeneralEntities;
    protected boolean fExternalParameterEntities;
    protected boolean fAllowJavaEncodings = true;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected StaxEntityResolverWrapper fStaxEntityResolver;
    protected PropertyManager fPropertyManager;
    protected int fBufferSize = 8192;
    protected boolean fStandalone;
    protected boolean fInExternalSubset = false;
    protected XMLEntityHandler fEntityHandler;
    protected XMLEntityReaderImpl fEntityReader;
    protected Hashtable fEntities = new Hashtable();
    protected Stack fEntityStack = new Stack();
    protected Entity.ScannedEntity fCurrentEntity = null;
    protected Hashtable fDeclaredEntities;
    protected XMLEntityStorage fEntityStorage;
    protected final Object[] defaultEncoding;
    private final XMLResourceIdentifierImpl fResourceIdentifier;
    protected Vector fOwnReaders;
    private static String gUserDir;
    private static String gEscapedUserDir;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    static {
        Boolean[] booleanArray = new Boolean[5];
        booleanArray[1] = Boolean.TRUE;
        booleanArray[2] = Boolean.TRUE;
        booleanArray[3] = Boolean.FALSE;
        booleanArray[4] = Boolean.FALSE;
        FEATURE_DEFAULTS = booleanArray;
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ENTITY_RESOLVER, VALIDATION_MANAGER, BUFFER_SIZE};
        Object[] objectArray = new Object[5];
        objectArray[4] = new Integer(8192);
        PROPERTY_DEFAULTS = objectArray;
        XMLEntity = "[xml]".intern();
        DTDEntity = "[dtd]".intern();
        gNeedEscaping = new boolean[32857];
        gAfterEscaping1 = new char[32857];
        gAfterEscaping2 = new char[32857];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n2 = 0;
        while (n2 <= 31) {
            XMLEntityManager.gNeedEscaping[n2] = true;
            XMLEntityManager.gAfterEscaping1[n2] = gHexChs[n2 >> 4];
            XMLEntityManager.gAfterEscaping2[n2] = gHexChs[n2 & 0xF];
            ++n2;
        }
        XMLEntityManager.gNeedEscaping[127] = true;
        XMLEntityManager.gAfterEscaping1[127] = 55;
        XMLEntityManager.gAfterEscaping2[127] = 70;
        char[] cArray = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3) {
            char c2 = cArray[n4];
            XMLEntityManager.gNeedEscaping[c2] = true;
            XMLEntityManager.gAfterEscaping1[c2] = gHexChs[c2 >> 4];
            XMLEntityManager.gAfterEscaping2[c2] = gHexChs[c2 & 0xF];
            ++n4;
        }
    }

    public XMLEntityManager() {
        Object[] objectArray = new Object[2];
        objectArray[0] = "UTF-8";
        this.defaultEncoding = objectArray;
        this.fResourceIdentifier = new XMLResourceIdentifierImpl();
        this.fOwnReaders = new Vector();
        this.fEntityStorage = new XMLEntityStorage(this);
        this.fEntityReader = new XMLEntityReaderImpl(this);
    }

    public XMLEntityManager(PropertyManager propertyManager) {
        Object[] objectArray = new Object[2];
        objectArray[0] = "UTF-8";
        this.defaultEncoding = objectArray;
        this.fResourceIdentifier = new XMLResourceIdentifierImpl();
        this.fOwnReaders = new Vector();
        this.fPropertyManager = propertyManager;
        this.fEntityStorage = new XMLEntityStorage(this);
        this.fEntityReader = new XMLEntityReaderImpl(propertyManager, this);
        this.reset(propertyManager);
    }

    public XMLEntityStorage getEntityStore() {
        return this.fEntityStorage;
    }

    public XMLEntityReader getEntityReader() {
        return this.fEntityReader;
    }

    public void setStandalone(boolean bl) {
        this.fStandalone = bl;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public void setEntityHandler(XMLEntityHandler xMLEntityHandler) {
        this.fEntityHandler = xMLEntityHandler;
    }

    public StaxXMLInputSource resolveEntityAsPerStax(XMLResourceIdentifier xMLResourceIdentifier) throws IOException {
        boolean bl;
        if (xMLResourceIdentifier == null) {
            return null;
        }
        String string = xMLResourceIdentifier.getPublicId();
        String string2 = xMLResourceIdentifier.getLiteralSystemId();
        String string3 = xMLResourceIdentifier.getBaseSystemId();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        boolean bl2 = bl = string4 == null;
        if (string3 == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null && (string3 = this.fCurrentEntity.entityLocation.getExpandedSystemId()) != null) {
            bl = true;
        }
        if (bl) {
            string4 = XMLEntityManager.expandSystemId(string2, string3);
        }
        StaxXMLInputSource staxXMLInputSource = null;
        if (this.fStaxEntityResolver != null) {
            XMLResourceIdentifierImpl xMLResourceIdentifierImpl = null;
            if (xMLResourceIdentifier instanceof XMLResourceIdentifierImpl) {
                xMLResourceIdentifierImpl = (XMLResourceIdentifierImpl)xMLResourceIdentifier;
            } else {
                this.fResourceIdentifier.clear();
                xMLResourceIdentifierImpl = this.fResourceIdentifier;
            }
            xMLResourceIdentifierImpl.setValues(string, string2, string3, string4);
            staxXMLInputSource = this.fStaxEntityResolver.resolveEntity(xMLResourceIdentifierImpl);
        }
        if (staxXMLInputSource == null) {
            staxXMLInputSource = new StaxXMLInputSource(new XMLInputSource(string, string2, string3));
        } else if (!staxXMLInputSource.hasXMLStreamOrXMLEventReader()) {
            // empty if block
        }
        return staxXMLInputSource;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws IOException, XNIException {
        boolean bl;
        if (xMLResourceIdentifier == null) {
            return null;
        }
        String string = xMLResourceIdentifier.getPublicId();
        String string2 = xMLResourceIdentifier.getLiteralSystemId();
        String string3 = xMLResourceIdentifier.getBaseSystemId();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        boolean bl2 = bl = string4 == null;
        if (string3 == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null && (string3 = this.fCurrentEntity.entityLocation.getExpandedSystemId()) != null) {
            bl = true;
        }
        if (bl) {
            string4 = XMLEntityManager.expandSystemId(string2, string3);
        }
        XMLInputSource xMLInputSource = null;
        if (this.fEntityResolver != null) {
            XMLResourceIdentifierImpl xMLResourceIdentifierImpl = null;
            if (xMLResourceIdentifier instanceof XMLResourceIdentifierImpl) {
                xMLResourceIdentifierImpl = (XMLResourceIdentifierImpl)xMLResourceIdentifier;
            } else {
                this.fResourceIdentifier.clear();
                xMLResourceIdentifierImpl = this.fResourceIdentifier;
            }
            xMLResourceIdentifierImpl.setValues(string, string2, string3, string4);
            xMLInputSource = this.fEntityResolver.resolveEntity(xMLResourceIdentifierImpl);
        }
        if (xMLInputSource == null) {
            xMLInputSource = new XMLInputSource(string, string2, string3);
        }
        return xMLInputSource;
    }

    public void startEntity(String string, boolean bl) throws IOException, XNIException {
        int n2;
        int n3;
        Entity entity = (Entity)this.fEntityStorage.getDeclaredEntities().get(string);
        if (entity == null) {
            if (this.fEntityHandler != null) {
                String string2 = null;
                this.fResourceIdentifier.clear();
                this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string2);
                this.fEntityHandler.endEntity(string);
            }
            return;
        }
        boolean bl2 = entity.isExternal();
        if (bl2) {
            n3 = entity.isUnparsed();
            n2 = string.startsWith("%") ? 1 : 0;
            boolean bl3 = n2 == 0;
            this.fExternalGeneralEntities = bl2;
            if (n3 != 0 || bl3 && !this.fExternalGeneralEntities || n2 != 0 && !this.fExternalParameterEntities) {
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String string3 = null;
                    Entity.ExternalEntity externalEntity = (Entity.ExternalEntity)entity;
                    String string4 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String string5 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String string6 = XMLEntityManager.expandSystemId(string4, string5);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, string4, string5, string6);
                    this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string3);
                    this.fEntityHandler.endEntity(string);
                }
                return;
            }
        }
        n2 = n3 = this.fEntityStack.size();
        while (n2 >= 0) {
            Entity entity2;
            Entity entity3 = entity2 = n2 == n3 ? this.fCurrentEntity : (Entity)this.fEntityStack.elementAt(n2);
            if (entity2.name == string) {
                String string7 = string;
                int n4 = n2 + 1;
                while (n4 < n3) {
                    entity2 = (Entity)this.fEntityStack.elementAt(n4);
                    string7 = String.valueOf(string7) + " -> " + entity2.name;
                    ++n4;
                }
                string7 = String.valueOf(string7) + " -> " + this.fCurrentEntity.name;
                string7 = String.valueOf(string7) + " -> " + string;
                this.fErrorReporter.reportError(this.getEntityReader(), "http://www.w3.org/TR/1998/REC-xml-19980210", "RecursiveReference", new Object[]{string, string7}, (short)2);
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String string8 = null;
                    if (bl2) {
                        Entity.ExternalEntity externalEntity = (Entity.ExternalEntity)entity;
                        String string9 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                        String string10 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                        String string11 = XMLEntityManager.expandSystemId(string9, string10);
                        this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, string9, string10, string11);
                    }
                    this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string8);
                    this.fEntityHandler.endEntity(string);
                }
                return;
            }
            --n2;
        }
        StaxXMLInputSource staxXMLInputSource = null;
        XMLInputSource xMLInputSource = null;
        if (bl2) {
            Entity.ExternalEntity externalEntity = (Entity.ExternalEntity)entity;
            staxXMLInputSource = this.resolveEntityAsPerStax(externalEntity.entityLocation);
            xMLInputSource = staxXMLInputSource.getXMLInputSource();
        } else {
            Entity.InternalEntity internalEntity = (Entity.InternalEntity)entity;
            StringReader stringReader = new StringReader(internalEntity.text);
            xMLInputSource = new XMLInputSource(null, null, null, stringReader, null);
        }
        this.startEntity(string, xMLInputSource, bl, bl2);
    }

    public void startDocumentEntity(XMLInputSource xMLInputSource) throws IOException, XNIException {
        this.startEntity(XMLEntity, xMLInputSource, false, true);
    }

    public void startDTDEntity(XMLInputSource xMLInputSource) throws IOException, XNIException {
        this.startEntity(DTDEntity, xMLInputSource, false, true);
    }

    public void startExternalSubset() {
        this.fInExternalSubset = true;
    }

    public void endExternalSubset() {
        this.fInExternalSubset = false;
    }

    public void startEntity(String string, XMLInputSource xMLInputSource, boolean bl, boolean bl2) throws IOException, XNIException {
        String string2 = xMLInputSource.getPublicId();
        String string3 = xMLInputSource.getSystemId();
        String string4 = xMLInputSource.getBaseSystemId();
        String string5 = xMLInputSource.getEncoding();
        Boolean bl3 = null;
        InputStream inputStream = null;
        Reader reader = xMLInputSource.getCharacterStream();
        String string6 = XMLEntityManager.expandSystemId(string3, string4);
        if (string4 == null) {
            string4 = string6;
        }
        if (reader == null) {
            inputStream = xMLInputSource.getByteStream();
            if (inputStream == null) {
                inputStream = new BufferedInputStream(new URL(string6).openStream());
            }
            inputStream = new RewindableInputStream(inputStream);
            if (string5 == null) {
                byte[] byArray = new byte[4];
                int n2 = 0;
                while (n2 < 4) {
                    byArray[n2] = (byte)inputStream.read();
                    ++n2;
                }
                if (n2 == 4) {
                    Object[] objectArray = this.getEncodingName(byArray, n2);
                    string5 = (String)objectArray[0];
                    bl3 = (Boolean)objectArray[1];
                    inputStream.reset();
                    boolean bl4 = false;
                    if (n2 > 2 && string5.equals("UTF-8")) {
                        int n3 = byArray[0] & 0xFF;
                        int n4 = byArray[1] & 0xFF;
                        int n5 = byArray[2] & 0xFF;
                        if (n3 == 239 && n4 == 187 && n5 == 191) {
                            inputStream.skip(3L);
                        }
                    }
                    reader = this.createReader(inputStream, string5, bl3);
                } else {
                    reader = this.createReader(inputStream, string5, bl3);
                }
            } else {
                reader = this.createReader(inputStream, string5, bl3);
            }
        }
        if (this.fCurrentEntity != null) {
            this.fEntityStack.push(this.fCurrentEntity);
        }
        this.fCurrentEntity = new Entity.ScannedEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, string6), inputStream, reader, string5, bl, false, bl2);
        this.fEntityReader.setCurrentEntity(this.fCurrentEntity);
        this.fResourceIdentifier.setValues(string2, string3, string4, string6);
        if (this.fEntityHandler != null) {
            this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string5);
        }
    }

    public Entity.ScannedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    public void closeReaders() {
        int n2 = this.fOwnReaders.size() - 1;
        while (n2 >= 0) {
            try {
                ((Reader)this.fOwnReaders.elementAt(n2)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            --n2;
        }
        this.fOwnReaders.removeAllElements();
    }

    public void endEntity() throws IOException, XNIException {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.endEntity(this.fCurrentEntity.name);
        }
        if (this.fCurrentEntity != null) {
            try {
                this.fCurrentEntity.close();
            }
            catch (IOException iOException) {
                throw new XNIException(iOException);
            }
        }
        this.fCurrentEntity = this.fEntityStack.size() > 0 ? (Entity.ScannedEntity)this.fEntityStack.pop() : null;
        this.fEntityReader.setCurrentEntity(this.fCurrentEntity);
    }

    public void reset(PropertyManager propertyManager) {
        this.fEntityStorage.reset(propertyManager);
        this.fEntityReader.reset(propertyManager);
        this.fSymbolTable = (SymbolTable)propertyManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        try {
            this.fStaxEntityResolver = (StaxEntityResolverWrapper)propertyManager.getProperty(STAX_ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fStaxEntityResolver = null;
        }
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fCurrentEntity = null;
        this.fValidation = false;
        this.fExternalGeneralEntities = false;
        this.fExternalParameterEntities = false;
        this.fAllowJavaEncodings = true;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fExternalGeneralEntities = xMLComponentManager.getFeature(EXTERNAL_GENERAL_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalGeneralEntities = true;
        }
        try {
            this.fExternalParameterEntities = xMLComponentManager.getFeature(EXTERNAL_PARAMETER_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalParameterEntities = true;
        }
        try {
            this.fAllowJavaEncodings = xMLComponentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fAllowJavaEncodings = false;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        try {
            this.fStaxEntityResolver = (StaxEntityResolverWrapper)xMLComponentManager.getProperty(STAX_ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fStaxEntityResolver = null;
        }
        this.fStandalone = false;
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fCurrentEntity = null;
        if (this.fDeclaredEntities != null) {
            Enumeration enumeration = this.fDeclaredEntities.keys();
            while (enumeration.hasMoreElements()) {
                Object k2 = enumeration.nextElement();
                Object v2 = this.fDeclaredEntities.get(k2);
                this.fEntities.put(k2, v2);
            }
        }
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        String string2;
        if (string.startsWith("http://apache.org/xml/features/") && (string2 = string.substring("http://apache.org/xml/features/".length())).equals("allow-java-encodings")) {
            this.fAllowJavaEncodings = bl;
        }
    }

    public void setProperty(String string, Object object) {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public Boolean getFeatureDefault(String string) {
        int n2 = 0;
        while (n2 < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n2].equals(string)) {
                return FEATURE_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n2 = 0;
        while (n2 < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n2].equals(string)) {
                return PROPERTY_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public static String expandSystemId(String string) {
        return XMLEntityManager.expandSystemId(string, null);
    }

    private static synchronized String getUserDir() {
        int n2;
        String string = "";
        try {
            string = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.equals(gUserDir)) {
            return gEscapedUserDir;
        }
        gUserDir = string;
        char c2 = File.separatorChar;
        string = string.replace(c2, '/');
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 * 3);
        if (n3 >= 2 && string.charAt(1) == ':' && (n2 = (int)Character.toUpperCase(string.charAt(0))) >= 65 && n2 <= 90) {
            stringBuffer.append('/');
        }
        n2 = 0;
        while (n2 < n3) {
            char c3 = string.charAt(n2);
            if (c3 >= '\u0080') break;
            if (gNeedEscaping[c3]) {
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[c3]);
                stringBuffer.append(gAfterEscaping2[c3]);
            } else {
                stringBuffer.append(c3);
            }
            ++n2;
        }
        if (n2 < n3) {
            byte[] byArray = null;
            try {
                byArray = string.substring(n2).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            n3 = byArray.length;
            n2 = 0;
            while (n2 < n3) {
                byte by = byArray[n2];
                if (by < 0) {
                    int n4 = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n4 >> 4]);
                    stringBuffer.append(gHexChs[n4 & 0xF]);
                } else if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                } else {
                    stringBuffer.append((char)by);
                }
                ++n2;
            }
        }
        if (!string.endsWith("/")) {
            stringBuffer.append('/');
        }
        gEscapedUserDir = stringBuffer.toString();
        return gEscapedUserDir;
    }

    public static String expandSystemId(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = XMLEntityManager.fixURI(string);
        URI uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string3 = XMLEntityManager.getUserDir();
                uRI = new URI("file", "", string3, null, null);
            } else {
                try {
                    uRI = new URI(XMLEntityManager.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", XMLEntityManager.fixURI(string2), null, null);
                    }
                    String string4 = XMLEntityManager.getUserDir();
                    string4 = String.valueOf(string4) + XMLEntityManager.fixURI(string2);
                    uRI = new URI("file", "", string4, null, null);
                }
            }
            uRI2 = new URI(uRI, (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    protected Object[] getEncodingName(byte[] byArray, int n2) {
        if (n2 < 2) {
            return this.defaultEncoding;
        }
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        if (n3 == 254 && n4 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n3 == 255 && n4 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 < 3) {
            return this.defaultEncoding;
        }
        int n5 = byArray[2] & 0xFF;
        if (n3 == 239 && n4 == 187 && n5 == 191) {
            return this.defaultEncoding;
        }
        if (n2 < 4) {
            return this.defaultEncoding;
        }
        int n6 = byArray[3] & 0xFF;
        if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n3 == 60 && n4 == 0 && n5 == 0 && n6 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (n3 == 0 && n4 == 0 && n5 == 60 && n6 == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ISO-10646-UCS-4";
            return objectArray;
        }
        if (n3 == 0 && n4 == 60 && n5 == 0 && n6 == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ISO-10646-UCS-4";
            return objectArray;
        }
        if (n3 == 0 && n4 == 60 && n5 == 0 && n6 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n3 == 60 && n4 == 0 && n5 == 63 && n6 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n3 == 76 && n4 == 111 && n5 == 167 && n6 == 148) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "CP037";
            return objectArray;
        }
        return this.defaultEncoding;
    }

    protected Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException {
        String string2;
        String string3;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string3 = string.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string3.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string3.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            this.fErrorReporter.reportError(this.getEntityReader(), "http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        if (string3.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            this.fErrorReporter.reportError(this.getEntityReader(), "http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            this.fErrorReporter.reportError(this.getEntityReader(), "http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
            string = "ISO-8859-1";
        }
        if ((string2 = EncodingMap.getIANA2JavaMapping(string3)) == null) {
            if (this.fAllowJavaEncodings) {
                string2 = string;
            } else {
                this.fErrorReporter.reportError(this.getEntityReader(), "http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
                string2 = "ISO8859_1";
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream, string2));
    }

    public String getPublicId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getPublicId() : null;
    }

    public String getExpandedSystemId() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.entityLocation != null && this.fCurrentEntity.entityLocation.getExpandedSystemId() != null) {
                return this.fCurrentEntity.entityLocation.getExpandedSystemId();
            }
            int n2 = this.fEntityStack.size();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                Entity.ScannedEntity scannedEntity = (Entity.ScannedEntity)this.fEntityStack.elementAt(n3);
                if (scannedEntity.entityLocation != null && scannedEntity.entityLocation.getExpandedSystemId() != null) {
                    return scannedEntity.entityLocation.getExpandedSystemId();
                }
                --n3;
            }
        }
        return null;
    }

    public String getLiteralSystemId() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.entityLocation != null && this.fCurrentEntity.entityLocation.getLiteralSystemId() != null) {
                return this.fCurrentEntity.entityLocation.getLiteralSystemId();
            }
            int n2 = this.fEntityStack.size();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                Entity.ScannedEntity scannedEntity = (Entity.ScannedEntity)this.fEntityStack.elementAt(n3);
                if (scannedEntity.entityLocation != null && scannedEntity.entityLocation.getLiteralSystemId() != null) {
                    return scannedEntity.entityLocation.getLiteralSystemId();
                }
                --n3;
            }
        }
        return null;
    }

    public int getLineNumber() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.lineNumber;
            }
            int n2 = this.fEntityStack.size();
            int n3 = n2 - 1;
            while (n3 > 0) {
                Entity.ScannedEntity scannedEntity = (Entity.ScannedEntity)this.fEntityStack.elementAt(n3);
                if (scannedEntity.isExternal()) {
                    return scannedEntity.lineNumber;
                }
                --n3;
            }
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.columnNumber;
            }
            int n2 = this.fEntityStack.size();
            int n3 = n2 - 1;
            while (n3 > 0) {
                Entity.ScannedEntity scannedEntity = (Entity.ScannedEntity)this.fEntityStack.elementAt(n3);
                if (scannedEntity.isExternal()) {
                    return scannedEntity.columnNumber;
                }
                --n3;
            }
        }
        return -1;
    }

    protected static String fixURI(String string) {
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2) {
            char c2 = string.charAt(1);
            if (c2 == ':') {
                char c3 = Character.toUpperCase(string.charAt(0));
                if (c3 >= 'A' && c3 <= 'Z') {
                    string = "/" + string;
                }
            } else if (c2 == '/' && string.charAt(0) == '/') {
                string = "file:" + string;
            }
        }
        return string;
    }

    final void print() {
    }

    public void test() {
        this.fEntityStorage.addExternalEntity("entityUsecase1", null, "/space/home/stax/sun/6thJan2004/zephyr/data/test.txt", "/space/home/stax/sun/6thJan2004/zephyr/data/entity.xml");
        this.fEntityStorage.addInternalEntity("entityUsecase2", "<Test>value</Test>");
        this.fEntityStorage.addInternalEntity("entityUsecase3", "value3");
        this.fEntityStorage.addInternalEntity("text", "Hello World.");
        this.fEntityStorage.addInternalEntity("empty-element", "<foo/>");
        this.fEntityStorage.addInternalEntity("balanced-element", "<foo></foo>");
        this.fEntityStorage.addInternalEntity("balanced-element-with-text", "<foo>Hello, World</foo>");
        this.fEntityStorage.addInternalEntity("balanced-element-with-entity", "<foo>&text;</foo>");
        this.fEntityStorage.addInternalEntity("unbalanced-entity", "<foo>");
        this.fEntityStorage.addInternalEntity("recursive-entity", "<foo>&recursive-entity2;</foo>");
        this.fEntityStorage.addInternalEntity("recursive-entity2", "<bar>&recursive-entity3;</bar>");
        this.fEntityStorage.addInternalEntity("recursive-entity3", "<baz>&recursive-entity;</baz>");
        this.fEntityStorage.addInternalEntity("ch", "&#x00A9;");
        this.fEntityStorage.addInternalEntity("ch1", "&#84;");
        this.fEntityStorage.addInternalEntity("% ch2", "param");
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream inputStream) {
            this.fInputStream = inputStream;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int n2) {
            this.fStartOffset = n2;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int n2 = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] byArray = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
                this.fData = byArray;
            }
            if ((n2 = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)n2;
            ++this.fOffset;
            return n2 & 0xFF;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.fLength - this.fOffset;
            if (n4 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.read(byArray, n2, n3);
            }
            if (n3 < n4) {
                if (n3 <= 0) {
                    return 0;
                }
            } else {
                n3 = n4;
            }
            if (byArray != null) {
                System.arraycopy(this.fData, this.fOffset, byArray, n2, n3);
            }
            this.fOffset += n3;
            return n3;
        }

        public long skip(long l2) throws IOException {
            if (l2 <= 0L) {
                return 0L;
            }
            int n2 = this.fLength - this.fOffset;
            if (n2 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(l2);
            }
            if (l2 <= (long)n2) {
                this.fOffset = (int)((long)this.fOffset + l2);
                return l2;
            }
            this.fOffset += n2;
            if (this.fOffset == this.fEndOffset) {
                return n2;
            }
            return this.fInputStream.skip(l2 -= (long)n2) + (long)n2;
        }

        public int available() throws IOException {
            int n2 = this.fLength - this.fOffset;
            if (n2 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return XMLEntityManager.this.fCurrentEntity.mayReadChunks ? this.fInputStream.available() : 0;
            }
            return n2;
        }

        public void mark(int n2) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }
}

