/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.BufferManager;
import com.fr.third.javax.xml.stream.xerces.impl.io.ASCIIReader;
import com.fr.third.javax.xml.stream.xerces.impl.io.UCSReader;
import com.fr.third.javax.xml.stream.xerces.impl.io.UTF8Reader;
import com.fr.third.javax.xml.stream.xerces.util.EncodingMap;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Locale;

public class StreamBufferManager
extends BufferManager {
    static final int DEFAULT_LENGTH = 8192;
    static final boolean DEBUG = false;
    CharBuffer charBuffer = null;
    Reader fReader = null;
    boolean fAllowJavaEncodings = true;

    public StreamBufferManager(InputStream inputStream, String string) throws IOException {
        this.init(inputStream, string);
    }

    void init(InputStream inputStream, String string) throws IOException {
        Boolean bl = null;
        RewindableInputStream rewindableInputStream = new RewindableInputStream(inputStream);
        if (string == null) {
            byte[] byArray = new byte[4];
            int n2 = 0;
            while (n2 < 4) {
                byArray[n2] = (byte)((InputStream)rewindableInputStream).read();
                ++n2;
            }
            if (n2 == 4) {
                Object[] objectArray = this.getEncodingName(byArray, n2);
                string = (String)objectArray[0];
                bl = (Boolean)objectArray[1];
                ((InputStream)rewindableInputStream).reset();
                boolean bl2 = false;
                if (n2 > 2 && string.equals("UTF-8")) {
                    int n3 = byArray[0] & 0xFF;
                    int n4 = byArray[1] & 0xFF;
                    int n5 = byArray[2] & 0xFF;
                    if (n3 == 239 && n4 == 187 && n5 == 191) {
                        ((InputStream)rewindableInputStream).skip(3L);
                    }
                }
                this.fReader = this.createReader(rewindableInputStream, string, bl);
            } else {
                this.fReader = this.createReader(rewindableInputStream, string, bl);
            }
        } else {
            this.fReader = this.createReader(rewindableInputStream, string, bl);
        }
        this.charBuffer = CharBuffer.allocate(8192);
    }

    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    public boolean getMore() throws IOException {
        int n2;
        char[] cArray;
        int n3;
        if (this.charBuffer.position() != 0) {
            this.charBuffer.compact();
        }
        if ((n3 = this.fReader.read(cArray = this.charBuffer.array(), n2 = this.charBuffer.position(), this.charBuffer.capacity())) == -1) {
            this.endOfStream = true;
            return false;
        }
        this.charBuffer = CharBuffer.wrap(cArray);
        this.charBuffer.limit(n3);
        return n3 > 0;
    }

    protected Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException {
        String string2;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string2 = string.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, 8192, null, Locale.getDefault());
        }
        if (string2.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, 8192, null, Locale.getDefault());
        }
        if (string2.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            throw new IOException("Encoding byte order not supported");
        }
        if (string2.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            throw new IOException("Encoding byte order not supported");
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            throw new IOException("Encoding declaration " + string + "not valid");
        }
        String string3 = EncodingMap.getIANA2JavaMapping(string2);
        if (string3 == null) {
            if (this.fAllowJavaEncodings) {
                string3 = string;
            } else {
                throw new IOException("Encoding " + string + " not supported");
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream, string3));
    }

    int getLength() {
        return 8192;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            System.out.println("url parameter = " + file.toURI().toString());
            URL uRL = new URL(file.toURI().toString());
            StreamBufferManager streamBufferManager = new StreamBufferManager(uRL.openStream(), "UTF-8");
            CharBuffer charBuffer = streamBufferManager.getCharBuffer();
            int n2 = 0;
            while (streamBufferManager.getMore()) {
                System.out.println("Loop " + n2++ + " = " + streamBufferManager.getCharBuffer());
            }
            System.out.println("End of stream reached = " + streamBufferManager.endOfStream());
            System.out.println("Total no. of loops required = " + n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }

    public void setEncoding(String string) throws IOException {
    }

    public boolean arrangeCapacity(int n2) throws IOException {
        return false;
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;
        static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;

        public RewindableInputStream(InputStream inputStream) {
            this.fInputStream = inputStream;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int n2) {
            this.fStartOffset = n2;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int n2 = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] byArray = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
                this.fData = byArray;
            }
            if ((n2 = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)n2;
            ++this.fOffset;
            return n2 & 0xFF;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.fLength - this.fOffset;
            if (n4 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.read(byArray, n2, n3);
            }
            if (n3 < n4) {
                if (n3 <= 0) {
                    return 0;
                }
            } else {
                n3 = n4;
            }
            if (byArray != null) {
                System.arraycopy(this.fData, this.fOffset, byArray, n2, n3);
            }
            this.fOffset += n3;
            return n3;
        }

        public long skip(long l2) throws IOException {
            if (l2 <= 0L) {
                return 0L;
            }
            int n2 = this.fLength - this.fOffset;
            if (n2 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(l2);
            }
            if (l2 <= (long)n2) {
                this.fOffset = (int)((long)this.fOffset + l2);
                return l2;
            }
            this.fOffset += n2;
            if (this.fOffset == this.fEndOffset) {
                return n2;
            }
            return this.fInputStream.skip(l2 -= (long)n2) + (long)n2;
        }

        public int available() throws IOException {
            int n2 = this.fLength - this.fOffset;
            if (n2 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.available();
            }
            return n2;
        }

        public void mark(int n2) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }
}

