/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr;

import com.fr.third.antlr.Alternative;
import com.fr.third.antlr.AlternativeBlock;
import com.fr.third.antlr.BlockWithImpliedExitPath;
import com.fr.third.antlr.CharFormatter;
import com.fr.third.antlr.CodeGenerator;
import com.fr.third.antlr.Grammar;
import com.fr.third.antlr.JavaCharFormatter;
import com.fr.third.antlr.Lookahead;
import com.fr.third.antlr.RuleBlock;
import com.fr.third.antlr.RuleRefElement;
import com.fr.third.antlr.Tool;
import com.fr.third.antlr.ToolErrorHandler;

class DefaultToolErrorHandler
implements ToolErrorHandler {
    private final Tool antlrTool;
    CharFormatter javaCharFormatter = new JavaCharFormatter();

    DefaultToolErrorHandler(Tool tool) {
        this.antlrTool = tool;
    }

    private void dumpSets(String[] stringArray, int n2, Grammar grammar, boolean bl, int n3, Lookahead[] lookaheadArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i2 = 1; i2 <= n3; ++i2) {
            stringBuffer.append("k==").append(i2).append(':');
            if (bl) {
                String string = lookaheadArray[i2].fset.toStringWithRanges(",", this.javaCharFormatter);
                if (lookaheadArray[i2].containsEpsilon()) {
                    stringBuffer.append("<end-of-token>");
                    if (string.length() > 0) {
                        stringBuffer.append(',');
                    }
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append(lookaheadArray[i2].fset.toString(",", grammar.tokenManager.getVocabulary()));
            }
            stringArray[n2++] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
    }

    public void warnAltAmbiguity(Grammar grammar, AlternativeBlock alternativeBlock, boolean bl, int n2, Lookahead[] lookaheadArray, int n3, int n4) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (alternativeBlock instanceof RuleBlock && ((RuleBlock)alternativeBlock).isLexerAutoGenRule()) {
            stringArray = alternativeBlock.getAlternativeAt(n3);
            Alternative alternative = alternativeBlock.getAlternativeAt(n4);
            RuleRefElement ruleRefElement = (RuleRefElement)stringArray.head;
            RuleRefElement ruleRefElement2 = (RuleRefElement)alternative.head;
            String string = CodeGenerator.reverseLexerRuleName(ruleRefElement.targetRule);
            String string2 = CodeGenerator.reverseLexerRuleName(ruleRefElement2.targetRule);
            stringBuffer.append("lexical nondeterminism between rules ");
            stringBuffer.append(string).append(" and ").append(string2).append(" upon");
        } else {
            if (bl) {
                stringBuffer.append("lexical ");
            }
            stringBuffer.append("nondeterminism between alts ");
            stringBuffer.append(n3 + 1).append(" and ");
            stringBuffer.append(n4 + 1).append(" of block upon");
        }
        stringArray = new String[n2 + 1];
        stringArray[0] = stringBuffer.toString();
        this.dumpSets(stringArray, 1, grammar, bl, n2, lookaheadArray);
        this.antlrTool.warning(stringArray, grammar.getFilename(), alternativeBlock.getLine(), alternativeBlock.getColumn());
    }

    public void warnAltExitAmbiguity(Grammar grammar, BlockWithImpliedExitPath blockWithImpliedExitPath, boolean bl, int n2, Lookahead[] lookaheadArray, int n3) {
        String[] stringArray = new String[n2 + 2];
        stringArray[0] = (bl ? "lexical " : "") + "nondeterminism upon";
        this.dumpSets(stringArray, 1, grammar, bl, n2, lookaheadArray);
        stringArray[n2 + 1] = "between alt " + (n3 + 1) + " and exit branch of block";
        this.antlrTool.warning(stringArray, grammar.getFilename(), blockWithImpliedExitPath.getLine(), blockWithImpliedExitPath.getColumn());
    }
}

