/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoderImpl;
import com.fr.third.JAI.JPEGEncodeParam;
import com.fr.third.JAI.JaiI18N;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class JPEGImageEncoder
extends ImageEncoderImpl {
    private JPEGEncodeParam jaiEP = null;

    public JPEGImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (imageEncodeParam != null) {
            this.jaiEP = (JPEGEncodeParam)imageEncodeParam;
        }
    }

    static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam2, int n2) {
        int n3;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = jPEGEncodeParam.getHorizontalSubsampling(i2);
            jPEGEncodeParam2.setHorizontalSubsampling(i2, n3);
            n3 = jPEGEncodeParam.getVerticalSubsampling(i2);
            jPEGEncodeParam2.setVerticalSubsampling(i2, n3);
            if (!jPEGEncodeParam.isQTableSet(i2)) continue;
            int[] nArray = jPEGEncodeParam.getQTable(i2);
            n3 = jPEGEncodeParam.getQTableSlot(i2);
            jPEGEncodeParam2.setQTableComponentMapping(i2, n3);
            jPEGEncodeParam2.setQTable(n3, new JPEGQTable(nArray));
        }
        if (jPEGEncodeParam.isQualitySet()) {
            float f2 = jPEGEncodeParam.getQuality();
            jPEGEncodeParam2.setQuality(f2, true);
        }
        n3 = jPEGEncodeParam.getRestartInterval();
        jPEGEncodeParam2.setRestartInterval(n3);
        if (jPEGEncodeParam.getWriteTablesOnly()) {
            jPEGEncodeParam2.setImageInfoValid(false);
            jPEGEncodeParam2.setTableInfoValid(true);
        }
        if (jPEGEncodeParam.getWriteImageOnly()) {
            jPEGEncodeParam2.setTableInfoValid(false);
            jPEGEncodeParam2.setImageInfoValid(true);
        }
        if (!jPEGEncodeParam.getWriteJFIFHeader()) {
            jPEGEncodeParam2.setMarkerData(224, (byte[][])null);
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        BufferedImage bufferedImage;
        IndexColorModel indexColorModel;
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n2 = colorModel.getNumColorComponents();
        int n3 = sampleModel.getTransferType();
        if (n3 != 0 || n2 != 1 && n2 != 3) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageEncoder0"));
        }
        int n4 = colorModel.getColorSpace().getType();
        if (n4 != 6 && n4 != 5) {
            throw new Error(JaiI18N.getString("JPEGImageEncoder1"));
        }
        WritableRaster writableRaster = (WritableRaster)renderedImage.getData();
        if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
            writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            bufferedImage = indexColorModel.convertToIntDiscrete(writableRaster, false);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        } else {
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        }
        if (this.jaiEP != null) {
            JPEGImageEncoder.modifyEncodeParam(this.jaiEP, jPEGEncodeParam, n2);
        }
        indexColorModel = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
        try {
            indexColorModel.encode(bufferedImage);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

