/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.JPEGDecodeParam;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.NoMarkStream;
import com.fr.third.JAI.SimpleRenderedImage;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class JPEGImage
extends SimpleRenderedImage {
    private static final Object LOCK = new Object();
    private Raster theTile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPEGImage(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (inputStream.markSupported()) {
            inputStream = new NoMarkStream(inputStream);
        }
        BufferedImage bufferedImage = null;
        Object object = LOCK;
        synchronized (object) {
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
            try {
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            }
            catch (ImageFormatException imageFormatException) {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder1"));
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder2"));
            }
        }
        this.minX = 0;
        this.minY = 0;
        this.tileWidth = this.width = bufferedImage.getWidth();
        this.tileHeight = this.height = bufferedImage.getHeight();
        if ((imageDecodeParam == null || imageDecodeParam instanceof JPEGDecodeParam && ((JPEGDecodeParam)imageDecodeParam).getDecodeToCSM()) && !(bufferedImage.getSampleModel() instanceof ComponentSampleModel)) {
            int n2 = -1;
            int n3 = bufferedImage.getSampleModel().getNumBands();
            if (n3 == 1) {
                n2 = 10;
            } else if (n3 == 3) {
                n2 = 5;
            } else if (n3 == 4) {
                n2 = 6;
            } else {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder3"));
            }
            BufferedImage bufferedImage2 = new BufferedImage(this.width, this.height, n2);
            bufferedImage2.getWritableTile(0, 0).setRect(bufferedImage.getWritableTile(0, 0));
            bufferedImage2.releaseWritableTile(0, 0);
            bufferedImage = bufferedImage2;
        }
        this.sampleModel = bufferedImage.getSampleModel();
        this.colorModel = bufferedImage.getColorModel();
        this.theTile = bufferedImage.getWritableTile(0, 0);
    }

    public synchronized Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGImageDecoder4"));
        }
        return this.theTile;
    }
}

