/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.GIFImage;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoderImpl;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class GIFImageDecoder
extends ImageDecoderImpl {
    private byte[] globalColorTable = null;
    private boolean maxPageFound = false;
    private int maxPage;
    private int prevPage = -1;
    private int prevSyncedPage = -1;
    private HashMap images = new HashMap();

    private static byte[] readHeader(SeekableStream seekableStream) throws IOException {
        byte[] byArray = null;
        try {
            seekableStream.skipBytes(10);
            int n2 = seekableStream.readUnsignedByte();
            boolean bl = (n2 & 0x80) != 0;
            int n3 = 1 << (n2 & 7) + 1;
            int n4 = seekableStream.readUnsignedByte();
            seekableStream.read();
            if (bl) {
                byArray = new byte[3 * n3];
                seekableStream.readFully(byArray);
            } else {
                byArray = null;
            }
        }
        catch (IOException iOException) {
            throw new IOException(JaiI18N.getString("GIFImageDecoder0"));
        }
        return byArray;
    }

    public GIFImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        super(seekableStream, imageDecodeParam);
    }

    public GIFImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        super(inputStream, imageDecodeParam);
    }

    public int getNumPages() throws IOException {
        int n2 = this.prevPage + 1;
        while (!this.maxPageFound) {
            try {
                this.decodeAsRenderedImage(n2++);
            }
            catch (IOException iOException) {}
        }
        return this.maxPage + 1;
    }

    public synchronized RenderedImage decodeAsRenderedImage(int n2) throws IOException {
        if (n2 < 0 || this.maxPageFound && n2 > this.maxPage) {
            throw new IOException(JaiI18N.getString("GIFImageDecoder1"));
        }
        Integer n3 = new Integer(n2);
        if (this.images.containsKey(n3)) {
            return (RenderedImage)this.images.get(n3);
        }
        if (this.prevPage == -1) {
            try {
                this.globalColorTable = GIFImageDecoder.readHeader(this.input);
            }
            catch (IOException iOException) {
                this.maxPageFound = true;
                this.maxPage = -1;
                throw iOException;
            }
        }
        if (n2 > 0) {
            int n4 = this.prevSyncedPage + 1;
            while (n4 < n2) {
                RenderedImage renderedImage = (RenderedImage)this.images.get(new Integer(n4));
                renderedImage.getTile(0, 0);
                this.prevSyncedPage = n4++;
            }
        }
        GIFImage gIFImage = null;
        while (this.prevPage < n2) {
            int n5 = this.prevPage + 1;
            GIFImage gIFImage2 = null;
            try {
                gIFImage2 = new GIFImage(this.input, this.globalColorTable);
                this.images.put(new Integer(n5), gIFImage2);
                if (n5 < n2) {
                    gIFImage2.getTile(0, 0);
                    this.prevSyncedPage = n5;
                }
                this.prevPage = n5;
                if (n5 != n2) continue;
                gIFImage = gIFImage2;
                break;
            }
            catch (IOException iOException) {
                this.maxPageFound = true;
                this.maxPage = this.prevPage;
                throw iOException;
            }
        }
        return gIFImage;
    }
}

