/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.BMPEncodeParam;
import com.fr.third.JAI.BMPImageDecoder;
import com.fr.third.JAI.BMPImageEncoder;
import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BMPCodec
extends ImageCodec {
    public String getFormatName() {
        return "bmp";
    }

    public Class getEncodeParamClass() {
        return BMPEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return Object.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getTransferType();
        if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (!(imageEncodeParam instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
            int n3 = bMPEncodeParam.getVersion();
            if (n3 == 0 || n3 == 2) {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        BMPEncodeParam bMPEncodeParam = null;
        if (imageEncodeParam != null) {
            bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
        }
        return new BMPImageEncoder(outputStream, bMPEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder(inputStream, null);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new BMPImageDecoder(new FileInputStream(file), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder((InputStream)seekableStream, null);
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 66 && byArray[1] == 77;
    }
}

