/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.pinyin;

import com.fr.stable.pinyin.ChineseHelper;
import com.fr.stable.pinyin.PinyinChar;
import com.fr.stable.pinyin.PinyinFormat;
import com.fr.stable.pinyin.PinyinResource;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;

public class PinyinHelper {
    private static final Properties PINYIN_TABLE = PinyinResource.getPinyinTable();
    private static final Properties MUTIL_PINYIN_TABLE = PinyinResource.getMultiPinyinTable();
    private static final String PINYIN_SEPARATOR = ",";
    private static final int TONE_SUM = 4;
    private static final int VOWEL_UPPER_INDEX = 477;
    private static final String ALL_UNMARKED_VOWEL = "aeiouv";
    private static final String ALL_MARKED_VOWEL = "\u0101\u00e1\u01ce\u00e0\u0113\u00e9\u011b\u00e8\u012b\u00ed\u01d0\u00ec\u014d\u00f3\u01d2\u00f2\u016b\u00fa\u01d4\u00f9\u01d6\u01d8\u01da\u01dc";
    private static final String[] NULL = null;
    private static PinyinChar[] vowelsMap = new PinyinChar[477];

    private static String[] convertWithToneNumber(String string) {
        String[] stringArray = string.split(PINYIN_SEPARATOR);
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            boolean bl = false;
            String string2 = stringArray[i2].replaceAll("\u00fc", "v");
            for (int i3 = string2.length() - 1; i3 >= 0; --i3) {
                char c2 = string2.charAt(i3);
                if (c2 >= 'a' && c2 <= 'z') continue;
                int n2 = ALL_MARKED_VOWEL.indexOf(c2);
                int n3 = n2 % 4 + 1;
                char c3 = ALL_UNMARKED_VOWEL.charAt((n2 - n2 % 4) / 4);
                stringArray[i2] = string2.replaceAll(String.valueOf(c2), String.valueOf(c3)) + n3;
                bl = true;
                break;
            }
            if (bl) continue;
            stringArray[i2] = string2 + "5";
        }
        return stringArray;
    }

    private static String[] convertWithoutTone(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\u01dd' || vowelsMap[c2] == null) continue;
            cArray[i2] = vowelsMap[c2].charValue();
        }
        String[] stringArray = new String(cArray).split(PINYIN_SEPARATOR);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collections.addAll(linkedHashSet, stringArray);
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private static String[] formatPinyin(String string, PinyinFormat pinyinFormat) {
        if (pinyinFormat == PinyinFormat.WITH_TONE_MARK) {
            return string.split(PINYIN_SEPARATOR);
        }
        if (pinyinFormat == PinyinFormat.WITH_TONE_NUMBER) {
            return PinyinHelper.convertWithToneNumber(string);
        }
        if (pinyinFormat == PinyinFormat.WITHOUT_TONE) {
            return PinyinHelper.convertWithoutTone(string);
        }
        return NULL;
    }

    public static String[] convertToPinyinArray(char c2, PinyinFormat pinyinFormat) {
        String string = PINYIN_TABLE.getProperty(String.valueOf(c2));
        if (string != null && !string.equals("null")) {
            return PinyinHelper.formatPinyin(string, pinyinFormat);
        }
        return NULL;
    }

    public static String[] convertToPinyinArray(char c2) {
        return PinyinHelper.convertToPinyinArray(c2, PinyinFormat.WITH_TONE_MARK);
    }

    public static String convertToPinyinString(String string, String string2, PinyinFormat pinyinFormat) {
        string = ChineseHelper.convertToSimplifiedChinese(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (ChineseHelper.isChinese(c2)) {
                int n3;
                boolean bl = false;
                int n4 = 3;
                int n5 = n3 = i2 + n4 < n2 ? i2 + n4 : n2 - 1;
                while (n3 > i2) {
                    String string3 = string.substring(i2, n3 + 1);
                    if (MUTIL_PINYIN_TABLE.containsKey(string3)) {
                        String[] stringArray = PinyinHelper.formatPinyin(MUTIL_PINYIN_TABLE.getProperty(string3), pinyinFormat);
                        int n6 = stringArray.length;
                        for (int i3 = 0; i3 < n6; ++i3) {
                            stringBuilder.append(stringArray[i3]);
                            if (i3 >= n6 - 1) continue;
                            stringBuilder.append(string2);
                        }
                        i2 = n3;
                        bl = true;
                        break;
                    }
                    --n3;
                }
                if (!bl) {
                    String[] stringArray = PinyinHelper.convertToPinyinArray(string.charAt(i2), pinyinFormat);
                    if (stringArray != null) {
                        stringBuilder.append(stringArray[0]);
                    } else {
                        stringBuilder.append(string.charAt(i2));
                    }
                }
                if (i2 >= n2 - 1) continue;
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c2);
            if (i2 + 1 >= n2 || !ChineseHelper.isChinese(string.charAt(i2 + 1))) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String convertToPinyinString(String string, String string2) {
        return PinyinHelper.convertToPinyinString(string, string2, PinyinFormat.WITH_TONE_MARK);
    }

    public static boolean hasMultiPinyin(char c2) {
        String[] stringArray = PinyinHelper.convertToPinyinArray(c2);
        return stringArray != null && stringArray.length > 1;
    }

    public static String getShortPinyin(String string) {
        String string2 = "#";
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[string.length()];
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] stringArray;
            char c2 = string.charAt(i2);
            if (!ChineseHelper.isChinese(c2)) {
                cArray[i2] = c2;
                continue;
            }
            stringBuilder.append(c2);
            for (int i3 = i2 + 1; i3 < n2 && ChineseHelper.isChinese(string.charAt(i3)); ++i3) {
                stringBuilder.append(string.charAt(i3));
            }
            String string3 = PinyinHelper.convertToPinyinString(stringBuilder.toString(), string2, PinyinFormat.WITHOUT_TONE);
            for (String string4 : stringArray = string3.split(string2)) {
                cArray[i2] = string4.charAt(0);
                ++i2;
            }
            --i2;
            stringBuilder.delete(0, stringBuilder.toString().length());
            stringBuilder.trimToSize();
        }
        return String.valueOf(cArray);
    }

    public static boolean isChinese(char c2) {
        return ChineseHelper.isChinese(c2);
    }

    public static Object parseCNToPinyin(String string) {
        if (ChineseHelper.containChinese(string)) {
            return PinyinHelper.convertToPinyinString(string, "", PinyinFormat.WITHOUT_TONE);
        }
        return string;
    }

    static {
        char[] cArray = ALL_MARKED_VOWEL.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            PinyinHelper.vowelsMap[cArray[i2]] = new PinyinChar(ALL_UNMARKED_VOWEL.charAt((i2 - i2 % 4) / 4));
            PinyinHelper.vowelsMap[252] = new PinyinChar('v');
        }
    }
}

