/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.io;

public class EndianUtils {
    public static short swapShort(short s2) {
        return (short)((s2 & 0xFF00) >> 8 | (s2 & 0xFF) << 8);
    }

    public static int swapInteger(int n2) {
        return (n2 & 0xFF000000) >> 24 | (n2 & 0xFF0000) >> 8 | (n2 & 0xFF00) << 8 | (n2 & 0xFF) << 24;
    }

    public static long swapLong(long l2) {
        return (l2 & 0xFF00000000000000L) >> 56 | (l2 & 0xFF000000000000L) >> 40 | (l2 & 0xFF0000000000L) >> 24 | (l2 & 0xFF00000000L) >> 8 | (l2 & 0xFF000000L) << 8 | (l2 & 0xFF0000L) << 24 | (l2 & 0xFF00L) << 40 | (l2 & 0xFFL) << 56;
    }

    public static float swapFloat(float f2) {
        int n2 = Float.floatToIntBits(f2);
        n2 = EndianUtils.swapInteger(n2);
        return Float.intBitsToFloat(n2);
    }

    public static double swapDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        l2 = EndianUtils.swapLong(l2);
        return Double.longBitsToDouble(l2);
    }
}

