/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.codec.bmp;

import com.fr.stable.image4j.codec.bmp.BMPImage;
import com.fr.stable.image4j.codec.bmp.ColorEntry;
import com.fr.stable.image4j.codec.bmp.InfoHeader;
import com.fr.stable.image4j.io.LittleEndianInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BMPDecoder {
    private BufferedImage img;
    private InfoHeader infoHeader;

    public BMPDecoder(InputStream inputStream) throws IOException {
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(inputStream);
        byte[] byArray = new byte[2];
        littleEndianInputStream.read(byArray);
        String string = new String(byArray, "UTF-8");
        if (!string.equals("BM")) {
            throw new IOException("Invalid signature '" + string + "' for BMP format");
        }
        int n2 = littleEndianInputStream.readIntLE();
        int n3 = littleEndianInputStream.readIntLE();
        int n4 = littleEndianInputStream.readIntLE();
        this.infoHeader = BMPDecoder.readInfoHeader(littleEndianInputStream);
        this.img = BMPDecoder.read(this.infoHeader, littleEndianInputStream);
    }

    private static int getBit(int n2, int n3) {
        return n2 >> 7 - n3 & 1;
    }

    private static int getNibble(int n2, int n3) {
        return n2 >> 4 * (1 - n3) & 0xF;
    }

    public InfoHeader getInfoHeader() {
        return this.infoHeader;
    }

    public BufferedImage getBufferedImage() {
        return this.img;
    }

    private static void getColorTable(ColorEntry[] colorEntryArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < colorEntryArray.length; ++i2) {
            byArray[i2] = (byte)colorEntryArray[i2].bRed;
            byArray2[i2] = (byte)colorEntryArray[i2].bGreen;
            byArray3[i2] = (byte)colorEntryArray[i2].bBlue;
        }
    }

    public static InfoHeader readInfoHeader(LittleEndianInputStream littleEndianInputStream) throws IOException {
        InfoHeader infoHeader = new InfoHeader(littleEndianInputStream);
        return infoHeader;
    }

    public static InfoHeader readInfoHeader(LittleEndianInputStream littleEndianInputStream, int n2) throws IOException {
        InfoHeader infoHeader = new InfoHeader(littleEndianInputStream, n2);
        return infoHeader;
    }

    public static BufferedImage read(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = null;
        ColorEntry[] colorEntryArray = null;
        if (infoHeader.sBitCount <= 8) {
            colorEntryArray = BMPDecoder.readColorTable(infoHeader, littleEndianInputStream);
        }
        bufferedImage = BMPDecoder.read(infoHeader, littleEndianInputStream, colorEntryArray);
        return bufferedImage;
    }

    public static BufferedImage read(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        BufferedImage bufferedImage = null;
        if (infoHeader.sBitCount == 1 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read1(infoHeader, littleEndianInputStream, colorEntryArray);
        } else if (infoHeader.sBitCount == 4 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read4(infoHeader, littleEndianInputStream, colorEntryArray);
        } else if (infoHeader.sBitCount == 8 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read8(infoHeader, littleEndianInputStream, colorEntryArray);
        } else if (infoHeader.sBitCount == 24 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read24(infoHeader, littleEndianInputStream);
        } else if (infoHeader.sBitCount == 32 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read32(infoHeader, littleEndianInputStream);
        } else {
            throw new IOException("Unrecognized bitmap format: bit count=" + infoHeader.sBitCount + ", compression=" + infoHeader.iCompression);
        }
        return bufferedImage;
    }

    public static ColorEntry[] readColorTable(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        ColorEntry[] colorEntryArray = new ColorEntry[infoHeader.iNumColors];
        for (int i2 = 0; i2 < infoHeader.iNumColors; ++i2) {
            ColorEntry colorEntry;
            colorEntryArray[i2] = colorEntry = new ColorEntry(littleEndianInputStream);
        }
        return colorEntryArray;
    }

    public static BufferedImage read1(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        int n2;
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BMPDecoder.getColorTable(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = infoHeader.iWidth;
        if (n3 % 32 != 0) {
            n3 = (n3 / 32 + 1) * 32;
        }
        int n4 = n3 - n2;
        int n5 = n4 / 8;
        int n6 = n3 / 8;
        int[] nArray = new int[n6];
        for (int i2 = infoHeader.iHeight - 1; i2 >= 0; --i2) {
            int n7;
            for (n7 = 0; n7 < n6; ++n7) {
                nArray[n7] = littleEndianInputStream.readUnsignedByte();
            }
            for (n7 = 0; n7 < infoHeader.iWidth; ++n7) {
                int n8 = n7 / 8;
                int n9 = nArray[n8];
                int n10 = n7 % 8;
                int n11 = BMPDecoder.getBit(n9, n10);
                writableRaster.setSample(n7, i2, 0, n11);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read4(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BMPDecoder.getColorTable(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(4, infoHeader.iNumColors, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = infoHeader.iWidth * 4;
        if (n2 % 32 != 0) {
            n2 = (n2 / 32 + 1) * 32;
        }
        int n3 = n2 / 8;
        int[] nArray = new int[n3];
        for (int i2 = infoHeader.iHeight - 1; i2 >= 0; --i2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                nArray[n5] = n4 = littleEndianInputStream.readUnsignedByte();
            }
            for (n5 = 0; n5 < infoHeader.iWidth; ++n5) {
                n4 = n5 / 2;
                int n6 = n5 % 2;
                int n7 = nArray[n4];
                int n8 = BMPDecoder.getNibble(n7, n6);
                writableRaster.setSample(n5, i2, 0, n8);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read8(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        int n2;
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BMPDecoder.getColorTable(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(8, infoHeader.iNumColors, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = infoHeader.iWidth;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 - n2;
        for (int i2 = infoHeader.iHeight - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < infoHeader.iWidth; ++i3) {
                int n5 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n5);
            }
            littleEndianInputStream.skipBytes(n4);
        }
        return bufferedImage;
    }

    public static BufferedImage read24(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = infoHeader.iWidth * 3;
        int n3 = n2;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 - n2;
        for (int i2 = infoHeader.iHeight - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < infoHeader.iWidth; ++i3) {
                int n5 = littleEndianInputStream.readUnsignedByte();
                int n6 = littleEndianInputStream.readUnsignedByte();
                int n7 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n7);
                writableRaster.setSample(i3, i2, 1, n6);
                writableRaster.setSample(i3, i2, 2, n5);
            }
            littleEndianInputStream.skipBytes(n4);
        }
        return bufferedImage;
    }

    public static BufferedImage read32(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
        for (int i2 = infoHeader.iHeight - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < infoHeader.iWidth; ++i3) {
                int n2 = littleEndianInputStream.readUnsignedByte();
                int n3 = littleEndianInputStream.readUnsignedByte();
                int n4 = littleEndianInputStream.readUnsignedByte();
                int n5 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n4);
                writableRaster.setSample(i3, i2, 1, n3);
                writableRaster.setSample(i3, i2, 2, n2);
                writableRaster2.setSample(i3, i2, 0, n5);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read(File file) throws IOException {
        return BMPDecoder.read(new FileInputStream(file));
    }

    public static BufferedImage read(InputStream inputStream) throws IOException {
        BMPDecoder bMPDecoder = new BMPDecoder(inputStream);
        return bMPDecoder.getBufferedImage();
    }

    public static BMPImage readExt(File file) throws IOException {
        return BMPDecoder.readExt(new FileInputStream(file));
    }

    public static BMPImage readExt(InputStream inputStream) throws IOException {
        BMPDecoder bMPDecoder = new BMPDecoder(inputStream);
        BMPImage bMPImage = new BMPImage(bMPDecoder.getBufferedImage(), bMPDecoder.getInfoHeader());
        return bMPImage;
    }
}

