/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.core;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorChain
implements Iterator {
    private Iterator[] iteratorChain = new Iterator[0];
    private int currentIteratorIndex = 0;
    private Iterator currentIterator = null;
    private Iterator lastUsedIterator = null;

    public IteratorChain() {
    }

    public IteratorChain(Iterator[] iteratorArray) {
        if (iteratorArray != null) {
            this.iteratorChain = new Iterator[iteratorArray.length];
            System.arraycopy(iteratorArray, 0, this.iteratorChain, 0, iteratorArray.length);
        }
    }

    public int size() {
        return this.iteratorChain.length;
    }

    private void updateCurrentIterator() {
        if (this.currentIterator == null) {
            if (this.iteratorChain.length == 0) {
                this.currentIterator = EmptyIterator.INSTANCE;
            } else {
                this.currentIterator = this.iteratorChain[this.currentIteratorIndex];
                ++this.currentIteratorIndex;
            }
        } else if (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.length) {
            this.currentIterator = this.iteratorChain[this.currentIteratorIndex];
            ++this.currentIteratorIndex;
        }
    }

    public boolean hasNext() {
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public void remove() {
        if (this.currentIterator == null) {
            this.updateCurrentIterator();
        }
        this.lastUsedIterator.remove();
    }

    private static class EmptyIterator
    implements Iterator {
        private static final EmptyIterator INSTANCE = new EmptyIterator();

        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Iterator contains no elements");
        }

        public void remove() {
            throw new IllegalStateException("Iterator contains no elements");
        }
    }
}

