/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.set;

import com.fr.stable.plugin.closeable.CloseableUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableContainedSet<E, S extends Set>
implements Set<E> {
    private S innerSet;

    public CloseableContainedSet(Class<? extends S> clazz) {
        try {
            this.innerSet = (Set)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    @Override
    public int size() {
        return CloseableUtils.filterSet(this.innerSet).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.innerSet.contains(object) && !CloseableUtils.isClosed(object);
    }

    @Override
    public Iterator<E> iterator() {
        return CloseableUtils.filterSet(this.innerSet).iterator();
    }

    @Override
    public Object[] toArray() {
        return CloseableUtils.filterSet(this.innerSet).toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CloseableUtils.filterSet(this.innerSet).toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        return this.innerSet.add(e2);
    }

    @Override
    public boolean remove(Object object) {
        return this.innerSet.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return CloseableUtils.filterSet(this.innerSet).containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.innerSet.addAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.innerSet.retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.innerSet.removeAll(collection);
    }

    @Override
    public void clear() {
        this.innerSet.clear();
    }
}

