/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.array.LongArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMap<V>
implements Iterable<Entry<V>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    long[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int n2) {
        this(n2, 0.8f);
    }

    public LongMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 63 - Long.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new long[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public LongMap(LongMap<? extends V> longMap) {
        this((int)Math.floor((float)longMap.capacity * longMap.loadFactor), longMap.loadFactor);
        this.stashSize = longMap.stashSize;
        System.arraycopy(longMap.keyTable, 0, this.keyTable, 0, longMap.keyTable.length);
        System.arraycopy(longMap.valueTable, 0, this.valueTable, 0, longMap.valueTable.length);
        this.size = longMap.size;
        this.zeroValue = longMap.zeroValue;
        this.hasZeroValue = longMap.hasZeroValue;
    }

    public V put(long l2, V v2) {
        int n2;
        if (l2 == 0L) {
            V v3 = this.zeroValue;
            this.zeroValue = v2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v3;
        }
        long[] lArray = this.keyTable;
        int n3 = (int)(l2 & (long)this.mask);
        long l3 = lArray[n3];
        if (l3 == l2) {
            V v4 = this.valueTable[n3];
            this.valueTable[n3] = v2;
            return v4;
        }
        int n4 = this.hash2(l2);
        long l4 = lArray[n4];
        if (l4 == l2) {
            V v5 = this.valueTable[n4];
            this.valueTable[n4] = v2;
            return v5;
        }
        int n5 = this.hash3(l2);
        long l5 = lArray[n5];
        if (l5 == l2) {
            V v6 = this.valueTable[n5];
            this.valueTable[n5] = v2;
            return v6;
        }
        int n6 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n6; ++n2) {
            if (lArray[n2] != l2) continue;
            V v7 = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return v7;
        }
        if (l3 == 0L) {
            lArray[n3] = l2;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (l4 == 0L) {
            lArray[n4] = l2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (l5 == 0L) {
            lArray[n5] = l2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(l2, v2, n3, l3, n4, l4, n5, l5);
        return null;
    }

    public void putAll(LongMap<V> longMap) {
        for (Entry<V> entry : longMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(long l2, V v2) {
        if (l2 == 0L) {
            this.zeroValue = v2;
            this.hasZeroValue = true;
            return;
        }
        int n2 = (int)(l2 & (long)this.mask);
        long l3 = this.keyTable[n2];
        if (l3 == 0L) {
            this.keyTable[n2] = l2;
            this.valueTable[n2] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n3 = this.hash2(l2);
        long l4 = this.keyTable[n3];
        if (l4 == 0L) {
            this.keyTable[n3] = l2;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash3(l2);
        long l5 = this.keyTable[n4];
        if (l5 == 0L) {
            this.keyTable[n4] = l2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(l2, v2, n2, l3, n3, l4, n4, l5);
    }

    private void push(long l2, V v2, int n2, long l3, int n3, long l4, int n4, long l5) {
        V v3;
        long l6;
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n5 = this.mask;
        int n6 = 0;
        int n7 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    l6 = l3;
                    v3 = VArray[n2];
                    lArray[n2] = l2;
                    VArray[n2] = v2;
                    break;
                }
                case 1: {
                    l6 = l4;
                    v3 = VArray[n3];
                    lArray[n3] = l2;
                    VArray[n3] = v2;
                    break;
                }
                default: {
                    l6 = l5;
                    v3 = VArray[n4];
                    lArray[n4] = l2;
                    VArray[n4] = v2;
                }
            }
            n2 = (int)(l6 & (long)n5);
            l3 = lArray[n2];
            if (l3 == 0L) {
                lArray[n2] = l6;
                VArray[n2] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(l6);
            l4 = lArray[n3];
            if (l4 == 0L) {
                lArray[n3] = l6;
                VArray[n3] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(l6);
            l5 = lArray[n4];
            if (l5 == 0L) {
                lArray[n4] = l6;
                VArray[n4] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n6 == n7) break;
            l2 = l6;
            v2 = v3;
        }
        this.putStash(l6, v3);
    }

    private void putStash(long l2, V v2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(l2, v2);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = l2;
        this.valueTable[n2] = v2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(long l2) {
        if (l2 == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int n2 = (int)(l2 & (long)this.mask);
        if (this.keyTable[n2] != l2 && this.keyTable[n2 = this.hash2(l2)] != l2 && this.keyTable[n2 = this.hash3(l2)] != l2) {
            return this.getStash(l2, null);
        }
        return this.valueTable[n2];
    }

    public V get(long l2, V v2) {
        if (l2 == 0L) {
            if (!this.hasZeroValue) {
                return v2;
            }
            return this.zeroValue;
        }
        int n2 = (int)(l2 & (long)this.mask);
        if (this.keyTable[n2] != l2 && this.keyTable[n2 = this.hash2(l2)] != l2 && this.keyTable[n2 = this.hash3(l2)] != l2) {
            return this.getStash(l2, v2);
        }
        return this.valueTable[n2];
    }

    private V getStash(long l2, V v2) {
        int n2;
        long[] lArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (lArray[n2] != l2) continue;
            return this.valueTable[n2];
        }
        return v2;
    }

    public V remove(long l2) {
        if (l2 == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            V v2 = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return v2;
        }
        int n2 = (int)(l2 & (long)this.mask);
        if (this.keyTable[n2] == l2) {
            this.keyTable[n2] = 0L;
            V v3 = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v3;
        }
        n2 = this.hash2(l2);
        if (this.keyTable[n2] == l2) {
            this.keyTable[n2] = 0L;
            V v4 = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v4;
        }
        n2 = this.hash3(l2);
        if (this.keyTable[n2] == l2) {
            this.keyTable[n2] = 0L;
            V v5 = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v5;
        }
        return this.removeStash(l2);
    }

    V removeStash(long l2) {
        int n2;
        long[] lArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (lArray[n2] != l2) continue;
            V v2 = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return v2;
        }
        return null;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
            this.valueTable[n2] = this.valueTable[n3];
            this.valueTable[n3] = null;
        } else {
            this.valueTable[n2] = null;
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            lArray[n2] = 0L;
            VArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            long[] lArray = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (n2-- > 0) {
                if (lArray[n2] == 0L || VArray[n2] != null) continue;
                return true;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (VArray[n3] != object) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (!object.equals(VArray[n4])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long l2) {
        if (l2 == 0L) {
            return this.hasZeroValue;
        }
        int n2 = (int)(l2 & (long)this.mask);
        if (this.keyTable[n2] != l2 && this.keyTable[n2 = this.hash2(l2)] != l2 && this.keyTable[n2 = this.hash3(l2)] != l2) {
            return this.containsKeyStash(l2);
        }
        return true;
    }

    private boolean containsKeyStash(long l2) {
        int n2;
        long[] lArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (lArray[n2] != l2) continue;
            return true;
        }
        return false;
    }

    public long findKey(Object object, boolean bl, long l2) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0L;
            }
            long[] lArray = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (n2-- > 0) {
                if (lArray[n2] == 0L || VArray[n2] != null) continue;
                return lArray[n2];
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0L;
            }
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (VArray[n3] != object) continue;
                return this.keyTable[n3];
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0L;
            }
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (!object.equals(VArray[n4])) continue;
                return this.keyTable[n4];
            }
        }
        return l2;
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 63 - Long.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new long[n2 + this.stashCapacity];
        this.valueTable = new Object[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                long l2 = lArray[i2];
                if (l2 == 0L) continue;
                this.putResize(l2, VArray[i2]);
            }
        }
    }

    private int hash2(long l2) {
        return (int)(((l2 *= -1262997959L) ^ l2 >>> this.hashShift) & (long)this.mask);
    }

    private int hash3(long l2) {
        return (int)(((l2 *= -825114047L) ^ l2 >>> this.hashShift) & (long)this.mask);
    }

    public int hashCode() {
        int n2 = 0;
        if (this.hasZeroValue && this.zeroValue != null) {
            n2 += this.zeroValue.hashCode();
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = lArray[i2];
            if (l2 == 0L) continue;
            n2 += (int)(l2 ^ l2 >>> 32) * 31;
            V v2 = VArray[i2];
            if (v2 == null) continue;
            n2 += v2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        LongMap longMap = (LongMap)object;
        if (longMap.size != this.size) {
            return false;
        }
        if (longMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (longMap.zeroValue == null ? this.zeroValue != null : !longMap.zeroValue.equals(this.zeroValue))) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            long l2 = lArray[i2];
            if (l2 == 0L || !((v2 = VArray[i2]) == null ? !longMap.containsKey(l2) || longMap.get(l2) != null : !v2.equals(longMap.get(l2)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        long l2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = lArray.length;
        while (n2-- > 0) {
            l2 = lArray[n2];
            if (l2 == 0L) continue;
            stringBuilder.append(l2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
            break;
        }
        while (n2-- > 0) {
            l2 = lArray[n2];
            if (l2 == 0L) continue;
            stringBuilder.append(", ");
            stringBuilder.append(l2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values<V> values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(LongMap longMap) {
            super(longMap);
        }

        public long next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long l2 = this.nextIndex == -1 ? 0L : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return l2;
        }

        public LongArray toArray() {
            LongArray longArray = new LongArray(true, this.map.size);
            while (this.hasNext) {
                longArray.add(this.next());
            }
            return longArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values<V>
    extends MapIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(LongMap<V> longMap) {
            super(longMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v2 = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return v2;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> entry = new Entry();

        public Entries(LongMap longMap) {
            super(longMap);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long[] lArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0L;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = lArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<V> {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final LongMap<V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(LongMap<V> longMap) {
            this.map = longMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            long[] lArray = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (lArray[this.nextIndex] == 0L) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.zeroValue = null;
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0L;
                    this.map.valueTable[this.currentIndex] = null;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        public long key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

