/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.NoSuchElementException;

public class IntSet {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    int capacity;
    int stashSize;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private IntSetIterator iterator1;
    private IntSetIterator iterator2;

    public IntSet() {
        this(51, 0.8f);
    }

    public IntSet(int n2) {
        this(n2, 0.8f);
    }

    public IntSet(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
    }

    public IntSet(IntSet intSet) {
        this((int)Math.floor((float)intSet.capacity * intSet.loadFactor), intSet.loadFactor);
        this.stashSize = intSet.stashSize;
        System.arraycopy(intSet.keyTable, 0, this.keyTable, 0, intSet.keyTable.length);
        this.size = intSet.size;
        this.hasZeroValue = intSet.hasZeroValue;
    }

    public boolean add(int n2) {
        int n3;
        if (n2 == 0) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            ++this.size;
            return true;
        }
        int[] nArray = this.keyTable;
        int n4 = n2 & this.mask;
        int n5 = nArray[n4];
        if (n5 == n2) {
            return false;
        }
        int n6 = this.hash2(n2);
        int n7 = nArray[n6];
        if (n7 == n2) {
            return false;
        }
        int n8 = this.hash3(n2);
        int n9 = nArray[n8];
        if (n9 == n2) {
            return false;
        }
        int n10 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n10; ++n3) {
            if (nArray[n3] != n2) continue;
            return false;
        }
        if (n5 == 0) {
            nArray[n4] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (n7 == 0) {
            nArray[n6] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (n9 == 0) {
            nArray[n8] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        this.push(n2, n4, n5, n6, n7, n8, n9);
        return true;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray, 0, intArray.size);
    }

    public void addAll(IntArray intArray, int n2, int n3) {
        if (n2 + n3 > intArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n2 + " + " + n3 + " <= " + intArray.size);
        }
        this.addAll(intArray.items, n2, n3);
    }

    public void addAll(int ... nArray) {
        this.addAll(nArray, 0, nArray.length);
    }

    public void addAll(int[] nArray, int n2, int n3) {
        int n4;
        this.ensureCapacity(n3);
        int n5 = n4 + n3;
        for (n4 = n2; n4 < n5; ++n4) {
            this.add(nArray[n4]);
        }
    }

    public void addAll(IntSet intSet) {
        this.ensureCapacity(intSet.size);
        IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext) {
            this.add(intSetIterator.next());
        }
    }

    private void addResize(int n2) {
        if (n2 == 0) {
            this.hasZeroValue = true;
            return;
        }
        int n3 = n2 & this.mask;
        int n4 = this.keyTable[n3];
        if (n4 == 0) {
            this.keyTable[n3] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n2);
        int n6 = this.keyTable[n5];
        if (n6 == 0) {
            this.keyTable[n5] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n7 = this.hash3(n2);
        int n8 = this.keyTable[n7];
        if (n8 == 0) {
            this.keyTable[n7] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, n3, n4, n5, n6, n7, n8);
    }

    private void push(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int[] nArray = this.keyTable;
        int n10 = this.mask;
        int n11 = 0;
        int n12 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n9 = n4;
                    nArray[n3] = n2;
                    break;
                }
                case 1: {
                    n9 = n6;
                    nArray[n5] = n2;
                    break;
                }
                default: {
                    n9 = n8;
                    nArray[n7] = n2;
                }
            }
            n3 = n9 & n10;
            n4 = nArray[n3];
            if (n4 == 0) {
                nArray[n3] = n9;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash2(n9);
            n6 = nArray[n5];
            if (n6 == 0) {
                nArray[n5] = n9;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash3(n9);
            n8 = nArray[n7];
            if (n8 == 0) {
                nArray[n7] = n9;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n11 == n12) break;
            n2 = n9;
        }
        this.addStash(n9);
    }

    private void addStash(int n2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.add(n2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = n2;
        ++this.stashSize;
        ++this.size;
    }

    public boolean remove(int n2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            --this.size;
            return true;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] == n2) {
            this.keyTable[n3] = 0;
            --this.size;
            return true;
        }
        n3 = this.hash2(n2);
        if (this.keyTable[n3] == n2) {
            this.keyTable[n3] = 0;
            --this.size;
            return true;
        }
        n3 = this.hash3(n2);
        if (this.keyTable[n3] == n2) {
            this.keyTable[n3] = 0;
            --this.size;
            return true;
        }
        return this.removeStash(n2);
    }

    boolean removeStash(int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (nArray[n3] != n2) continue;
            this.removeStashIndex(n3);
            --this.size;
            return true;
        }
        return false;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            nArray[n2] = 0;
        }
        this.size = 0;
        this.stashSize = 0;
        this.hasZeroValue = false;
    }

    public boolean contains(int n2) {
        if (n2 == 0) {
            return this.hasZeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.containsKeyStash(n2);
        }
        return true;
    }

    private boolean containsKeyStash(int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (nArray[n3] != n2) continue;
            return true;
        }
        return false;
    }

    public int first() {
        if (this.hasZeroValue) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == 0) continue;
            return nArray[i2];
        }
        throw new IllegalStateException("IntSet is empty.");
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        int[] nArray = this.keyTable;
        this.keyTable = new int[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[i2];
                if (n5 == 0) continue;
                this.addResize(n5);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.keyTable[i2] == 0) continue;
            n2 += this.keyTable[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        IntSet intSet = (IntSet)object;
        if (intSet.size != this.size) {
            return false;
        }
        if (intSet.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.keyTable[i2] == 0 || intSet.contains(this.keyTable[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0");
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public IntSetIterator iterator() {
        if (this.iterator1 == null) {
            this.iterator1 = new IntSetIterator(this);
            this.iterator2 = new IntSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static IntSet with(int ... nArray) {
        IntSet intSet = new IntSet();
        intSet.addAll(nArray);
        return intSet;
    }

    public static class IntSetIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntSet set;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public IntSetIterator(IntSet intSet) {
            this.set = intSet;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.set.keyTable;
            int n2 = this.set.capacity + this.set.stashSize;
            while (++this.nextIndex < n2) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.set.hasZeroValue) {
                this.set.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.set.capacity) {
                    this.set.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.set.keyTable[this.currentIndex] = 0;
                }
            }
            this.currentIndex = -2;
            --this.set.size;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n2 = this.nextIndex == -1 ? 0 : this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n2;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.set.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }
}

