/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;

public class LicUtils {
    public static final String VERSION = "VERSION";
    public static final String MACADDRESS = "MACADDRESS";
    public static final String LOCKSERIAL = "SERIALNUMBER";
    public static final String DEADLINE = "DEADLINE";
    public static final String APPNAME = "APPNAME";
    public static final String APPCONTENT = "APPCONTENT";
    public static final String UUID = "UUID";
    public static final String FS_USER = "FS_USER";
    public static final String MOBILE_FS_USER = "MOBILE_FS_USER";
    public static final String PROJECTNAME = "PROJECTNAME";
    public static final String COMPANYNAME = "COMPANYNAME";
    public static final String CONCURRENCY = "CONCURRENCY";
    public static final String FUNCTION = "FUNCTION";
    public static final String ONLINECHECK = "ONLINECHECK";
    public static final int STATE_PASS_VIRGIN = 0;
    public static final int STATE_PASS_NORMAL = 1;
    public static final int STATE_UNPASSED = 2;
    public static final String ENCODE_KEY = "KEY";
    public static final String REPORTLETCOUNTS = "reportletscount";
    public static final String MUTICONNECTION = "MUTICONNECTION";
    public static final String CHECKFAIL = "FAILPASS";
    public static final String ADDRESSDELIMIER = ",";
    public static final String CORE_CONTEXT = "com.fr.base.FRCoreContext";
    public static final String FILE_NAME = "FineReport.lic";
    private static final long ONE_YEAR_MILLISECOND = 31536000000L;

    public static byte[] getBytes() {
        return (byte[])StableUtils.invokeMethod(CORE_CONTEXT, "getBytes");
    }

    public static void resetBytes() {
        StableUtils.invokeMethod(CORE_CONTEXT, "resetBytes");
    }

    public static void retryLicLock() {
        StableUtils.invokeMethod(CORE_CONTEXT, "retryLicLock");
    }

    public static void decode(byte[] byArray, OutputStream outputStream) {
        StableUtils.invokeMethod(CORE_CONTEXT, "decode", new Class[]{byte[].class, OutputStream.class}, new Object[]{byArray, outputStream});
    }

    public static String getItemFromLic(String string) {
        return LicUtils.getItemFromBytes(StableUtils.getBytes(), string);
    }

    public static JSONObject getJsonFromLic() {
        return LicUtils.getJsonFromBytes(StableUtils.getBytes());
    }

    public static String getLicAsStr() {
        return LicUtils.getLicBytesAsStr(StableUtils.getBytes());
    }

    public static boolean isTempLic() {
        JSONObject jSONObject = LicUtils.getJsonFromLic();
        if (!jSONObject.has(DEADLINE)) {
            return true;
        }
        try {
            return jSONObject.getLong(DEADLINE) - Calendar.getInstance().getTimeInMillis() < 31536000000L;
        }
        catch (JSONException jSONException) {
            return true;
        }
    }

    public static String getLicBytesAsStr(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            LicUtils.decode(byArray, byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static JSONObject getJsonFromBytes(byte[] byArray) {
        JSONObject jSONObject;
        String string = LicUtils.getLicBytesAsStr(byArray);
        try {
            jSONObject = new JSONObject(string);
        }
        catch (Exception exception) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    public static String getItemFromBytes(byte[] byArray, String string) {
        JSONObject jSONObject = LicUtils.getJsonFromBytes(byArray);
        try {
            return jSONObject.has(string) ? (String)jSONObject.get(string) : "";
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    public static String getSoftLockContent() {
        return LicUtils.getSoftLockContent("");
    }

    public static String getSoftLockContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(ProductConstants.getEnvHome() + File.separator + "System");
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2);
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtils.contains(stringBuffer.toString(), string)) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static boolean isMatchOnline() {
        return (Boolean)StableUtils.invokeMethod(CORE_CONTEXT, "onlineMatch");
    }
}

