/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.HandlerMethod;

public class FRException
extends Exception {
    private static final int CODE_TYPE_BIT = 1000;
    private int errorCode;
    private ERROR_TYPE errorType;
    private HandlerMethod handlerMethod;

    public FRException() {
    }

    public FRException(int n2, String string) {
        super(string);
        this.errorCode = n2;
        this.errorType = ERROR_TYPE.getType(n2 / 1000);
    }

    public FRException(int n2, String string, Throwable throwable) {
        super(string, throwable);
        this.errorCode = n2;
        this.errorType = ERROR_TYPE.getType(n2 / 1000);
    }

    public FRException(int n2, Throwable throwable) {
        super(throwable);
        this.errorCode = n2;
        this.errorType = ERROR_TYPE.getType(n2 / 1000);
    }

    private void setErrorType(int n2) {
        this.errorType = ERROR_TYPE.getType(n2);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ERROR_TYPE getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        String string;
        switch (this.errorType) {
            case ERROR_CODE: {
                string = "ERROR CODE";
                break;
            }
            case PROMPT_CODE: {
                string = "PROMPT CODE";
                break;
            }
            default: {
                string = "UNDEFINE CODE";
            }
        }
        return string + ":" + this.errorCode + " " + super.getMessage();
    }

    public synchronized HandlerMethod getHandler() {
        return this.handlerMethod;
    }

    public void setHandlerMethod(HandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERROR_TYPE {
        ERROR_CODE(1),
        PROMPT_CODE(2);

        private int errorType;

        private ERROR_TYPE(int n3) {
            this.errorType = n3;
        }

        public static ERROR_TYPE getType(int n2) {
            for (ERROR_TYPE eRROR_TYPE : ERROR_TYPE.values()) {
                if (n2 != eRROR_TYPE.errorType) continue;
                return eRROR_TYPE;
            }
            return PROMPT_CODE;
        }
    }
}

