/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.poly;

import com.fr.general.ComparatorUtils;
import com.fr.report.block.Block;
import com.fr.report.poly.PolyWorkSheet;
import com.fr.report.poly.TemplateBlock;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UnitRectangle;

public class BlockShiftAction {
    public void shift(UnitRectangle unitRectangle, PolyWorkSheet polyWorkSheet, UnitRectangle unitRectangle2) {
        FU fU;
        if (polyWorkSheet == null || unitRectangle2 == null) {
            return;
        }
        FU fU2 = unitRectangle.width.subtract(unitRectangle2.width);
        if (!fU2.equal_zero()) {
            this.shiftAllBlockInX(polyWorkSheet, fU2, unitRectangle2);
        }
        if (!(fU = unitRectangle.height.subtract(unitRectangle2.height)).equal_zero()) {
            this.shiftAllBlockInY(polyWorkSheet, fU, unitRectangle2);
        }
    }

    private void shiftAllBlockInX(PolyWorkSheet polyWorkSheet, UNIT uNIT, UnitRectangle unitRectangle) {
        FU fU = unitRectangle.x.add(unitRectangle.width);
        int n2 = polyWorkSheet.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateBlock templateBlock = (TemplateBlock)polyWorkSheet.getBlock(i2);
            UnitRectangle unitRectangle2 = templateBlock.getBounds();
            this.shiftX(unitRectangle2, fU, uNIT, templateBlock, polyWorkSheet);
        }
    }

    private void shiftAllBlockInY(PolyWorkSheet polyWorkSheet, UNIT uNIT, UnitRectangle unitRectangle) {
        FU fU = unitRectangle.y.add(unitRectangle.height);
        int n2 = polyWorkSheet.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateBlock templateBlock = (TemplateBlock)polyWorkSheet.getBlock(i2);
            UnitRectangle unitRectangle2 = templateBlock.getBounds();
            this.shiftY(unitRectangle2, fU, uNIT, templateBlock, polyWorkSheet);
        }
    }

    private void shiftY(UnitRectangle unitRectangle, UNIT uNIT, UNIT uNIT2, TemplateBlock templateBlock, PolyWorkSheet polyWorkSheet) {
        if (!unitRectangle.y.subtract(uNIT).more_than_zero()) {
            return;
        }
        unitRectangle.y = unitRectangle.y.add(uNIT2);
        if (!this.intersectsAllBlock(unitRectangle, templateBlock.getBlockName(), polyWorkSheet)) {
            templateBlock.setBounds(unitRectangle);
        }
    }

    private void shiftX(UnitRectangle unitRectangle, UNIT uNIT, UNIT uNIT2, TemplateBlock templateBlock, PolyWorkSheet polyWorkSheet) {
        if (!unitRectangle.x.subtract(uNIT).more_than_zero()) {
            return;
        }
        unitRectangle.x = unitRectangle.x.add(uNIT2);
        if (!this.intersectsAllBlock(unitRectangle, templateBlock.getBlockName(), polyWorkSheet)) {
            templateBlock.setBounds(unitRectangle);
        }
    }

    private boolean intersectsAllBlock(UnitRectangle unitRectangle, String string, PolyWorkSheet polyWorkSheet) {
        int n2 = polyWorkSheet.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = polyWorkSheet.getBlock(i2);
            UnitRectangle unitRectangle2 = block.getBounds();
            if (ComparatorUtils.equals(string, block.getBlockName()) || !unitRectangle2.intersects(unitRectangle)) continue;
            return true;
        }
        return false;
    }
}

