/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.utils;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ResultFormula;
import com.fr.data.TableDataSource;
import com.fr.general.PageCalObj;
import com.fr.general.PageCalRelationRuntimeException;
import com.fr.js.Callback;
import com.fr.js.JavaScript;
import com.fr.report.cell.CellElement;
import com.fr.report.core.namespace.CellValue4ReCalculateNameSpace;
import com.fr.report.core.utils.RFRC;
import com.fr.report.report.Report;
import com.fr.script.Calculator;
import com.fr.script.CurrentValueNameSpace;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.DeathCycleException;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class ScriptUtils {
    public static final CalculatorKey REC_CE_LIST = CalculatorKey.createKey("REC_CE_LIST");
    public static final CalculatorKey RES_FM_LIST = CalculatorKey.createKey("RES_FM_LIST");
    public static final NameSpace SIMPLE_CELL_NAMESPACE = CellValue4ReCalculateNameSpace.getInstance();

    private ScriptUtils() {
    }

    public static String moveRow(String string, int n2, int n3) {
        return ScriptUtils.changePosition(string, n2, n3, -1, 0);
    }

    public static String moveColumn(String string, int n2, int n3) {
        return ScriptUtils.changePosition(string, -1, 0, n2, n3);
    }

    public static String changePosition(String string, int n2, int n3, int n4, int n5) {
        boolean bl = StableUtils.maybeFormula(string);
        if (bl) {
            string = string.substring(1);
        }
        String string2 = Calculator.createCalculator().onAddDeleteColumnOrRow(string, n2, n3, n4, n5);
        return bl ? "=" + string2 : string2;
    }

    public static void executeCellElementResultFormula(CalculatorProvider calculatorProvider, ResultFormula resultFormula, Report report, TableDataSource tableDataSource, CellElement cellElement, boolean bl) {
        try {
            LinkedList linkedList = (LinkedList)calculatorProvider.getAttribute(REC_CE_LIST);
            List list = (List)calculatorProvider.getAttribute(RES_FM_LIST);
            if (list != null) {
                list.add(new RFRC(resultFormula, report, cellElement));
            }
            if (linkedList.contains(cellElement)) {
                throw new DeathCycleException("Death cycle exists when calculate : " + cellElement + "\n" + linkedList);
            }
            linkedList.add(cellElement);
            resultFormula.setResult(ScriptUtils.executeResultFormula(calculatorProvider, resultFormula, report, tableDataSource, ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()), bl));
            linkedList.removeLast();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error ColumnRow:" + ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()) + "\tcontent:" + resultFormula.getContent() + throwable.getMessage(), throwable);
        }
    }

    public static void resetResultFormulaState(Calculator calculator) {
        List list = (List)calculator.getAttribute(RES_FM_LIST);
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                RFRC rFRC = (RFRC)list.get(i2);
                if (rFRC == null) continue;
                rFRC.getResultFormula().resetExecuted();
            }
        }
    }

    public static Object executeNormalFormula(Calculator calculator, Formula formula) {
        return ScriptUtils.executeNormalFormula(calculator, formula, calculator.getCurrentFromColumnRow());
    }

    public static Object executeNormalFormula(Calculator calculator, Formula formula, ColumnRow columnRow) {
        return ScriptUtils.executeNormalFormula(calculator, formula, (Report)calculator.getAttribute(Report.KEY), (TableDataSource)calculator.getAttribute(TableDataSource.KEY), columnRow);
    }

    public static Object executeResultFormula(CalculatorProvider calculatorProvider, ResultFormula resultFormula, Report report, TableDataSource tableDataSource, ColumnRow columnRow, boolean bl) {
        String string;
        String string2 = string = bl ? resultFormula.getTransferContent().substring(1) : resultFormula.getContent().substring(1);
        if (StringUtils.isEmpty(string)) {
            string = resultFormula.getContent().substring(1);
        }
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(resultFormula.getResultForCurrentValue());
        calculatorProvider.pushNameSpace(currentValueNameSpace);
        Object object = ScriptUtils.executeFormula(calculatorProvider, string, report, tableDataSource, columnRow);
        calculatorProvider.removeNameSpace(currentValueNameSpace);
        return object;
    }

    public static Object executeNormalFormula(Calculator calculator, Formula formula, Report report, TableDataSource tableDataSource, ColumnRow columnRow) {
        String string = formula.getContent().substring(1);
        return ScriptUtils.executeFormula(calculator, string, report, tableDataSource, columnRow);
    }

    private static Object executeFormula(CalculatorProvider calculatorProvider, String string, Report report, TableDataSource tableDataSource, ColumnRow columnRow) {
        try {
            double d2;
            Object object;
            Report report2 = (Report)calculatorProvider.getAttribute(Report.KEY);
            calculatorProvider.setAttribute(Report.KEY, (Object)report);
            calculatorProvider.setAttribute(TableDataSource.KEY, (Object)tableDataSource);
            ColumnRow columnRow2 = calculatorProvider.getCurrentFromColumnRow();
            calculatorProvider.setCurrentFromColumnRow(columnRow);
            try {
                object = calculatorProvider.evalValue(string);
            }
            catch (PageCalRelationRuntimeException pageCalRelationRuntimeException) {
                return PageCalObj.MARK;
            }
            if (object instanceof Number && (object instanceof Double ? Double.isNaN(d2 = ((Double)object).doubleValue()) || Double.isInfinite(d2) : object instanceof Integer && Integer.MAX_VALUE == (Integer)object)) {
                return "\u221e";
            }
            calculatorProvider.setCurrentFromColumnRow(columnRow2);
            calculatorProvider.setAttribute(Report.KEY, (Object)report2);
            if (object == null) {
                return Primitive.NULL;
            }
            return object;
        }
        catch (Throwable throwable) {
            if (columnRow != null) {
                System.err.println("Error ColumnRow:" + columnRow + "\tcontent:" + string);
            } else {
                System.err.println("Error content:" + string);
            }
            FRContext.getLogger().error(throwable.getMessage(), throwable);
            return Primitive.ERROR_NAME;
        }
    }

    public static void dealJavaScriptFormula(JavaScript javaScript, Calculator calculator, ColumnRow columnRow) {
        Object[] objectArray = javaScript.getParameters();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                Object object2 = object.getValue();
                if (object2 instanceof Formula) {
                    Formula formula = (Formula)object2;
                    formula.setResult(ScriptUtils.executeNormalFormula(calculator, formula));
                    continue;
                }
                if (!(object2 instanceof Parameter)) continue;
                try {
                    ((Parameter)object2).setValue(calculator.evalValue(((Parameter)object2).getName()));
                    continue;
                }
                catch (UtilEvalError utilEvalError) {
                    FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                }
            }
        }
        javaScript.renderParameters(calculator);
        if (javaScript instanceof Callback && ((Callback)((Object)javaScript)).getCallBack() != null) {
            ScriptUtils.dealJavaScriptFormula(((Callback)((Object)javaScript)).getCallBack(), calculator, columnRow);
        }
    }
}

