/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.sheet;

import com.fr.base.Utils;
import com.fr.main.impl.WorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.core.sheet.WorkBookExecutor;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.fun.Actor;
import com.fr.script.Calculator;
import com.fr.stable.ListMap;
import com.fr.stable.UtilEvalError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkBookExecutor
implements WorkBookExecutor {
    protected List<ResultReport> listForResultReport;
    protected ListMap nameListMap = null;
    protected WorkBook workBook;
    protected Map<String, Object> parameterMap;

    public AbstractWorkBookExecutor(WorkBook workBook, Map<String, Object> map) {
        this.init(workBook, map);
    }

    @Override
    public ResultReport execute(int n2, TemplateReport templateReport) {
        Actor actor = this.getExeType();
        ResultReport resultReport = templateReport.execute(this.parameterMap, actor);
        if (resultReport != null) {
            this.listForResultReport.set(n2, resultReport);
        }
        return resultReport;
    }

    protected void _execute() {
        int n2 = this.nameListMap.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Actor actor;
            TemplateReport templateReport = (TemplateReport)this.nameListMap.getByIndex(i2);
            ResultReport resultReport = templateReport.execute(this.parameterMap, actor = this.getExeType());
            if (null == resultReport) continue;
            this.listForResultReport.set(i2, resultReport);
        }
    }

    @Override
    public ResultWorkBook execute() {
        this._execute();
        return this.result();
    }

    @Override
    public ResultWorkBook result() {
        ResultWorkBook resultWorkBook = this.initResultBook(this.parameterMap);
        this.dealWithExecutedAttr(resultWorkBook);
        int n2 = this.listForResultReport.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.listForResultReport.get(i2) == null) continue;
            resultWorkBook.addReport(this.workBook.getReportName(i2), this.listForResultReport.get(i2));
        }
        this.executeReportName(resultWorkBook);
        return resultWorkBook;
    }

    public void executeReportName(ResultWorkBook resultWorkBook) {
        int n2 = resultWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Report report = resultWorkBook.getReport(i2);
            Calculator calculator = Calculator.createCalculator();
            calculator.setAttribute(Report.KEY, (Object)report);
            String string = resultWorkBook.getReportName(i2);
            if (!string.startsWith("=")) continue;
            try {
                calculator.setAttribute(Report.KEY, (Object)report);
                calculator.pushNameSpace(SimpleCellValueNameSpace.getInstance());
                Object object = calculator.eval(string);
                string = Utils.objectToString(object);
                resultWorkBook.setReportName(i2, string);
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
    }

    void init(WorkBook workBook, Map<String, Object> map) {
        this.workBook = workBook;
        this.parameterMap = map;
        int n2 = workBook.getReportCount();
        this.nameListMap = new ListMap(n2);
        this.listForResultReport = new ArrayList<ResultReport>(n2);
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.listForResultReport.add(null);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            TemplateReport templateReport = workBook.getTemplateReport(n3);
            this.nameListMap.put(workBook.getReportName(n3), templateReport);
        }
    }

    @Override
    public void addResult(int n2, ResultReport resultReport) {
        this.listForResultReport.set(n2, resultReport);
    }

    protected void dealWithExecutedAttr(ResultWorkBook resultWorkBook) {
        if (resultWorkBook == null) {
            return;
        }
        Iterator iterator = this.workBook.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            resultWorkBook.putTableData(string, this.workBook.getTableData(string));
        }
        if (this.workBook.getReportWebAttr() != null) {
            resultWorkBook.setReportWebAttr(this.workBook.getReportWebAttr());
        }
        if (this.workBook.getReportExportAttr() != null) {
            resultWorkBook.setReportExportAttr(this.workBook.getReportExportAttr());
        }
        if (this.workBook.getXmlVersion() != null) {
            resultWorkBook.setXMLVersion(this.workBook.getXmlVersion());
        }
        if (this.workBook.getReportMobileAttr() != null) {
            resultWorkBook.setReportMobileAttr(this.workBook.getReportMobileAttr());
        }
    }

    @Override
    public ResultElementCase getResultByIndex(int n2) {
        return (ResultElementCase)((Object)this.listForResultReport.get(n2));
    }
}

