/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.general.GeneralContext;
import com.fr.plugin.ExtraXMLFileManager;
import com.fr.report.fun.ActorProvider;
import com.fr.report.fun.ExportEncodeProvider;
import com.fr.report.fun.ExportRegInfoProcessor;
import com.fr.report.stable.fun.Actor;
import com.fr.stable.ActorFactory;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.Level;
import com.fr.stable.plugin.ExtraReportClassManagerProvider;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraReportClassManager
extends ExtraXMLFileManager
implements ExtraReportClassManagerProvider {
    private static final String XML_TAG = "ExtraReportClassManager";
    private static ExtraReportClassManager reportClassManager;
    private ExportEncodeProvider csvExportEncodeProvider = null;

    public static synchronized ExtraReportClassManager getInstance() {
        if (reportClassManager == null) {
            reportClassManager = new ExtraReportClassManager();
            reportClassManager.readXMLFile();
        }
        return reportClassManager;
    }

    private static synchronized void envChanged() {
        reportClassManager = null;
    }

    @Override
    public String fileName() {
        return "report.xml";
    }

    public void setActorProvider(Level level, PluginSimplify pluginSimplify) throws Exception {
        this.validAPILevel(level, 1, pluginSimplify.getPluginName());
        ActorProvider actorProvider = (ActorProvider)level;
        for (Actor actor : actorProvider.createActor()) {
            ActorFactory.registerActor(actor.panelType(), actor);
        }
    }

    private void addActor(Level level, PluginSimplify pluginSimplify) throws Exception {
        this.validAPILevel(level, 1, pluginSimplify.getPluginName());
        Actor actor = (Actor)level;
        ActorFactory.registerActor(actor.panelType(), actor);
    }

    public ExportEncodeProvider getCsvExportEncodeProvider() {
        return this.csvExportEncodeProvider;
    }

    public void setCsvExportEncodeProvider(Level level, PluginSimplify pluginSimplify) throws Exception {
        this.validAPILevel(level, 1, pluginSimplify.getPluginName());
        this.csvExportEncodeProvider = (ExportEncodeProvider)level;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        this.readXML(xMLableReader, null, PluginSimplify.NULL);
    }

    @Override
    public void readXML(XMLableReader xMLableReader, List<String> list, PluginSimplify pluginSimplify) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (list != null) {
                list.add(string2);
            }
            if (StringUtils.isEmpty(string = xMLableReader.getAttrAsString("class", ""))) {
                return;
            }
            this.readStandard(string2, string, pluginSimplify, xMLableReader);
        }
    }

    @Override
    protected void readSpecific(String string, Level level, PluginSimplify pluginSimplify, XMLableReader xMLableReader) throws Exception {
        if (string.equals("ActorProvider")) {
            this.setActorProvider(level, pluginSimplify);
        } else if (string.equals("WebActor")) {
            this.addActor(level, pluginSimplify);
        } else if (string.equals("CsvExportEncode")) {
            this.readCsvExportEncode(level, pluginSimplify, xMLableReader);
        }
    }

    private void readCsvExportEncode(Level level, PluginSimplify pluginSimplify, XMLableReader xMLableReader) throws Exception {
        this.setCsvExportEncodeProvider(level, pluginSimplify);
        if (this.csvExportEncodeProvider != null) {
            String string = xMLableReader.getAttrAsString("csvcharset", "");
            this.csvExportEncodeProvider.setCsvCharSet(string);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    @Deprecated
    public ExportRegInfoProcessor getExportRegInfoProcessor() {
        return (ExportRegInfoProcessor)ExtraReportClassManager.getInstance().getSingle("ExportRegInfoProcessor");
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ExtraReportClassManager.envChanged();
            }
        });
    }
}

