/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege;

import com.fr.cluster.rpc.RPC;
import com.fr.data.NetworkHelper;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.privilege.PrivilegeConstants;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.PrivilegeManagerProvider;
import com.fr.privilege.authentication.RoleAuthentication;
import com.fr.privilege.base.PrivilegeFilter;
import com.fr.privilege.filter.AuthorityControlFilter;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.NoAuthenticationProvider;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.FCloneable;
import com.fr.stable.StringUtils;
import com.fr.stable.privilege.AuthorityBridge;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PrivilegeManager
extends XMLFileManager
implements Serializable,
FCloneable,
PrivilegeManagerProvider {
    public static final String XML_TAG = "PrivilegeManager";
    public static final String DEFAULTADMINNAME = "admin";
    public static final String DEFAULTADMINPASSWORD = "123456";
    private static final String CONNECTOR = "&&";
    public static final long SYSADMINID = -999L;
    private boolean hasSetFSSystemManager = false;
    private static PrivilegeManagerProvider privilegeManager = null;
    private PasswordValidator passwordValidator = null;
    public static final String ROOT_ROLE = "root";
    private String rootManagerName = "admin";
    private String rootManagerPassword = "123456";
    private String rootManagerRealname;
    private Date rootManagerBirthday;
    private boolean rootManagerMale;
    private String rootManagerMobile;
    private String rootManagerWorkphone;
    private String rootManagerEmail;
    private AuthenticationProvider authenticationProvider = new NoAuthenticationProvider();
    private String forwardUrl = "${servletURL}?op=fr_platform";
    private PrivilegeFilter privilegeFilter = null;

    public static synchronized PrivilegeManager getInstance() {
        return (PrivilegeManager)PrivilegeManager.getProviderInstance();
    }

    public static synchronized PrivilegeManagerProvider getProviderInstance() {
        if (privilegeManager == null) {
            if (PrivilegeManager.isClusterMember()) {
                return privilegeManager;
            }
            privilegeManager.readXMLFile();
            if (!PrivilegeManager.isAfterPrivilege705()) {
                PrivilegeManager.compatibleOldVersion();
            }
        }
        return privilegeManager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                privilegeManager = new PrivilegeManager();
                RPC.registerSkeleton(privilegeManager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                privilegeManager = (PrivilegeManagerProvider)RPC.getProxy(PrivilegeManager.class, string);
                return true;
            }
        }
        privilegeManager = new PrivilegeManager();
        return false;
    }

    private static boolean isAfterPrivilege705() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(GeneralContext.getResourceStream("privilege.xml", false), "UTF-8");
            XMLableReader xMLableReader = XMLableReader.createXMLableReader(inputStreamReader);
            return xMLableReader != null && xMLableReader.getXMLVersion().isAfterPRIVILGE_FOR7_0_5_XML_VERSION();
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static void compatibleOldVersion() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
                AbstractAuthenticationProvider abstractAuthenticationProvider = (AbstractAuthenticationProvider)authenticationProvider;
                try {
                    Authority[] authorityArray = abstractAuthenticationProvider.listAuthorities();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i2 = 0; i2 < authorityArray.length; ++i2) {
                        hashSet.add(authorityArray[i2].getName());
                    }
                    PrivilegeFilter privilegeFilter = privilegeManager.getPrivilegeFilter();
                    if (privilegeFilter instanceof AuthorityControlFilter) {
                        AuthorityControlFilter authorityControlFilter = (AuthorityControlFilter)privilegeFilter;
                        authorityControlFilter.joinAuthorityAllocationWithPrivilege(hashSet);
                        privilegeManager.setPrivilegeFilter(authorityControlFilter);
                    }
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
            }
        });
        thread.start();
    }

    private static synchronized void envChanged() {
        privilegeManager = null;
    }

    private PrivilegeManager() {
    }

    public PasswordValidator getCustomPasswordValidatorProcessor() {
        return this.passwordValidator;
    }

    public void setCustomPasswordValidatorProcessor(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    public boolean isDemoRootUser() {
        return ComparatorUtils.equals(this.rootManagerName, DEFAULTADMINNAME) && ComparatorUtils.equals(this.rootManagerPassword, DEFAULTADMINPASSWORD);
    }

    public boolean hasSetFSSystemPW() {
        return this.hasSetFSSystemManager;
    }

    public void setHasFSSystemPW(boolean bl) {
        this.hasSetFSSystemManager = bl;
    }

    public String getRootManagerName() {
        return this.rootManagerName;
    }

    public void setRootManagerName(String string) {
        this.rootManagerName = string;
    }

    public String getRootManagerPassword() {
        if (this.passwordValidator != null) {
            return this.passwordValidator.encodePassword(this.rootManagerPassword);
        }
        return this.rootManagerPassword;
    }

    public void setRootManagerPassword(String string) {
        this.rootManagerPassword = string;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider != null ? this.authenticationProvider : new NoAuthenticationProvider();
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public String getForwardUrl() {
        return this.forwardUrl;
    }

    public PrivilegeFilter getPrivilegeFilter() {
        return this.privilegeFilter;
    }

    public int getPrivilegeFilterType() {
        if (this.privilegeFilter == null) {
            return -1;
        }
        return this.privilegeFilter.getID();
    }

    public void setPrivilegeFilter(PrivilegeFilter privilegeFilter) {
        this.privilegeFilter = privilegeFilter;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.hasSetFSSystemManager = xMLableReader.getAttrAsBoolean("fsSystemManagerPassSet", false);
            this.rootManagerRealname = xMLableReader.getAttrAsString("realname", "");
            this.rootManagerBirthday = new Date(xMLableReader.getAttrAsLong("birthday", 0L));
            this.rootManagerMale = xMLableReader.getAttrAsBoolean("male", false);
            this.rootManagerWorkphone = xMLableReader.getAttrAsString("workphone", "");
            this.rootManagerEmail = xMLableReader.getAttrAsString("email", "");
        } else if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("rootManagerName".equals(string)) {
                this.rootManagerName = xMLableReader.getElementValue();
            } else if ("rootManagerPassword".equals(string)) {
                this.rootManagerPassword = CodeUtils.passwordDecode(xMLableReader.getElementValue());
            } else if (string.equals("AP")) {
                this.authenticationProvider = (AuthenticationProvider)GeneralXMLTools.readXMLable(xMLableReader);
            } else if ("PVFILTER".equals(string)) {
                this.privilegeFilter = (PrivilegeFilter)GeneralXMLTools.readXMLable(xMLableReader);
            } else if ("PasswordValidator".equals(string)) {
                Class clazz = null;
                String string2 = "";
                try {
                    string2 = xMLableReader.getAttrAsString("class", "");
                    clazz = GeneralUtils.classForName(string2);
                    this.passwordValidator = (PasswordValidator)clazz.newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().info("error to load:" + string2);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("fsSystemManagerPassSet", this.hasSetFSSystemManager);
        if (StringUtils.isNotEmpty(this.getRootManagerRealname())) {
            xMLPrintWriter.attr("realname", this.getRootManagerRealname());
        }
        if (this.rootManagerBirthday != null) {
            xMLPrintWriter.attr("birthday", this.getRootManagerBirthday().getTime());
        }
        xMLPrintWriter.attr("male", this.isRootManagerMale());
        if (StringUtils.isNotEmpty(this.getRootManagerMobile())) {
            xMLPrintWriter.attr("mobile", this.getRootManagerMobile());
        }
        if (StringUtils.isNotEmpty(this.getRootManagerWorkphone())) {
            xMLPrintWriter.attr("workphone", this.getRootManagerWorkphone());
        }
        if (StringUtils.isNotEmpty(this.getRootManagerEmail())) {
            xMLPrintWriter.attr("email", this.getRootManagerEmail());
        }
        if (StringUtils.isNotEmpty(this.rootManagerName)) {
            xMLPrintWriter.startTAG("rootManagerName").textNode(this.rootManagerName).end();
        }
        if (StringUtils.isNotEmpty(this.rootManagerPassword)) {
            xMLPrintWriter.startTAG("rootManagerPassword").textNode(CodeUtils.passwordEncode(this.rootManagerPassword)).end();
        }
        if (this.authenticationProvider != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.authenticationProvider, "AP");
        }
        if (StringUtils.isNotBlank(this.forwardUrl)) {
            xMLPrintWriter.startTAG("ForwardUrl").textNode(this.forwardUrl).end();
        }
        if (this.getPrivilegeFilter() != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.getPrivilegeFilter(), "PVFILTER");
        }
        if (this.passwordValidator != null) {
            xMLPrintWriter.startTAG("PasswordValidator").attr("class", this.passwordValidator.getClass().getName()).end();
        }
        xMLPrintWriter.end();
    }

    public String fileName() {
        return "privilege.xml";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getRootManagerRealname() {
        return this.rootManagerRealname;
    }

    public void setRootManagerRealname(String string) {
        this.rootManagerRealname = string;
    }

    public Date getRootManagerBirthday() {
        return this.rootManagerBirthday;
    }

    public void setRootManagerBirthday(Date date) {
        this.rootManagerBirthday = date;
    }

    public boolean isRootManagerMale() {
        return this.rootManagerMale;
    }

    public void setRootManagerMale(boolean bl) {
        this.rootManagerMale = bl;
    }

    public String getRootManagerMobile() {
        return this.rootManagerMobile;
    }

    public void setRootManagerMobile(String string) {
        this.rootManagerMobile = string;
    }

    public String getRootManagerWorkphone() {
        return this.rootManagerWorkphone;
    }

    public void setRootManagerWorkphone(String string) {
        this.rootManagerWorkphone = string;
    }

    public String getRootManagerEmail() {
        return this.rootManagerEmail;
    }

    public void setRootManagerEmail(String string) {
        this.rootManagerEmail = string;
    }

    public void setUserInfo(String string, Date date, boolean bl, String string2, String string3, String string4) {
        this.setRootManagerRealname(string);
        this.setRootManagerBirthday(date);
        this.setRootManagerMale(bl);
        this.setRootManagerMobile(string2);
        this.setRootManagerWorkphone(string3);
        this.setRootManagerEmail(string4);
    }

    public static boolean checkIsRoot(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        PrivilegeManagerProvider privilegeManagerProvider = PrivilegeManager.getProviderInstance();
        String string = NetworkHelper.getHTTPRequestParameter(httpServletRequest, "fr_username");
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        return ComparatorUtils.equals(string, privilegeManagerProvider.getRootManagerName());
    }

    public static void logout2SessionInfo(HttpSession httpSession, HttpServletResponse httpServletResponse) {
        if (httpSession == null) {
            return;
        }
        httpSession.removeAttribute("fr_authentication_key");
        httpSession.removeAttribute("fr_username");
        httpSession.removeAttribute("fr_authority");
        httpSession.removeAttribute("fr_userposition");
        httpSession.removeAttribute("fr_isroot");
        httpSession.removeAttribute("fr_current_privilege_loader");
        Cookie cookie = new Cookie("isAutoLogin", "false");
        Cookie cookie2 = new Cookie("isDefaultUser", ComparatorUtils.equals(PrivilegeManager.getProviderInstance().getRootManagerName(), DEFAULTADMINNAME) && ComparatorUtils.equals(PrivilegeManager.getProviderInstance().getRootManagerPassword(), DEFAULTADMINPASSWORD) ? "true" : "false");
        httpServletResponse.addCookie(cookie2);
        httpServletResponse.addCookie(cookie);
        Cookie cookie3 = new Cookie("FRPassword", "");
        cookie3.setMaxAge(-1);
        httpServletResponse.addCookie(cookie3);
        Cookie cookie4 = new Cookie("FRUsername", "");
        cookie4.setMaxAge(-1);
        httpServletResponse.addCookie(cookie4);
    }

    public static String[] getRoleFromCalculator(Calculator calculator) {
        if (calculator == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Authentication authentication = null;
        try {
            Object object = calculator.evalAuth();
            authentication = object instanceof String ? new RoleAuthentication((String)object) : (Authentication)object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authentication == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return authentication.getRole();
    }

    public static String[] getRoleFromAuthentication(Authentication authentication) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PrivilegeManagerProvider privilegeManagerProvider = PrivilegeManager.getProviderInstance();
        AuthenticationProvider authenticationProvider = privilegeManagerProvider.getAuthenticationProvider();
        try {
            if (authentication instanceof RoleAuthentication) {
                String[] stringArray = ((RoleAuthentication)authentication).getUserName().split(CONNECTOR);
                arrayList.addAll(Arrays.asList(stringArray));
            } else if (authenticationProvider.authenticate(authentication)) {
                AuthorityBridge[] authorityBridgeArray = authentication.getAuthorities();
                for (int i2 = 0; i2 < authorityBridgeArray.length; ++i2) {
                    String string = authorityBridgeArray[i2].getName();
                    if (ComparatorUtils.equals(ROOT_ROLE, string)) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getUserRoleString(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return PrivilegeConstants.ROLE_UNDEFINED;
        }
        Object object = httpSession.getAttribute("fr_authority");
        Object object2 = httpSession.getAttribute("fr_userposition");
        return PrivilegeManager.getUserRoleStringFromAutority(object, object2);
    }

    public static String getUserRoleStringFromAutority(Object object, Object object2) {
        if (object == null && object2 == null) {
            return PrivilegeConstants.ROLE_UNDEFINED;
        }
        FArray fArray = new FArray();
        PrivilegeManager.readAuthorityAndDepartment(object, object2, fArray);
        return PrivilegeManager.convertToString(fArray);
    }

    private static String convertToString(FArray fArray) {
        int n2 = fArray.length();
        if (n2 <= 0) {
            return PrivilegeConstants.ROLE_UNDEFINED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(fArray.elementAt(i2).toString()).append(CONNECTOR);
        }
        return stringBuffer.toString();
    }

    private static void readAuthorityAndDepartment(Object object, Object object2, FArray fArray) {
        if (object != null) {
            fArray.add(object);
        }
        if (object2 instanceof FArray) {
            FArray fArray2 = (FArray)object2;
            for (int i2 = 0; i2 < fArray2.length(); ++i2) {
                JSONObject jSONObject = (JSONObject)fArray2.elementAt(i2);
                try {
                    fArray.add(jSONObject.getString("departments") + jSONObject.getString("jobTitle"));
                    continue;
                }
                catch (JSONException jSONException) {
                    FRLogger.getLogger().info(jSONException.getMessage());
                }
            }
        } else if (object2 != null) {
            fArray.add(object2);
        }
    }

    public boolean writeResource() throws Exception {
        return GeneralContext.getEnvProvider().writeResource(PrivilegeManager.getProviderInstance());
    }

    public static void reinit() {
        PrivilegeManager.envChanged();
        PrivilegeManager.getProviderInstance();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                PrivilegeManager.envChanged();
            }
        });
    }
}

