/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.proxy;

import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginLoader;
import com.fr.plugin.proxy.PluginInvocationHandler;
import com.fr.plugin.proxy.PluginProxy;
import com.fr.stable.plugin.PluginSimplify;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractPluginInvocationHandler
implements PluginInvocationHandler {
    protected Object oriObj;
    protected PluginSimplify simplify;
    private Method equalsMethod = Object.class.getMethod("equals", Object.class);
    private Method getOriObjectMethod = PluginProxy.class.getMethod("getOriObject", new Class[0]);

    protected AbstractPluginInvocationHandler() throws NoSuchMethodException {
    }

    public void setOri(Object object) {
        this.oriObj = object;
    }

    public void setPluginSimplify(PluginSimplify pluginSimplify) {
        this.simplify = pluginSimplify;
    }

    protected Object defaultInvoke(Method method, Object[] objectArray) throws Throwable {
        try {
            return this.invoke(method, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (this.isIncompatible(throwable)) {
                String string = Inter.getLocText("FR-Base-Plugin_Error_Message", this.simplify.getPluginName());
                FRLogger.getLogger().error(string);
                PluginLoader.getLoader().findPlugin(this.simplify.getPluginID()).setActive(false);
                PluginLoader.getLoader().findPlugin(this.simplify.getPluginID()).setState(Plugin.State.BELOW_SYSTEM);
                throw new RuntimeException(string, throwable);
            }
            throw throwable;
        }
    }

    private Object invoke(Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        if (method.equals(this.equalsMethod)) {
            return this.invokeEquals(objectArray);
        }
        if (method.equals(this.getOriObjectMethod)) {
            return this.oriObj;
        }
        return method.invoke(this.oriObj, objectArray);
    }

    private Object invokeEquals(Object[] objectArray) {
        if (objectArray == null || objectArray.length != 1) {
            return false;
        }
        Object object = objectArray[0];
        if (object instanceof PluginProxy) {
            object = ((PluginProxy)object).getOriObject();
        }
        return this.oriObj.equals(object);
    }

    private boolean isIncompatible(Throwable throwable) {
        return throwable == null || throwable instanceof NoSuchMethodError;
    }
}

