/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.DesUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginLicense;
import com.fr.plugin.PluginLicenseManager;
import com.fr.stable.xml.XMLTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PluginManagerHelper {
    private static final int CACHE_SIZE = 1024;
    private static final int DEFAULT_START = 0;
    private static final int SIGNUM = 1;
    private static final int HEX = 16;
    public static final String LOCAL_PLUGIN_INFO = "some.info";

    public static boolean checkLic(Plugin plugin, File file) throws Exception {
        File[] fileArray;
        if (PluginLicenseManager.getInstance().isFree(plugin)) {
            return true;
        }
        if (file.isDirectory() && file.listFiles() != null && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().endsWith(".lic")) continue;
                PluginLicense pluginLicense = PluginManagerHelper.licDecrypt(plugin, file2);
                return PluginLicenseManager.getInstance().checkLic(plugin, pluginLicense);
            }
        }
        return PluginLicenseManager.getInstance().trial(plugin);
    }

    public static boolean checkLic(Plugin plugin, InputStream inputStream) throws Exception {
        if (PluginLicenseManager.getInstance().isFree(plugin)) {
            return true;
        }
        if (inputStream != null) {
            PluginLicense pluginLicense = PluginManagerHelper.licDecrypt(plugin, inputStream);
            return PluginLicenseManager.getInstance().checkLic(plugin, pluginLicense);
        }
        return PluginLicenseManager.getInstance().trial(plugin);
    }

    public static PluginLicense licDecrypt(Plugin plugin, File file) {
        ByteArrayInputStream byteArrayInputStream = PluginManagerHelper.XMLLileDecrypt(file);
        return PluginManagerHelper.getPluginLicenseFromByteArray(plugin, byteArrayInputStream);
    }

    public static PluginLicense licDecrypt(Plugin plugin, InputStream inputStream) {
        ByteArrayInputStream byteArrayInputStream = PluginManagerHelper.XMLLileDecrypt(inputStream);
        return PluginManagerHelper.getPluginLicenseFromByteArray(plugin, byteArrayInputStream);
    }

    private static PluginLicense getPluginLicenseFromByteArray(Plugin plugin, ByteArrayInputStream byteArrayInputStream) {
        PluginLicense pluginLicense = PluginLicenseManager.getInstance().getPluginLicenseByID(plugin.getId());
        PluginLicense pluginLicense2 = new PluginLicense();
        try {
            XMLTools.readInputStreamXML(pluginLicense2, byteArrayInputStream);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        if (ComparatorUtils.equals(pluginLicense.getPluginID(), pluginLicense2.getPluginID())) {
            pluginLicense.setPluginInfoFromXml(pluginLicense2);
        }
        return pluginLicense;
    }

    public static ByteArrayInputStream XMLLileDecrypt(File file) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            String string = IOUtils.inputStream2String(fileInputStream, "UTF-8");
            String string2 = DesUtils.decodeWithHex(string);
            fileInputStream.close();
            byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return byteArrayInputStream;
    }

    public static ByteArrayInputStream XMLLileDecrypt(InputStream inputStream) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            String string = IOUtils.inputStream2String(inputStream, "UTF-8");
            String string2 = DesUtils.decodeWithHex(string);
            inputStream.close();
            byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return byteArrayInputStream;
    }

    public static boolean fileEncrypt(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            String string = IOUtils.inputStream2String(fileInputStream, "UTF-8");
            String string2 = DesUtils.encodeWithHex(string);
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IOUtils.copyBinaryTo(new ByteArrayInputStream(string2.getBytes("UTF-8")), fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
            return false;
        }
        return true;
    }

    public static boolean checkMD5ForJar(Plugin plugin, File file) {
        File[] fileArray;
        if (file != null && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            return PluginManagerHelper.findTargetJar(plugin, fileArray);
        }
        return false;
    }

    private static boolean findTargetJar(Plugin plugin, File[] fileArray) {
        for (File file : fileArray) {
            String string = plugin.getMd5Key();
            if (string != null) {
                String string2;
                if (!file.getName().endsWith(".jar") || !ComparatorUtils.equals(string, string2 = PluginManagerHelper.getFileMD5(file))) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static String getFileMD5(File file) {
        try {
            int n2;
            byte[] byArray = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n2);
            }
            byte[] byArray2 = messageDigest.digest();
            bufferedInputStream.close();
            fileInputStream.close();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            return bigInteger.toString(16).toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FRContext.getLogger().error(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
        return null;
    }

    public static boolean writeToFile(String string, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IOUtils.copyBinaryTo(new ByteArrayInputStream(string.getBytes("UTF-8")), fileOutputStream);
            fileOutputStream.close();
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRContext.getLogger().error(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
        return false;
    }
}

