/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DesUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONParser;
import com.fr.plugin.ExtraClassManager;
import com.fr.plugin.PluginCollector;
import com.fr.plugin.PluginEmbFile;
import com.fr.plugin.PluginInvalidLevelException;
import com.fr.plugin.PluginMessage;
import com.fr.plugin.PluginPreUninstall;
import com.fr.plugin.dependence.PluginDependence;
import com.fr.stable.ExtClasspathLoader;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.plugin.ExtraChartDesignClassManagerProvider;
import com.fr.stable.plugin.ExtraChartTypeClassManagerProvider;
import com.fr.stable.plugin.ExtraDesignClassManagerProvider;
import com.fr.stable.plugin.ExtraFormClassManagerProvider;
import com.fr.stable.plugin.ExtraPlatformClassManagerProvider;
import com.fr.stable.plugin.ExtraReportClassManagerProvider;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.plugin.event.PluginChangeEvent;
import com.fr.stable.plugin.event.PluginChangeTransponder;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin
implements XMLable,
JSONParser {
    private static final String COL = ",";
    private String id = "";
    private String name;
    private String version;
    private String envVersion;
    private String nodeName;
    private String requiredJarTime;
    private String md5Key;
    private String price;
    private String vendor;
    private String description;
    private String changeNotes;
    private boolean active;
    private State state = State.NORMAL;
    private boolean hidden;
    private boolean waitForRead;
    private PluginDependence dependence;
    private List<String> extraInterfaceList = new ArrayList<String>();
    private List<String> extraDesignInterfaceList = new ArrayList<String>();
    private List<String> extraReportInterfaceList = new ArrayList<String>();
    private List<String> extraFormInterfaceList = new ArrayList<String>();
    private List<String> extraPlatformInterfaceList = new ArrayList<String>();
    private List<String> extraChartInterfaceList = new ArrayList<String>();
    private List<String> extraChartDesignInterfaceList = new ArrayList<String>();
    private Map<String, Set<String>> moduleInterfaceMap;
    private List<PluginEmbFile> pluginEmbFiles = new ArrayList<PluginEmbFile>();
    private PluginPreUninstall preUninstall;

    public Plugin() {
        this(UUID.randomUUID().toString());
    }

    public Plugin(String string) {
        this.nodeName = string;
    }

    public String getRequiredJarTime() {
        return this.requiredJarTime;
    }

    public void setRequiredJarTime(String string) {
        this.requiredJarTime = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getEnvVersion() {
        return this.envVersion;
    }

    public void setEnvVersion(String string) {
        this.envVersion = string;
    }

    public String getMd5Key() {
        return this.md5Key;
    }

    public void setMd5Key(String string) {
        this.md5Key = string;
    }

    public String getPrice() {
        return this.price;
    }

    public void setPrice(String string) {
        this.price = string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        if (this.active != bl) {
            this.active = bl;
            this.informActiveChanged();
        }
    }

    public void setActiveWithoutEvent(boolean bl) {
        this.active = bl;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    private void informActiveChanged() {
        PluginChangeTransponder.getInstance().firePluginActiveChanged(this.createPluginChangeEvent());
    }

    private PluginChangeEvent createPluginChangeEvent() {
        return new PluginChangeEvent(this.getId(), this.active, this.getModuleInterfaceMap());
    }

    public void preUninstall() {
        if (this.preUninstall != null) {
            try {
                this.preUninstall.executePreUninstall();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public PluginDependence getDependence() {
        return this.dependence;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getChangeNotes() {
        return this.changeNotes;
    }

    public void setChangeNotes(String string) {
        this.changeNotes = string;
    }

    public String getNodeName() {
        return StableUtils.join(new String[]{"plugin", this.id}, "-");
    }

    public boolean match(String string) {
        return StringUtils.contains(this.id, string) || StringUtils.contains(this.name, string) || StringUtils.contains(this.version, string) || StringUtils.contains(this.envVersion, string) || StringUtils.contains(this.vendor, string) || StringUtils.contains(this.description, string) || StringUtils.contains(this.changeNotes, string);
    }

    public boolean isValidate() {
        return StringUtils.isNotEmpty(this.id) && StringUtils.isNotEmpty(this.name) && StringUtils.isNotEmpty(this.version) && StringUtils.isNotEmpty(this.envVersion);
    }

    public boolean checkIfJarExpired() {
        boolean bl;
        if (ComparatorUtils.equals(Inter.getLocText("FR-Basic_About_No_Build"), GeneralUtils.readBuildNO())) {
            bl = false;
        } else {
            if (this.requiredJarTime == null) {
                this.requiredJarTime = GeneralUtils.readBuildNO();
            }
            boolean bl2 = bl = DateUtils.subtractDate(DateUtils.string2Date(this.requiredJarTime, false), DateUtils.string2Date(GeneralUtils.readBuildNO(), false), "s") > 0L;
        }
        if (bl) {
            this.setActiveWithoutEvent(false);
            this.setState(State.BEYOND_SYSTEM);
        }
        return bl;
    }

    public boolean isWaitForRead() {
        return this.waitForRead;
    }

    public void setWaitForRead(boolean bl) {
        this.waitForRead = bl;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", this.id);
            jSONObject.put("name", this.name);
            jSONObject.put("version", this.version);
            jSONObject.put("envversion", this.envVersion);
            jSONObject.put("description", this.description);
            jSONObject.put("changenotes", this.changeNotes);
            jSONObject.put("vendor", this.vendor);
            jSONObject.put("price", this.price);
            jSONObject.put("jartime", this.requiredJarTime);
            jSONObject.put("active", this.active);
            jSONObject.put("state", (Object)this.state);
            jSONObject.put("dependence", this.dependence == null ? "" : this.dependence.createJSON());
            jSONObject.put("extra", StableUtils.join(this.extraInterfaceList, COL));
            jSONObject.put("report", StableUtils.join(this.extraReportInterfaceList, COL));
            jSONObject.put("form", StableUtils.join(this.extraFormInterfaceList, COL));
            jSONObject.put("design", StableUtils.join(this.extraDesignInterfaceList, COL));
            jSONObject.put("platform", StableUtils.join(this.extraPlatformInterfaceList, COL));
            jSONObject.put("chart", StableUtils.join(this.extraChartInterfaceList, COL));
            jSONObject.put("chartdesign", StableUtils.join(this.extraChartDesignInterfaceList, COL));
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public void start(Env env) {
        ExtClasspathLoader.loadClasspath(StableUtils.pathJoin(env.getPath(), "plugins", this.nodeName));
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            try {
                if ("id".equals(string)) {
                    this.id = xMLableReader.getElementValue();
                } else if ("name".equals(string)) {
                    this.name = xMLableReader.getElementValue();
                } else if ("active".equals(string)) {
                    this.active = "yes".equals(xMLableReader.getElementValue());
                } else if ("hidden".equals(string)) {
                    this.hidden = "yes".equals(xMLableReader.getElementValue());
                } else if ("version".equals(string)) {
                    this.version = xMLableReader.getElementValue();
                } else if ("env-version".equals(string)) {
                    this.envVersion = xMLableReader.getElementValue();
                } else if ("vendor".equals(string)) {
                    this.vendor = xMLableReader.getElementValue();
                } else if ("description".equals(string)) {
                    this.description = xMLableReader.getElementValue();
                } else if ("change-notes".equals(string)) {
                    this.changeNotes = xMLableReader.getElementValue();
                } else if ("jartime".equals(string)) {
                    this.requiredJarTime = xMLableReader.getElementValue();
                } else if ("extra-core".equals(string)) {
                    this.readExtraCore(xMLableReader);
                } else if ("extra-report".equals(string)) {
                    this.readExtraReport(xMLableReader);
                } else if ("extra-form".equals(string)) {
                    this.readExtraForm(xMLableReader);
                } else if ("extra-designer".equals(string)) {
                    this.readExtraDesigner(xMLableReader);
                } else if ("extra-platform".equals(string)) {
                    this.readExtraPlatform(xMLableReader);
                } else if ("extra-chart".equals(string)) {
                    this.readExtraChart(xMLableReader);
                } else if ("extra-chart-designer".equals(string)) {
                    this.readExtraChartDesigner(xMLableReader);
                } else if ("move-after-install".equals(string)) {
                    this.readEmbFileInfo(xMLableReader);
                } else if ("md5-key".equals(string)) {
                    this.md5Key = xMLableReader.getElementValue();
                } else if ("price".equals(string)) {
                    this.price = xMLableReader.getElementValue();
                } else if ("dependence".equals(string)) {
                    this.readDependence(xMLableReader);
                } else if ("pre-uninstall".equals(string)) {
                    this.readPreUninstall(xMLableReader);
                }
            }
            catch (Throwable throwable) {
                this.dealWithPluginReadError(throwable);
            }
        }
    }

    private void readPreUninstall(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", "");
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                PluginPreUninstall pluginPreUninstall = (PluginPreUninstall)clazz.newInstance();
                if (PluginCollector.getCollector().isError(pluginPreUninstall, 1, this.getName())) {
                    PluginMessage.remindUpdate(string);
                }
                this.preUninstall = pluginPreUninstall;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
    }

    private void dealWithPluginReadError(Throwable throwable) {
        if (throwable instanceof PluginInvalidLevelException) {
            this.setState(State.BELOW_SYSTEM);
        } else {
            this.setState(State.BEYOND_SYSTEM);
        }
        this.setActiveWithoutEvent(false);
        try {
            FRContext.getCurrentEnv().writePlugin(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FRLogger.getLogger().error(Inter.getLocText("FR-Designer-Failed_to_load_the_plugin") + this.getName() + throwable.getMessage());
    }

    private void readDependence(XMLableReader xMLableReader) {
        this.dependence = new PluginDependence(this.id);
        xMLableReader.readXMLObject(this.dependence);
        this.dependence.startService();
    }

    private void readEmbFileInfo(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    PluginEmbFile pluginEmbFile = new PluginEmbFile();
                    pluginEmbFile.readXML(xMLableReader);
                    Plugin.this.pluginEmbFiles.add(pluginEmbFile);
                }
            }
        });
    }

    private void readExtraChartDesigner(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                ExtraChartDesignClassManagerProvider extraChartDesignClassManagerProvider;
                if (xMLableReader.isChildNode() && (extraChartDesignClassManagerProvider = StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraChartDesignClassManagerProvider", ExtraChartDesignClassManagerProvider.class)) != null) {
                    extraChartDesignClassManagerProvider.readXML(xMLableReader, Plugin.this.extraChartDesignInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                }
            }
        });
    }

    private void readExtraChart(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                ExtraChartTypeClassManagerProvider extraChartTypeClassManagerProvider;
                if (xMLableReader.isChildNode() && (extraChartTypeClassManagerProvider = StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraChartTypeClassManagerProvider", ExtraChartTypeClassManagerProvider.class)) != null) {
                    extraChartTypeClassManagerProvider.readXML(xMLableReader, Plugin.this.extraChartInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                }
            }
        });
    }

    private void readExtraPlatform(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    ExtraPlatformClassManagerProvider extraPlatformClassManagerProvider = StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraPlatformClassManagerProvider", ExtraPlatformClassManagerProvider.class);
                    if (extraPlatformClassManagerProvider != null) {
                        extraPlatformClassManagerProvider.readXML(xMLableReader, Plugin.this.extraPlatformInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                    } else {
                        Plugin.this.setWaitForRead(true);
                    }
                }
            }
        });
    }

    private void readExtraDesigner(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                ExtraDesignClassManagerProvider extraDesignClassManagerProvider;
                if (xMLableReader.isChildNode() && (extraDesignClassManagerProvider = StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraDesignClassManagerProvider", ExtraDesignClassManagerProvider.class)) != null) {
                    extraDesignClassManagerProvider.readXML(xMLableReader, Plugin.this.extraDesignInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                }
            }
        });
    }

    private void readExtraReport(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                ExtraReportClassManagerProvider extraReportClassManagerProvider;
                if (xMLableReader.isChildNode() && (extraReportClassManagerProvider = StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraReportClassManagerProvider", ExtraReportClassManagerProvider.class)) != null) {
                    extraReportClassManagerProvider.readXML(xMLableReader, Plugin.this.extraReportInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                }
            }
        });
    }

    private void readExtraForm(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    ExtraFormClassManagerProvider extraFormClassManagerProvider = StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraFormClassManagerProvider", ExtraFormClassManagerProvider.class);
                    if (extraFormClassManagerProvider == null) {
                        return;
                    }
                    extraFormClassManagerProvider.readXML(xMLableReader, Plugin.this.extraFormInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                }
            }
        });
    }

    private void readExtraCore(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    ExtraClassManager.getInstance().readXML(xMLableReader, Plugin.this.extraInterfaceList, PluginSimplify.create(Plugin.this.name, Plugin.this.id));
                }
            }
        });
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public void modifyActive(File file) throws Exception {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList nodeList = document.getElementsByTagName("active");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            object = (Element)nodeList.item(i2);
            object.setTextContent(this.active ? "yes" : "no");
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        object = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        ((Transformer)object).setOutputProperty("encoding", "UTF-8");
        StreamResult streamResult = new StreamResult(new FileOutputStream(file));
        ((Transformer)object).transform(dOMSource, streamResult);
    }

    public String toHTML() {
        String string = Inter.getLocText("FR-Plugin-Plugin_Name");
        String string2 = Inter.getLocText("FR-Plugin-Plugin_Version");
        String string3 = Inter.getLocText("FR-Plugin-Start_Version");
        String string4 = Inter.getLocText("FR-Plugin_Developer");
        String string5 = Inter.getLocText("FR-Plugin-Function_Description");
        String string6 = Inter.getLocText("FR-Plugin-Update_Log");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        hashMap.put("name_value", this.name);
        hashMap.put("version", string2);
        hashMap.put("version_value", this.version);
        hashMap.put("env", string3);
        hashMap.put("env_value", this.envVersion);
        hashMap.put("dev", string4);
        hashMap.put("dev_value", this.vendor);
        hashMap.put("fun", string5);
        hashMap.put("fun_value", this.description);
        hashMap.put("update", string6);
        hashMap.put("update_value", this.changeNotes);
        try {
            return TemplateUtils.renderTemplate("/com/fr/plugin/plugin.html", hashMap);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Plugin && ComparatorUtils.equals(((Plugin)object).id, this.id);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.id = jSONObject.optString("id");
        this.name = jSONObject.optString("name");
        this.version = jSONObject.optString("version");
        this.envVersion = jSONObject.optString("env-version");
        this.vendor = jSONObject.optString("vendor");
        this.description = jSONObject.optString("description");
        this.changeNotes = jSONObject.optString("change-notes");
        this.requiredJarTime = jSONObject.optString("requiredJarTime");
        this.active = jSONObject.optBoolean("active");
    }

    public void moveEmbFile(File file) {
        for (PluginEmbFile pluginEmbFile : this.pluginEmbFiles) {
            pluginEmbFile.operate(file);
        }
    }

    public Map<String, Set<String>> getModuleInterfaceMap() {
        this.initModuleInterfaceMap();
        return Collections.unmodifiableMap(this.moduleInterfaceMap);
    }

    private synchronized void initModuleInterfaceMap() {
        if (this.moduleInterfaceMap != null) {
            return;
        }
        this.moduleInterfaceMap = new HashMap<String, Set<String>>();
        this.moduleInterfaceMap.put("extra-core", new HashSet<String>(this.extraInterfaceList));
        this.moduleInterfaceMap.put("extra-chart", new HashSet<String>(this.extraChartInterfaceList));
        this.moduleInterfaceMap.put("extra-chart-designer", new HashSet<String>(this.extraChartDesignInterfaceList));
        this.moduleInterfaceMap.put("extra-designer", new HashSet<String>(this.extraDesignInterfaceList));
        this.moduleInterfaceMap.put("extra-form", new HashSet<String>(this.extraFormInterfaceList));
        this.moduleInterfaceMap.put("extra-platform", new HashSet<String>(this.extraPlatformInterfaceList));
        this.moduleInterfaceMap.put("extra-report", new HashSet<String>(this.extraReportInterfaceList));
    }

    public void delEmbFile() {
        for (PluginEmbFile pluginEmbFile : this.pluginEmbFiles) {
            pluginEmbFile.del();
        }
    }

    public InputStream readEncryptXml(InputStream inputStream) throws Exception {
        String string = IOUtils.inputStream2String(inputStream, "UTF-8");
        if (StringUtils.isNotBlank(string) && string.contains("<FREncrypted>")) {
            string = string.replaceAll("<FREncrypted>", "");
            string = DesUtils.decodeWithHex(string);
        }
        return new ByteArrayInputStream(string.getBytes("UTF-8"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NORMAL,
        BEYOND_SYSTEM,
        BELOW_SYSTEM;

    }
}

