/*
 * Decompiled with CFR 0.152.
 */
package com.fr.parser;

import com.fr.general.FArray;
import com.fr.stable.InterpreterError;
import com.fr.stable.OperationUtils;
import com.fr.stable.Primitive;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.AbstractNode;
import com.fr.stable.script.Atom;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorProviderContext;
import com.fr.stable.script.TinyHunter;
import java.math.BigDecimal;
import java.util.List;

public class UnaryExpression
extends AbstractNode {
    String op;
    Atom atom;

    UnaryExpression(String string, Atom atom) {
        this.op = string;
        this.atom = atom;
    }

    public Object eval(CalculatorProvider calculatorProvider) throws UtilEvalError {
        if (this.atom == null) {
            throw new InterpreterError("atom should not be null");
        }
        Object object = this.atom.eval(calculatorProvider);
        if (this.op != null) {
            object = this.primitiveWrapperUnaryOperation(object, this.op);
        }
        return object;
    }

    private Object primitiveWrapperUnaryOperation(Object object, String string) throws UtilEvalError {
        if (object == Primitive.ERROR_NAME || object == Primitive.ERROR_NAME) {
            return Primitive.ERROR_NAME;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            Object[] objectArray = new Object[fArray.length()];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = this.primitiveWrapperUnaryOperation(fArray.elementAt(i2), string);
            }
            return new FArray<Object>(objectArray);
        }
        Object object2 = OperationUtils.promoteCharByteShort(object);
        if (object2 instanceof Boolean) {
            return new Boolean(OperationUtils.booleanUnaryOperation((Boolean)object2, string));
        }
        if (object2 instanceof Integer) {
            return new Integer(OperationUtils.intUnaryOperation((Integer)object2, string));
        }
        if (object2 instanceof Long) {
            return new Long(OperationUtils.longUnaryOperation((Long)object2, string));
        }
        if (object2 instanceof Float) {
            return new Float(OperationUtils.floatUnaryOperation((Float)object2, string));
        }
        if (object2 instanceof Double) {
            return new Double(OperationUtils.doubleUnaryOperation((Double)object2, string));
        }
        if (object2 instanceof BigDecimal) {
            return OperationUtils.bigDecimalUnaryOperation((BigDecimal)object2, string);
        }
        throw new InterpreterError("error exists: " + string + this.atom);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        this.atom.traversal4Tiny(tinyHunter);
    }

    public String exString(CalculatorProvider calculatorProvider) {
        return (this.op != null ? this.op : "") + this.atom.exString(calculatorProvider);
    }

    public String toString() {
        return (this.op != null ? this.op : "") + this.atom.toString();
    }

    public String getExpression(int n2, int n3, int n4, int n5, boolean bl) {
        return (this.op != null ? this.op : "") + this.atom.getExpression(n2, n3, n4, n5, bl);
    }

    public String[] parserParameter() {
        return this.atom.parserParameter();
    }

    public String[] parserParameterNoColumnRow() {
        return this.atom.parserParameterNoColumnRow();
    }

    public boolean delay4PageCal() {
        return this.atom.delay4PageCal();
    }

    public void trav4HuntSIL(List list) {
        this.atom.trav4HuntSIL(list);
    }

    public void trav4HuntBIL(List list) {
        this.atom.trav4HuntBIL(list);
    }
}

