/*
 * Decompiled with CFR 0.152.
 */
package com.fr.parser;

import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.parser.MathExpression;
import com.fr.stable.OperationUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Node;
import com.fr.stable.script.TinyHunter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiExpression
extends MathExpression {
    private static final String MULTI = "*";
    private static final String DIV = "/";
    private static final String MOD = "%";
    private static final int DEFAULT_DECIMAL_SCALE = 20;
    String[] ops;
    Node[] powers;

    MultiExpression(Node[] nodeArray, String[] stringArray) {
        this.powers = nodeArray;
        this.ops = stringArray;
    }

    private static boolean isMULTI(String string) {
        return MULTI.equals(string);
    }

    private static boolean isDIV(String string) {
        return DIV.equals(string);
    }

    private static boolean isMOD(String string) {
        return MOD.equals(string);
    }

    protected int sizeOfNodes() {
        return this.powers.length;
    }

    protected String emptyNodesException() {
        return "powerList should not be empty";
    }

    protected Node getNodeByIndex(int n2) {
        return this.powers[n2];
    }

    protected String getOpByIndex(int n2) {
        return this.ops[n2];
    }

    protected boolean shortcutJudge() {
        return false;
    }

    protected Object ccNINI(String string) {
        if (MultiExpression.isMOD(string)) {
            return OperationUtils.ZERO;
        }
        if (MultiExpression.isMULTI(string)) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        return new Integer(1);
    }

    protected Object ccPIPI(String string) {
        return this.ccNINI(string);
    }

    protected Object ccNIPI(String string) {
        if (MultiExpression.isMOD(string)) {
            return OperationUtils.ZERO;
        }
        if (MultiExpression.isMULTI(string)) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        return new Integer(-1);
    }

    protected Object ccPINI(String string) {
        return this.ccNIPI(string);
    }

    protected Object ccNIRE(Object object, String string) {
        if (MultiExpression.isMOD(string)) {
            return OperationUtils.ZERO;
        }
        Number number = GeneralUtils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        int n2 = number.intValue();
        if (MultiExpression.isMULTI(string)) {
            if (n2 > 0) {
                return OperationUtils.NEGATIVE_INFINITY;
            }
            if (n2 == 0) {
                return OperationUtils.ZERO;
            }
            return OperationUtils.POSITIVE_INFINITY;
        }
        if (n2 >= 0) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccPIRE(Object object, String string) {
        Object object2 = this.ccNIRE(object, string);
        if (object2 == OperationUtils.POSITIVE_INFINITY) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (object2 == OperationUtils.NEGATIVE_INFINITY) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        return object2;
    }

    protected Object ccRENI(Object object, String string) {
        if (MultiExpression.isMOD(string) || MultiExpression.isDIV(string)) {
            return OperationUtils.ZERO;
        }
        Number number = GeneralUtils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        int n2 = number.intValue();
        if (n2 > 0) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (n2 == 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccREPI(Object object, String string) {
        Object object2 = this.ccRENI(object, string);
        if (object2 == OperationUtils.POSITIVE_INFINITY) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (object2 == OperationUtils.NEGATIVE_INFINITY) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        return object2;
    }

    protected Object ccRERE(Object object, Object object2, String string) {
        return this.numberOperation(object, object2, string);
    }

    protected Object decimalOperation(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        if (MultiExpression.isMULTI(string)) {
            return bigDecimal.multiply(bigDecimal2);
        }
        if (MultiExpression.isDIV(string)) {
            if (bigDecimal.compareTo(OperationUtils.BZERO) == 0) {
                return new Integer(0);
            }
            if (bigDecimal2.compareTo(OperationUtils.BZERO) == 0) {
                return bigDecimal.compareTo(OperationUtils.BZERO) > 0 ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
            }
            return bigDecimal.divide(bigDecimal2, bigDecimal.scale() > 20 ? bigDecimal.scale() : 20, 6);
        }
        return bigDecimal.toBigInteger().mod(bigDecimal2.toBigInteger());
    }

    protected Object doubleOperation(double d2, double d3, String string) {
        if (MultiExpression.isMULTI(string)) {
            return new Double(d2 * d3);
        }
        if (MultiExpression.isDIV(string)) {
            if (d2 == 0.0) {
                return new Integer(0);
            }
            if (d3 == 0.0) {
                return d2 > 0.0 ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
            }
            return new Double(d2 / d3);
        }
        return new Double(d2 % d3);
    }

    protected Object longOperation(long l2, long l3, String string) {
        if (MultiExpression.isMULTI(string)) {
            BigInteger bigInteger = BigInteger.valueOf(l2).multiply(BigInteger.valueOf(l3));
            if (Math.abs(bigInteger.longValue()) > (long)Math.abs(bigInteger.intValue())) {
                return bigInteger;
            }
            return new Integer(bigInteger.intValue());
        }
        if (MultiExpression.isDIV(string)) {
            if (l2 == 0L) {
                return new Integer(0);
            }
            if (l3 == 0L) {
                FRLogger.getLogger().error("\u9664\u6570\u4e3a\u96f6");
                return l2 > 0L ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
            }
            return new Double((double)l2 / (double)l3);
        }
        return this.processLongValue(l2 % l3);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            this.powers[i2].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(CalculatorProvider calculatorProvider) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(' ').append(this.ops[i2 - 1]).append(' ');
            }
            stringBuffer.append(this.powers[i2].exString(calculatorProvider));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(' ').append(this.ops[i2 - 1]).append(' ');
            }
            stringBuffer.append(this.powers[i2]);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n2, int n3, int n4, int n5, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(' ').append(this.ops[i2 - 1]).append(' ');
            }
            stringBuffer.append(this.powers[i2].getExpression(n2, n3, n4, n5, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.powers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.addAll(Arrays.asList(this.powers[i2].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] parserParameterNoColumnRow() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.powers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.addAll(Arrays.asList(this.powers[i2].parserParameterNoColumnRow()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean delay4PageCal() {
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            if (!this.powers[i2].delay4PageCal()) continue;
            return true;
        }
        return false;
    }

    public void trav4HuntSIL(List list) {
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            this.powers[i2].trav4HuntSIL(list);
        }
    }

    public void trav4HuntBIL(List list) {
        for (int i2 = 0; i2 < this.powers.length; ++i2) {
            this.powers[i2].trav4HuntBIL(list);
        }
    }
}

