/*
 * Decompiled with CFR 0.152.
 */
package com.fr.parser;

import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.stable.InterpreterError;
import com.fr.stable.Primitive;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.AbstractNode;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorProviderContext;
import com.fr.stable.script.Node;
import java.util.Arrays;

public abstract class BinaryExpression
extends AbstractNode {
    public Object eval(CalculatorProvider calculatorProvider) throws UtilEvalError {
        int n2 = this.sizeOfNodes();
        if (n2 == 0) {
            throw new InterpreterError(this.emptyNodesException());
        }
        Object object = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = this.getNodeByIndex(i2);
            if (i2 == 0) {
                object = node.eval(calculatorProvider);
            } else {
                Object object2 = node.eval(calculatorProvider);
                object = this.binaryOperation(object, object2, this.getOpByIndex(i2 - 1));
            }
            if (i2 >= n2 - 1 || !this.shortcutJudge() || !this.judge(object)) continue;
            return object;
        }
        return object;
    }

    protected abstract int sizeOfNodes();

    protected abstract String emptyNodesException();

    protected abstract Node getNodeByIndex(int var1);

    protected abstract String getOpByIndex(int var1);

    protected boolean shortcutJudge() {
        return false;
    }

    protected boolean judge(Object object) {
        return false;
    }

    protected Object binaryOperation(Object object, Object object2, String string) throws UtilEvalError {
        if (object == null) {
            object = Primitive.NULL;
        }
        if (object2 == null) {
            object2 = Primitive.NULL;
        }
        if (object == Primitive.ERROR_NAME || object == Primitive.ERROR_VALUE || object2 == Primitive.ERROR_NAME || object2 == Primitive.ERROR_VALUE) {
            return Primitive.ERROR_NAME;
        }
        if (object == Primitive.NOFILTER || object2 == Primitive.NOFILTER) {
            if (this.isRelationExpression()) {
                return Boolean.TRUE;
            }
            return Primitive.NOFILTER;
        }
        if (!(object instanceof Number)) {
            object = CalculatorProviderContext.getValueConverter().result2Value(object);
        }
        object2 = CalculatorProviderContext.getValueConverter().result2Value(object2);
        if (object instanceof FArray && object2 instanceof FArray) {
            return this.arrayBinaryOperation((FArray)object, (FArray)object2, string);
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            if (this.isRelationExpression() && fArray.length() == 0) {
                return ComparatorUtils.equals((Object)"", object2);
            }
            Object[] objectArray = new Object[fArray.length()];
            Arrays.fill(objectArray, object2);
            return this.arrayBinaryOperation(fArray, new FArray<Object>(objectArray), string);
        }
        if (object2 instanceof FArray) {
            FArray fArray = (FArray)object2;
            if (this.isRelationExpression() && fArray.length() == 0) {
                return ComparatorUtils.equals((Object)"", object);
            }
            Object[] objectArray = new Object[fArray.length()];
            Arrays.fill(objectArray, object);
            return this.arrayBinaryOperation(new FArray<Object>(objectArray), fArray, string);
        }
        return this.objectBinaryOperation(object, object2, string);
    }

    protected boolean isRelationExpression() {
        return false;
    }

    protected Object arrayBinaryOperation(FArray fArray, FArray fArray2, String string) throws UtilEvalError {
        int n2 = fArray.length();
        int n3 = fArray2.length();
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        Object[] objectArray = new Object[n5];
        for (int i2 = 0; i2 < n4; ++i2) {
            objectArray[i2] = this.binaryOperation(fArray.elementAt(i2), fArray2.elementAt(i2), string);
        }
        FArray fArray3 = n2 == n5 ? fArray : fArray2;
        for (int i3 = n4; i3 < n5; ++i3) {
            objectArray[i3] = fArray3.elementAt(i3);
        }
        return new FArray<Object>(objectArray);
    }

    protected abstract Object objectBinaryOperation(Object var1, Object var2, String var3) throws UtilEvalError;
}

