/*
 * Decompiled with CFR 0.152.
 */
package com.fr.main;

import com.fr.main.TemplateWorkBook;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.stable.ReportSettings;
import java.util.ArrayList;
import java.util.List;

public class SynchronizedReportSettings {
    private static ThreadLocal threadReportSettingsTL = new ThreadLocal();
    private TemplateWorkBook wbTpl;
    private ReportSettingsProvider reportSettings;

    private SynchronizedReportSettings(TemplateWorkBook templateWorkBook, ReportSettings reportSettings) {
        this.wbTpl = templateWorkBook;
        this.reportSettings = reportSettings;
    }

    public TemplateWorkBook getWbTpl() {
        return this.wbTpl;
    }

    public void setWbTpl(TemplateWorkBook templateWorkBook) {
        this.wbTpl = templateWorkBook;
    }

    public ReportSettingsProvider getReportSettings() {
        return this.reportSettings;
    }

    public void setReportSettings(ReportSettingsProvider reportSettingsProvider) {
        this.reportSettings = reportSettingsProvider;
    }

    public static void putSynchronizedReportSettings(TemplateWorkBook templateWorkBook, ReportSettings reportSettings) {
        if (templateWorkBook == null || reportSettings == null) {
            return;
        }
        ArrayList<SynchronizedReportSettings> arrayList = (ArrayList<SynchronizedReportSettings>)threadReportSettingsTL.get();
        if (arrayList != null) {
            arrayList.add(new SynchronizedReportSettings(templateWorkBook, reportSettings));
        } else {
            arrayList = new ArrayList<SynchronizedReportSettings>(6);
            arrayList.add(new SynchronizedReportSettings(templateWorkBook, reportSettings));
            threadReportSettingsTL.set(arrayList);
        }
    }

    public static void flushSynchronizedReportSettings() {
        List list = (List)threadReportSettingsTL.get();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                SynchronizedReportSettings synchronizedReportSettings = (SynchronizedReportSettings)list.get(i2);
                if (synchronizedReportSettings == null) continue;
                for (int i3 = 0; i3 < synchronizedReportSettings.getWbTpl().getReportCount(); ++i3) {
                    synchronizedReportSettings.getWbTpl().getReport(i3).setReportSettings(synchronizedReportSettings.getReportSettings());
                }
            }
        }
        threadReportSettingsTL.set(null);
    }
}

