/*
 * Decompiled with CFR 0.152.
 */
package com.fr.log;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteInfo;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.LogDuration;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.ExportSessionManager;
import com.fr.json.JSONArray;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PageSetCreater;
import com.fr.page.PageSetProvider;
import com.fr.performance.EnginePerformanceManager;
import com.fr.performance.PerformanceManager;
import com.fr.performance.info.IExportInfo;
import com.fr.report.report.ECReport;
import com.fr.report.stable.fun.Actor;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class LogUtils {
    public static ResultWorkBook executeAndLogRecord(TemplateWorkBook templateWorkBook, String string, Map map, Actor actor) {
        return LogUtils.executeAndLogRecord(templateWorkBook, string, map, actor, -1);
    }

    public static ResultWorkBook executeAndLogRecord(TemplateWorkBook templateWorkBook, String string, Map map, Actor actor, int n2) {
        if (templateWorkBook == null) {
            return null;
        }
        String string2 = FRLogger.createParamString(map);
        FRLogManager.declareExecuteStart(string, string2, actor.getRecordType());
        try {
            long l2 = System.currentTimeMillis();
            ResultWorkBook resultWorkBook = templateWorkBook.execute(map, actor, n2);
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            LogUtils.performanceRecord(resultWorkBook, l4);
            ExecuteInfo executeInfo = new ExecuteInfo(string2, l4, FRLogManager.getDeclareSQLContent(), LogUtils.calResultWorkBookMemory(resultWorkBook));
            LogUtils.recordExecuteInfoWithCondition(string, actor, executeInfo);
            ResultWorkBook resultWorkBook2 = resultWorkBook;
            return resultWorkBook2;
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareExecuteEnd();
        }
    }

    public static void performanceRecord(ResultWorkBook resultWorkBook, long l2) {
        LogUtils.recordMemory(resultWorkBook);
        PerformanceManager.getRecorder().recordCalculateTime(l2);
    }

    private static void recordMemory(ResultWorkBook resultWorkBook) {
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (!resultWorkBook.isElementCaseBook(i2)) continue;
            ECReport eCReport = resultWorkBook.getElementCaseReport(i2);
            String string = eCReport.getBook().getReportName(i2);
            long l2 = LogUtils.calSingleSheetMemory(eCReport);
            PerformanceManager.getRecorder().recordReportMemory(string, l2);
        }
    }

    private static long calSingleSheetMemory(ECReport eCReport) {
        int n2 = eCReport.getRowCount();
        int n3 = eCReport.getColumnCount();
        return n2 * n3 * 200;
    }

    public static long calResultWorkBookMemory(ResultWorkBook resultWorkBook) {
        long l2 = 0L;
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (!resultWorkBook.isElementCaseBook(i2)) continue;
            ECReport eCReport = resultWorkBook.getElementCaseReport(i2);
            l2 += LogUtils.calSingleSheetMemory(eCReport);
        }
        return l2;
    }

    public static void recordExecuteInfoWithCondition(String string, Actor actor, ExecuteInfo executeInfo) {
        if (!actor.shouldRecord()) {
            return;
        }
        LogUtils.recordExecuteInfo(string, actor.getRecordType(), executeInfo);
    }

    public static void exportAndLogRecord(AppExporter appExporter, OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal, DeclareRecordType declareRecordType) throws Exception {
        final ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor((Repository)reportRepositoryDeal);
        if (appExporter == null || reportSessionIDInfor == null || outputStream == null) {
            return;
        }
        LogUtils.exportAndLogRecord(appExporter, outputStream, reportRepositoryDeal, declareRecordType, (LogDuration)reportSessionIDInfor, reportSessionIDInfor.getBookPath(), reportSessionIDInfor.getWorkBook2Show(), new PageSetCreater(){

            public PageSetProvider createPageSet() {
                return reportSessionIDInfor.getPrintPreviewPageSet4Traversing();
            }
        });
    }

    public static void exportAndLogRecord(AppExporter appExporter, OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal, DeclareRecordType declareRecordType, LogDuration logDuration, String string, ResultWorkBook resultWorkBook, PageSetCreater pageSetCreater) throws Exception {
        FRLogManager.setSession(logDuration);
        String string2 = FRLogger.createParamString(((SessionIDInfor)logDuration).getParameterMap4Execute4Consisent());
        FRLogManager.declareExportStart(string, string2, declareRecordType);
        String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)reportRepositoryDeal.getHttpServletRequest(), (String)"sheets");
        ExportSessionManager exportSessionManager = ExportSessionManager.getInstance();
        String string4 = logDuration.getSessionID();
        int[] nArray = null;
        if (string3 != null) {
            JSONArray jSONArray = new JSONArray(string3);
            nArray = new int[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                nArray[i2] = jSONArray.getInt(i2);
            }
        }
        try {
            long l2 = System.currentTimeMillis();
            LogUtils.export(appExporter, outputStream, reportRepositoryDeal, string4, string, resultWorkBook, pageSetCreater, exportSessionManager, nArray, declareRecordType);
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            LogUtils.recordExportInfo(appExporter, resultWorkBook, l4, declareRecordType);
            FRContext.getLogger().info(Inter.getLocText(new String[]{"FR-Designer_Finish_Export", "INFO-Time_Taken", "Milliseconds"}, new String[]{"\t", ":" + (l3 - l2)}));
            if (ConfigManager.getProviderInstance().getLogConfig().isRecordExp()) {
                LogUtils.recordExportInfo(string, string2, declareRecordType, l4, FRLogManager.getDeclareSQLContent());
            }
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareExportEnd();
        }
    }

    private static void recordExportInfo(AppExporter appExporter, ResultWorkBook resultWorkBook, long l2, DeclareRecordType declareRecordType) {
        long l3 = EnginePerformanceManager.getMemoryEstimation().estimateMemory(appExporter, resultWorkBook);
        IExportInfo iExportInfo = PerformanceManager.getInfoFactory().createExportInfo();
        iExportInfo.setExportTime(l2);
        iExportInfo.setMemory(l3);
        iExportInfo.setType(declareRecordType.getTypeString());
        PerformanceManager.getRecorder().recordExportInfo(iExportInfo);
    }

    public static void recordExecuteInfo(String string, DeclareRecordType declareRecordType, ExecuteInfo executeInfo) {
        try {
            FRContext.getLogger().getRecordManager().recordExecuteInfo(string, declareRecordType, executeInfo);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(AppExporter appExporter, OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal, String string, String string2, ResultWorkBook resultWorkBook, PageSetCreater pageSetCreater, ExportSessionManager exportSessionManager, int[] nArray, DeclareRecordType declareRecordType) throws Exception {
        exportSessionManager.addExportSession(string, declareRecordType.getTypeString());
        try {
            appExporter.export(outputStream, resultWorkBook, pageSetCreater, reportRepositoryDeal, nArray);
        }
        finally {
            exportSessionManager.removeExportSession(string, declareRecordType.getTypeString());
        }
    }

    public static void recordAccessNoExecuteInfo(String string, DeclareRecordType declareRecordType, ExecuteInfo executeInfo) {
        if (!ConfigManager.getProviderInstance().getLogConfig().isRecordExe4page()) {
            return;
        }
        try {
            FRContext.getLogger().getRecordManager().recordAccessNoExecuteInfo(string, declareRecordType, executeInfo);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    public static void recordExportInfo(String string, String string2, DeclareRecordType declareRecordType, long l2, String string3) {
        try {
            FRContext.getLogger().getRecordManager().recordExportInfo(string, string2, declareRecordType, l2, string3);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    public static void recordPrintInfo(String string, Map map, DeclareRecordType declareRecordType, ReportSessionIDInfor reportSessionIDInfor) {
        if (!ConfigManager.getProviderInstance().getLogConfig().isRecordPrt()) {
            return;
        }
        try {
            FRLogManager.setSession((LogDuration)reportSessionIDInfor);
            FRContext.getLogger().getRecordManager().recordPrintInfo(string, FRLogger.createParamString(map), declareRecordType);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }
}

