/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TemplateUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.MessagingException;

public class EmailJavaScript
extends AbstractJavaScript {
    private String mailTo;
    private String cc;
    private String bcc;
    private String title;
    private String mailText;
    private boolean showTplContent;

    protected String actionJS(Repository repository) {
        if (StringUtils.isBlank(this.mailTo)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(TemplateUtils.readTemplate2String("/com/fr/js/EmailJavaScript.tpl", "UTF-8"));
        stringBuffer.append(JSONObject.quote(GeneralXMLTools.writeXMLableAsString(this)));
        if (!this.paraMap.isEmpty()) {
            stringBuffer.append(",paraMap:").append(new JSONObject(this.paraMap).toString());
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (StringUtils.isNotEmpty(this.mailTo)) {
            jSONObject.put("mailTo", this.mailTo);
        }
        if (StringUtils.isNotEmpty(this.cc)) {
            jSONObject.put("cc", this.cc);
        }
        if (StringUtils.isNotEmpty(this.bcc)) {
            jSONObject.put("bcc", this.bcc);
        }
        if (StringUtils.isNotEmpty(this.title)) {
            jSONObject.put("title", this.title);
        }
        if (StringUtils.isNotEmpty(this.mailText)) {
            jSONObject.put("mailText", this.mailText);
        }
        jSONObject.put("sessionID", repository.getSessionID());
        jSONObject.put("showTplContent", this.showTplContent);
        jSONObject.put("type", "email");
        return jSONObject;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String string) {
        this.mailTo = string;
    }

    public String getCC() {
        return this.cc;
    }

    public void setCC(String string) {
        this.cc = string;
    }

    public String getBCC() {
        return this.bcc;
    }

    public void setBCC(String string) {
        this.bcc = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getMainText() {
        return this.mailText;
    }

    public void setMainText(String string) {
        this.mailText = string;
    }

    public boolean isShowTplContent() {
        return this.showTplContent;
    }

    public void setShowTplContent(boolean bl) {
        this.showTplContent = bl;
    }

    public void renderParameters(Calculator calculator) {
        try {
            this.setBCC(TemplateUtils.render(this.getBCC(), calculator));
            this.setCC(TemplateUtils.render(this.getCC(), calculator));
            this.setMailTo(TemplateUtils.render(this.getMailTo(), calculator));
            this.setMainText(TemplateUtils.render(this.getMainText(), calculator));
            this.setTitle(TemplateUtils.render(this.getTitle(), calculator));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("EmailJS")) {
            this.mailTo = xMLableReader.getAttrAsString("mailTo", null);
            this.cc = xMLableReader.getAttrAsString("cc", null);
            this.bcc = xMLableReader.getAttrAsString("bcc", null);
            this.title = xMLableReader.getAttrAsString("title", null);
            this.mailText = xMLableReader.getAttrAsString("mainText", null);
            this.showTplContent = xMLableReader.getAttrAsBoolean("showTplContent", false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("EmailJS").attr("mailTo", this.mailTo).attr("cc", this.cc).attr("bcc", this.bcc).attr("title", this.title).attr("mainText", this.mailText).attr("showTplContent", this.showTplContent).end();
    }

    public void sentMail(Calculator calculator, Object object, NameSpace nameSpace) throws MessagingException {
        if (StringUtils.isBlank(this.mailTo)) {
            return;
        }
        EmailManager emailManager = ConfigManager.getProviderInstance().getEmailManager();
        Map map = emailManager.getAllUsersMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mailbr", "\r\n");
        calculator.pushNameSpace(ParameterMapNameSpace.create(hashMap));
        calculator.pushNameSpace(nameSpace);
        emailManager.send(this.getMailAddress(this.mailTo, map, calculator), this.getMailAddress(this.cc, map, calculator), this.getMailAddress(this.bcc, map, calculator), emailManager.getFromEmailAddress(), TemplateUtils.renderTpl(calculator, this.title), TemplateUtils.renderTpl(calculator, this.mailText), null, object);
        calculator.removeNameSpace(nameSpace);
    }

    private String getMailAddress(String string, Map map, Calculator calculator) {
        if (string == null) {
            return null;
        }
        String[] stringArray = TemplateUtils.renderTpl(calculator, string).split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            if (this.isMailValid(stringArray[i2]) || !StringUtils.isNotEmpty(string2 = (String)map.get(stringArray[i2]))) continue;
            stringArray[i2] = string2;
        }
        return StringUtils.join(",", stringArray);
    }

    private boolean isMailValid(String string) {
        String string2 = "\\w{0,}\\@\\w{0,}\\.{1}\\w{0,}";
        String string3 = "\\w{0,}\\@\\w{0,}\\.{1}\\w{0,}\\.{1}\\w{0,}";
        return StringUtils.isNotEmpty(string) && Pattern.matches(string2, string) && Pattern.matches(string3, string);
    }
}

