/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.core;

import com.fr.base.DynamicUnitList;
import com.fr.data.TableDataSource;
import com.fr.io.core.ExcelReport;
import com.fr.io.core.ExporterUtils;
import com.fr.main.FineBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ECReport;
import com.fr.stable.FT;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNITConstants;
import java.util.Iterator;

public class PageExcelExporterReport
extends ExcelReport {
    private ECReport sourceReport;
    private PageSetProvider pageSet;
    private FT xArea;
    private FT yArea;
    private int[] maxXY;
    private FT pageInfo;
    private int pageOrder;
    private ReportPageProvider[][] page2D;

    public PageExcelExporterReport(ECReport eCReport, PageSetProvider pageSetProvider, FT fT, FT fT2, FT fT3, int[] nArray, int n2) {
        this.sourceReport = eCReport;
        this.pageSet = pageSetProvider;
        this.xArea = fT;
        this.yArea = fT2;
        this.maxXY = nArray;
        this.pageOrder = n2;
        this.pageInfo = fT3;
        this.init();
    }

    public int getColumnCount() {
        return this.sourceReport.getColumnCount();
    }

    private void init() {
        ClippedPageProvider clippedPageProvider;
        int n2;
        int n3;
        int n4;
        this.page2D = new ReportPageProvider[this.yArea.to - this.yArea.from][this.xArea.to - this.xArea.from];
        if (this.pageOrder == 0) {
            for (n4 = this.xArea.from; n4 < this.xArea.to; ++n4) {
                for (n3 = this.yArea.from; n3 < this.yArea.to; ++n3) {
                    this.page2D[n3 - this.yArea.from][n4 - this.xArea.from] = this.pageSet.getPage(n3 - 1 + (n4 - 1) * this.maxXY[1]);
                    this.page2D[n3 - this.yArea.from][n4 - this.xArea.from].setTotalPages(this.pageInfo.to);
                    this.page2D[n3 - this.yArea.from][n4 - this.xArea.from].setCurrentPageNumber(this.page2D[n3 - this.yArea.from][n4 - this.xArea.from].getCurrentPageNumber() + this.pageInfo.from);
                }
            }
        } else {
            for (n4 = this.yArea.from; n4 < this.yArea.to; ++n4) {
                for (n3 = this.xArea.from; n3 < this.xArea.to; ++n3) {
                    this.page2D[n4 - this.yArea.from][n3 - this.xArea.from] = this.pageSet.getPage(n3 - 1 + (n4 - 1) * this.maxXY[0]);
                    this.page2D[n4 - this.yArea.from][n3 - this.xArea.from].setTotalPages(this.pageInfo.to);
                    this.page2D[n4 - this.yArea.from][n3 - this.xArea.from].setCurrentPageNumber(this.page2D[n4 - this.yArea.from][n3 - this.xArea.from].getCurrentPageNumber() + this.pageInfo.from);
                }
            }
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < this.page2D.length; ++n2) {
            clippedPageProvider = ExporterUtils.support(this.page2D[n2][0]);
            if (clippedPageProvider == null) continue;
            n4 += clippedPageProvider.getRowCount();
        }
        for (n2 = 0; n2 < this.page2D[0].length; ++n2) {
            clippedPageProvider = ExporterUtils.support(this.page2D[0][n2]);
            if (clippedPageProvider == null) continue;
            n3 += clippedPageProvider.getColumnCount();
        }
        this.columnWidthList = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n3);
        this.rowHeightList = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n4);
    }

    public DynamicUnitList getRowHeightList_DEC() {
        if (this.getReportPageAttr().isUnUsed()) {
            try {
                return (DynamicUnitList)this.sourceReport.getRowHeightList_DEC().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return this.rowHeightList;
    }

    public DynamicUnitList getColumnWidthList_DEC() {
        if (this.getReportPageAttr().isUnUsed()) {
            try {
                return (DynamicUnitList)this.sourceReport.getColumnWidthList_DEC().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return this.columnWidthList;
    }

    public FU getColumnWidth(int n2) {
        return this.columnWidthList.get(n2);
    }

    public FU getRowHeight(int n2) {
        return this.rowHeightList.get(n2);
    }

    public Iterator cellIterator() {
        return new PageExcelCellIterator();
    }

    public ReportHFProvider getFooter(int n2) {
        return this.sourceReport.getFooter(n2);
    }

    public ReportHFProvider getHeader(int n2) {
        return this.sourceReport.getHeader(n2);
    }

    public ReportPageAttrProvider getReportPageAttr() {
        return this.sourceReport.getReportPageAttr();
    }

    public ReportSettingsProvider getReportSettings() {
        return ReportUtils.getReportSettings(this.sourceReport);
    }

    public ResultWorkBook getResultWorkBook() {
        return null;
    }

    public void setResultWorkBook(ResultWorkBook resultWorkBook) {
        throw new UnsupportedOperationException();
    }

    public FineBook getBook() {
        return null;
    }

    public TableDataSource getTableDataSource() {
        return null;
    }

    public void shrinkTOFitRowHeightForCellElement(CellElement cellElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void shrinkTOFitColumnWidthForCellElement(CellElement cellElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class PageExcelCellIterator
    extends ExcelReport.ExcelCellIterator {
        private PageExcelCellIterator() {
        }

        protected int initial_x_checklast_size() {
            return PageExcelExporterReport.this.page2D[0].length;
        }

        protected void initial_varibles_by_constructor() {
            this.maxX = PageExcelExporterReport.this.page2D[0].length - 1;
            this.maxY = PageExcelExporterReport.this.page2D.length - 1;
        }

        protected void findNext() {
            while (this.current_page_y < PageExcelExporterReport.this.page2D.length) {
                ReportPageProvider[] reportPageProviderArray = PageExcelExporterReport.this.page2D[this.current_page_y];
                if (this.iteratePageArray(reportPageProviderArray, 0, true, this.maxX, this.maxY)) {
                    return;
                }
                ++this.current_page_y;
            }
            this.next = null;
        }
    }
}

