/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io;

import com.fr.base.Env;
import com.fr.base.io.XMLEncryptUtils;
import com.fr.general.FRLogManager;
import com.fr.general.Inter;
import com.fr.general.ModuleContext;
import com.fr.main.TemplateWorkBook;
import com.fr.main.impl.WorkBook;
import com.fr.report.module.EngineModule;
import com.fr.stable.StableUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

public final class TemplateWorkBookIO {
    public static TemplateWorkBook readTemplateWorkBook(Env env, String string) throws Exception {
        WorkBook workBook;
        block12: {
            if (string == null) {
                return null;
            }
            workBook = null;
            FRLogManager.declareResourceReadStart(string);
            ModuleContext.startModule(EngineModule.class.getName());
            try {
                InputStream inputStream = env.readBean(string, "reportlets");
                if (inputStream != null) {
                    if (string.endsWith(".cpt")) {
                        workBook = new WorkBook();
                        workBook.readStream(XMLEncryptUtils.decodeInputStream(inputStream));
                    } else if (string.endsWith(".xls")) {
                        Class<?> clazz = Class.forName("com.fr.io.importer.ExcelReportImporter");
                        workBook = (WorkBook)clazz.getMethod("generateWorkBookByStream", InputStream.class).invoke(clazz.newInstance(), inputStream);
                    } else if (string.endsWith(".xlsx")) {
                        Class<?> clazz = Class.forName("com.fr.io.importer.Excel2007ReportImporter");
                        workBook = (WorkBook)clazz.getMethod("generateWorkBookByStream", InputStream.class).invoke(clazz.newInstance(), inputStream);
                    }
                    inputStream.close();
                    break block12;
                }
                throw new FileNotFoundException(Inter.getLocText("NS_exception_noTemplate") + ":" + string);
            }
            catch (Exception exception) {
                throw FRLogManager.createLogPackedException(exception);
            }
            finally {
                FRLogManager.declareResourceReadEnd();
            }
        }
        return workBook;
    }

    public static boolean writeTemplateWorkBook(Env env, TemplateWorkBook templateWorkBook, String string) throws Exception {
        FRLogManager.declareResourceWriteStart(string);
        ModuleContext.startModule(EngineModule.class.getName());
        try {
            OutputStream outputStream = env.writeBean(string, "reportlets");
            ((WorkBook)templateWorkBook).export(outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareResourceWriteEnd();
        }
        return true;
    }

    public static long getLastModifiedTime(Env env, String string) {
        try {
            File file = new File(StableUtils.pathJoin(env.getPath(), "reportlets", string));
            return file.lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

