/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.script;

import com.fr.general.GeneralUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.math.BigDecimal;

public class FunctionHelper {
    private static final int TEN = 10;
    private static final int TWENTY = 20;
    private static final int THIRTY = 30;
    private static final int FORTY = 40;
    private static final int FIFTY = 50;
    private static final int SIXTY = 60;
    private static final int SEVENTY = 70;
    private static final int EIGHTY = 80;
    private static final int NINETY = 90;

    private FunctionHelper() {
    }

    public static String NumberToEnglish(BigDecimal bigDecimal) throws Exception {
        String[] stringArray;
        int n2;
        String string = "";
        int n3 = bigDecimal.intValue();
        if (n3 >= 20) {
            int n4 = n3 / 10 * 10;
            n2 = n3 - n4;
            string = FunctionHelper.getNumAsLetter(n4);
            if (StringUtils.isNotEmpty(string)) {
                string = string + " ";
            }
        } else {
            n2 = n3;
        }
        if ((stringArray = new String[]{"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"}).length > n2) {
            string = string + stringArray[n2];
        }
        return string;
    }

    private static String getNumAsLetter(int n2) {
        switch (n2) {
            case 90: {
                return "NINETY";
            }
            case 80: {
                return "EIGHTY";
            }
            case 70: {
                return "SEVENTY";
            }
            case 60: {
                return "SIXTY";
            }
            case 50: {
                return "FIFTY";
            }
            case 40: {
                return "FORTY";
            }
            case 30: {
                return "THIRTY";
            }
            case 20: {
                return "TWENTY";
            }
        }
        return "";
    }

    public static Number asNumber(long l2) {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            return new Long(l2);
        }
        return new Integer((int)l2);
    }

    public static Number asNumber(double d2) {
        long l2 = (long)d2;
        if (d2 != (double)l2) {
            if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                return new Double(d2);
            }
            return Double.valueOf(StableUtils.doubleToString(d2));
        }
        return FunctionHelper.asNumber(l2);
    }

    public static Object roundUpOrDown(Object[] objectArray, boolean bl) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        double d2 = GeneralUtils.objectToNumber(objectArray[0], false).doubleValue();
        int n2 = objectArray.length < 2 ? 0 : GeneralUtils.objectToNumber(objectArray[1], false).intValue();
        double d3 = d2;
        if (n2 >= 0) {
            d3 = new BigDecimal(d2 + "").setScale(n2, bl ? 0 : 1).doubleValue();
        } else if (n2 < 0) {
            double d4 = Math.pow(10.0, -n2 * 2);
            d3 = new BigDecimal(d2 / d4 + "").setScale(-n2, bl ? 0 : 1).doubleValue() * d4;
        }
        return FunctionHelper.asNumber(d3);
    }
}

