/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.doubleparse;

public class FpUtils {
    static double twoToTheDoubleScaleUp = FpUtils.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = FpUtils.powerOfTwoD(-512);

    private FpUtils() {
    }

    public static int getExponent(double d2) {
        return (int)(((Double.doubleToRawLongBits(d2) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static int getExponent(float f2) {
        return ((Float.floatToRawIntBits(f2) & 0x7F800000) >> 23) - 127;
    }

    static double powerOfTwoD(int n2) {
        return Double.longBitsToDouble((long)n2 + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n2) {
        return Float.intBitsToFloat(n2 + 127 << 23 & 0x7F800000);
    }

    public static double rawCopySign(double d2, double d3) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & Long.MIN_VALUE | Double.doubleToRawLongBits(d2) & Long.MAX_VALUE);
    }

    public static float rawCopySign(float f2, float f3) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(f3) & Integer.MIN_VALUE | Float.floatToRawIntBits(f2) & Integer.MAX_VALUE);
    }

    public static boolean isFinite(double d2) {
        return Math.abs(d2) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f2) {
        return Math.abs(f2) <= Float.MAX_VALUE;
    }

    public static boolean isInfinite(double d2) {
        return Double.isInfinite(d2);
    }

    public static boolean isInfinite(float f2) {
        return Float.isInfinite(f2);
    }

    public static boolean isNaN(double d2) {
        return Double.isNaN(d2);
    }

    public static boolean isNaN(float f2) {
        return Float.isNaN(f2);
    }

    public static boolean isUnordered(double d2, double d3) {
        return FpUtils.isNaN(d2) || FpUtils.isNaN(d3);
    }

    public static boolean isUnordered(float f2, float f3) {
        return FpUtils.isNaN(f2) || FpUtils.isNaN(f3);
    }

    public static int ilogb(double d2) {
        int n2 = FpUtils.getExponent(d2);
        switch (n2) {
            case 1024: {
                if (FpUtils.isNaN(d2)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -1023: {
                if (d2 == 0.0) {
                    return -268435456;
                }
                long l2 = Double.doubleToRawLongBits(d2);
                l2 &= 0xFFFFFFFFFFFFFL;
                while (l2 < 0x10000000000000L) {
                    l2 *= 2L;
                    --n2;
                }
                return ++n2;
            }
        }
        return n2;
    }

    public static int ilogb(float f2) {
        int n2 = FpUtils.getExponent(f2);
        switch (n2) {
            case 128: {
                if (FpUtils.isNaN(f2)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -127: {
                if (f2 == 0.0f) {
                    return -268435456;
                }
                int n3 = Float.floatToRawIntBits(f2);
                n3 &= 0x7FFFFF;
                while (n3 < 0x800000) {
                    n3 *= 2;
                    --n2;
                }
                return ++n2;
            }
        }
        return n2;
    }

    public static double scalb(double d2, int n2) {
        int n3 = 2099;
        int n4 = 0;
        int n5 = 0;
        double d3 = Double.NaN;
        if (n2 < 0) {
            n2 = Math.max(n2, -2099);
            n5 = -512;
            d3 = twoToTheDoubleScaleDown;
        } else {
            n2 = Math.min(n2, 2099);
            n5 = 512;
            d3 = twoToTheDoubleScaleUp;
        }
        int n6 = n2 >> 8 >>> 23;
        n4 = (n2 + n6 & 0x1FF) - n6;
        d2 *= FpUtils.powerOfTwoD(n4);
        n2 -= n4;
        while (n2 != 0) {
            d2 *= d3;
            n2 -= n5;
        }
        return d2;
    }

    public static float scalb(float f2, int n2) {
        int n3 = 278;
        n2 = Math.max(Math.min(n2, 278), -278);
        return (float)((double)f2 * FpUtils.powerOfTwoD(n2));
    }

    public static double nextAfter(double d2, double d3) {
        if (FpUtils.isNaN(d2) || FpUtils.isNaN(d3)) {
            return d2 + d3;
        }
        if (d2 == d3) {
            return d3;
        }
        long l2 = Double.doubleToRawLongBits(d2 + 0.0);
        l2 = d3 > d2 ? (l2 += l2 >= 0L ? 1L : -1L) : (l2 > 0L ? --l2 : (l2 < 0L ? ++l2 : -9223372036854775807L));
        return Double.longBitsToDouble(l2);
    }

    public static float nextAfter(float f2, double d2) {
        if (FpUtils.isNaN(f2) || FpUtils.isNaN(d2)) {
            return f2 + (float)d2;
        }
        if ((double)f2 == d2) {
            return (float)d2;
        }
        int n2 = Float.floatToRawIntBits(f2 + 0.0f);
        n2 = d2 > (double)f2 ? (n2 += n2 >= 0 ? 1 : -1) : (n2 > 0 ? --n2 : (n2 < 0 ? ++n2 : -2147483647));
        return Float.intBitsToFloat(n2);
    }

    public static double nextUp(double d2) {
        if (FpUtils.isNaN(d2) || d2 == Double.POSITIVE_INFINITY) {
            return d2;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2 += 0.0) + (d2 >= 0.0 ? 1L : -1L));
    }

    public static float nextUp(float f2) {
        if (FpUtils.isNaN(f2) || f2 == Float.POSITIVE_INFINITY) {
            return f2;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2 += 0.0f) + (f2 >= 0.0f ? 1 : -1));
    }

    public static double nextDown(double d2) {
        if (FpUtils.isNaN(d2) || d2 == Double.NEGATIVE_INFINITY) {
            return d2;
        }
        if (d2 == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2) + (d2 > 0.0 ? -1L : 1L));
    }

    public static double nextDown(float f2) {
        if (FpUtils.isNaN(f2) || f2 == Float.NEGATIVE_INFINITY) {
            return f2;
        }
        if (f2 == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2) + (f2 > 0.0f ? -1 : 1));
    }

    public static double copySign(double d2, double d3) {
        return FpUtils.rawCopySign(d2, FpUtils.isNaN(d3) ? 1.0 : d3);
    }

    public static float copySign(float f2, float f3) {
        return FpUtils.rawCopySign(f2, FpUtils.isNaN(f3) ? 1.0f : f3);
    }

    public static double ulp(double d2) {
        int n2 = FpUtils.getExponent(d2);
        switch (n2) {
            case 1024: {
                return Math.abs(d2);
            }
            case -1023: {
                return Double.MIN_VALUE;
            }
        }
        if ((n2 -= 52) >= -1022) {
            return FpUtils.powerOfTwoD(n2);
        }
        return Double.longBitsToDouble(1L << n2 - -1074);
    }

    public static float ulp(float f2) {
        int n2 = FpUtils.getExponent(f2);
        switch (n2) {
            case 128: {
                return Math.abs(f2);
            }
            case -127: {
                return Float.MIN_VALUE;
            }
        }
        if ((n2 -= 23) >= -126) {
            return FpUtils.powerOfTwoF(n2);
        }
        return Float.intBitsToFloat(1 << n2 - -149);
    }

    public static double signum(double d2) {
        return d2 == 0.0 || FpUtils.isNaN(d2) ? d2 : FpUtils.copySign(1.0, d2);
    }

    public static float signum(float f2) {
        return f2 == 0.0f || FpUtils.isNaN(f2) ? f2 : FpUtils.copySign(1.0f, f2);
    }
}

