/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteDeclare;
import com.fr.general.ExportDeclare;
import com.fr.general.FRLogger;
import com.fr.general.LogDeclare;
import com.fr.general.LogDeclareException;
import com.fr.general.LogDuration;
import com.fr.general.LogPackedException;
import com.fr.general.ResourceReadDeclare;
import com.fr.general.ResourceWriteDeclare;
import com.fr.general.WebWriteDeclare;
import com.fr.performance.PerformanceManager;
import java.util.LinkedList;
import java.util.Map;

public class FRLogManager {
    private static final ThreadLocal DECLARES = new ThreadLocal();
    private static final ThreadLocal SESSION_FOR_LOG_EXE = new ThreadLocal();

    public static LogDuration getSession() {
        LogDuration logDuration = (LogDuration)SESSION_FOR_LOG_EXE.get();
        return logDuration;
    }

    public static void setSession(LogDuration logDuration) {
        PerformanceManager.bindSessionInfo(logDuration);
        SESSION_FOR_LOG_EXE.set(logDuration);
    }

    public static void releaseSession() {
        PerformanceManager.releaseSessionInfo();
        SESSION_FOR_LOG_EXE.set(null);
        DECLARES.set(null);
    }

    public static LogPackedException createLogPackedException(Exception exception) {
        if (exception == null) {
            return null;
        }
        return new LogPackedException(exception, FRLogManager.getCurrentDeclare(), FRLogManager.getSession());
    }

    public static void declareExecuteStart(String string, String string2, DeclareRecordType declareRecordType) {
        LinkedList linkedList = FRLogManager.getDeclareList();
        ExecuteDeclare executeDeclare = new ExecuteDeclare(string, string2, declareRecordType);
        linkedList.addFirst(executeDeclare);
    }

    public static void declareSQLEnd(String string) {
        LogDeclare logDeclare = FRLogManager.getCurrentDeclare();
        if (logDeclare != null) {
            logDeclare.appendSqlInfo(string);
        }
    }

    public static String getDeclareSQLContent() {
        LogDeclare logDeclare = FRLogManager.getCurrentDeclare();
        return logDeclare == null ? "" : logDeclare.getSqlInfo();
    }

    public static LinkedList getDeclareList() {
        LinkedList linkedList = (LinkedList)DECLARES.get();
        if (linkedList == null) {
            linkedList = new LinkedList();
            DECLARES.set(linkedList);
        }
        return linkedList;
    }

    public static void setDeclareList(LinkedList linkedList) {
        DECLARES.set(linkedList);
    }

    public static void declareExecuteEnd() {
        FRLogManager.declareEnd((short)0);
    }

    public static void declareExportStart(String string, String string2, DeclareRecordType declareRecordType) {
        LinkedList linkedList = FRLogManager.getDeclareList();
        ExportDeclare exportDeclare = new ExportDeclare(string, string2, declareRecordType);
        linkedList.addFirst(exportDeclare);
    }

    public static void declareExportEnd() {
        FRLogManager.declareEnd((short)1);
    }

    public static void declareWebWriteStart(String string, Map map, DeclareRecordType declareRecordType) {
        LinkedList linkedList = FRLogManager.getDeclareList();
        WebWriteDeclare webWriteDeclare = new WebWriteDeclare(string, FRLogger.createParamString(map), declareRecordType);
        linkedList.addFirst(webWriteDeclare);
    }

    public static void declareWebWriteEnd() {
        FRLogManager.declareEnd((short)3);
    }

    public static void declareResourceReadStart(String string) {
        LinkedList linkedList = FRLogManager.getDeclareList();
        ResourceReadDeclare resourceReadDeclare = new ResourceReadDeclare(string);
        linkedList.addFirst(resourceReadDeclare);
    }

    public static void declareResourceReadEnd() {
        FRLogManager.declareEnd((short)4);
    }

    public static void declareResourceWriteStart(String string) {
        LinkedList linkedList = FRLogManager.getDeclareList();
        ResourceWriteDeclare resourceWriteDeclare = new ResourceWriteDeclare(string);
        linkedList.addFirst(resourceWriteDeclare);
    }

    public static void declareResourceWriteEnd() {
        FRLogManager.declareEnd((short)5);
    }

    public static LogDeclare getCurrentDeclare() {
        LinkedList linkedList = (LinkedList)DECLARES.get();
        return linkedList != null && linkedList.size() > 0 ? (LogDeclare)linkedList.getFirst() : null;
    }

    private static void declareEnd(short s2) {
        LinkedList linkedList = FRLogManager.getDeclareList();
        if (linkedList.size() > 0) {
            LogDeclare logDeclare = (LogDeclare)linkedList.removeFirst();
            if (logDeclare.getDeclareType() != s2) {
                throw new LogDeclareException("Current Declare Type is not " + FRLogManager.getDeclareName(s2) + ", but " + FRLogManager.getDeclareName(logDeclare.getDeclareType()));
            }
            if (linkedList.size() == 0) {
                DECLARES.set(null);
            }
        } else {
            throw new LogDeclareException("Current Declare Type is not " + FRLogManager.getDeclareName(s2));
        }
    }

    private static String getDeclareName(short s2) {
        switch (s2) {
            case 0: {
                return "EXECUTE";
            }
            case 1: {
                return "EXPORT";
            }
            case 2: {
                return "PRINT";
            }
            case 3: {
                return "WEB WRITE";
            }
            case 4: {
                return "RESOURCE READ";
            }
            case 5: {
                return "RESOURCE WRITE";
            }
        }
        return "OTHER";
    }
}

