/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.widget;

import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.container.WParameterLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRBoundsWidget
extends Widget
implements Comparable {
    private Widget widget;
    private Rectangle bounds;
    private Rectangle backupBounds;
    private Rectangle beforeScaleBounds;

    public Rectangle getBeforeScaleBounds() {
        return this.beforeScaleBounds;
    }

    public void setBeforeScaleBounds(Rectangle rectangle) {
        this.beforeScaleBounds = rectangle;
    }

    public CRBoundsWidget() {
    }

    public CRBoundsWidget(Widget widget, Rectangle rectangle) {
        this.widget = widget;
        this.bounds = rectangle;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public Rectangle getBackupBounds() {
        return this.backupBounds;
    }

    public void setBackupBounds(Rectangle rectangle) {
        this.backupBounds = rectangle;
    }

    public Widget getWidget() {
        return this.widget;
    }

    @Override
    public String getWidgetName() {
        return this.widget.getWidgetName();
    }

    @Override
    public String getXType() {
        return this.widget == null ? null : this.widget.getXType();
    }

    @Override
    public boolean acceptType(Class<?> ... classArray) {
        return this.widget.acceptType(classArray);
    }

    @Override
    public boolean isEditor() {
        return this.widget.isEditor();
    }

    @Override
    public String[] supportedEvents() {
        return this.widget.supportedEvents();
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        return this.widget.acceptType(WParameterLayout.class) ? JSONObject.EMPTY : this.createJSON(repository, calculator, nodeVisitor);
    }

    private JSONObject createJSON(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = this.widget.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("x", this.bounds.x);
        jSONObject.put("y", this.bounds.y);
        jSONObject.put("width", this.bounds.width);
        jSONObject.put("height", this.bounds.height);
        return jSONObject;
    }

    @Override
    public void toImage(Calculator calculator, Rectangle rectangle, Graphics graphics) {
        this.widget.toImage(calculator, this.bounds, graphics);
    }

    @Override
    public void resize(double d2, double d3, double d4) {
        int n2 = (int)((double)this.bounds.width * d2);
        int n3 = (int)((double)this.bounds.height * d3);
        int n4 = (int)((double)this.bounds.x * d2);
        int n5 = (int)((double)this.bounds.y * d3);
        this.bounds.setBounds(n4, n5, n2, n3);
        this.getWidget().resize(n2, n3, d4);
    }

    public int compareTo(Object object) {
        CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)object;
        if (cRBoundsWidget.bounds.y < this.bounds.y) {
            return 1;
        }
        if (cRBoundsWidget.bounds.y == this.bounds.y && cRBoundsWidget.bounds.x < this.bounds.x) {
            return 1;
        }
        if (cRBoundsWidget.bounds.y == this.bounds.y && cRBoundsWidget.bounds.x == this.bounds.x) {
            return 0;
        }
        return -1;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("InnerWidget".equals(string)) {
                this.widget = WidgetXmlUtils.readWidget(xMLableReader);
            } else if ("BoundsAttr".equals(string)) {
                this.bounds = new Rectangle(xMLableReader.getAttrAsInt("x", 0), xMLableReader.getAttrAsInt("y", 0), xMLableReader.getAttrAsInt("width", 0), xMLableReader.getAttrAsInt("height", 0));
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.widget != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.widget, "InnerWidget");
        }
        if (this.bounds != null) {
            xMLPrintWriter.startTAG("BoundsAttr").attr("x", this.bounds.x).attr("y", this.bounds.y).attr("width", this.bounds.width).attr("height", this.bounds.height).end();
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CRBoundsWidget && ComparatorUtils.equals(((CRBoundsWidget)object).widget, this.widget);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)super.clone();
        if (this.widget != null) {
            cRBoundsWidget.widget = (Widget)this.widget.clone();
        }
        if (this.bounds != null) {
            cRBoundsWidget.bounds = (Rectangle)this.bounds.clone();
        }
        return cRBoundsWidget;
    }
}

