/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.base.BaseXMLUtils;
import com.fr.base.DynamicNumberList;
import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;

public class WHorizontalBoxLayout
extends WLayout {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HGAP = 0;
    public static final int DEFAULT_VGAP = 0;
    private int alignment;
    private DynamicNumberList widgetsWidthList_DEC;

    public WHorizontalBoxLayout() {
        this(1);
    }

    public WHorizontalBoxLayout(int n2) {
        this(n2, 0, 0);
    }

    public WHorizontalBoxLayout(int n2, int n3, int n4) {
        this.setAlignment(n2);
        this.setHgap(n3);
        this.setVgap(n4);
        this.widgetsWidthList_DEC = new DynamicNumberList(80);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public String getXType() {
        return "horizontal";
    }

    public void addWidget(Widget widget) {
        this.addWidget(widget, -1);
    }

    public void addWidget(Widget widget, int n2) {
        if (n2 > -1 && n2 < this.widgetList.size()) {
            this.widgetList.add(n2, widget);
            this.widgetsWidthList_DEC.insert(n2);
        } else {
            this.widgetList.add(widget);
        }
    }

    public void addWidthWidget(Widget widget, int n2) {
        this.addWidget(widget);
        this.widgetsWidthList_DEC.set(this.widgetList.size() - 1, n2);
    }

    public void removeWidget(Widget widget) {
        int n2 = this.getWidgetIndex(widget);
        super.removeWidget(widget);
        this.widgetsWidthList_DEC.remove(n2);
    }

    public int getWidthAtWidget(Widget widget) {
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(widget, this.getWidget(i2))) continue;
            return this.widgetsWidthList_DEC.get(i2);
        }
        return 80;
    }

    public void setWidthAtWidget(Widget widget, int n2) {
        int n3 = this.getWidgetCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!ComparatorUtils.equals(widget, this.getWidget(i2))) continue;
            this.widgetsWidthList_DEC.set(i2, n2);
            break;
        }
    }

    protected void setWidthAtIndex(int n2, int n3) {
        this.widgetsWidthList_DEC.set(n2, n3);
    }

    private String asAlignString(int n2) {
        switch (n2) {
            case 0: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        return "center";
    }

    public String getLayoutToolTip() {
        return Inter.getLocText("FR-Designer_WLayout-Horizontail-ToolTips");
    }

    public Dimension getMinDesignSize() {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidgetCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            Widget widget = this.getWidget(i2);
            if (!widget.isVisible()) continue;
            n2 += this.widgetsWidthList_DEC.get(i2);
            if (!(widget instanceof WLayout) || (n5 = ((WLayout)widget).getMinDesignSize().height) <= n3) continue;
            n3 = n5;
        }
        return new Dimension(n2, n3);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("alignment", this.asAlignString(this.alignment));
        return jSONObject;
    }

    protected JSONArray createJSONItems(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n2 = this.widgetList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Widget widget = (Widget)this.widgetList.get(i2);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("width", this.getWidthAtWidget(widget));
            jSONObject.put("el", widget.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("FLAttr")) {
                this.alignment = xMLableReader.getAttrAsInt("alignment", 0);
            } else if (ComparatorUtils.equals(string, "ColumnWidth")) {
                this.widgetsWidthList_DEC = BaseXMLUtils.readDynamicNumberList(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("FLAttr").attr("alignment", this.alignment).end();
        xMLPrintWriter.startTAG("ColumnWidth");
        BaseXMLUtils.writeDynamicNumberList(xMLPrintWriter, this.widgetsWidthList_DEC);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        WHorizontalBoxLayout wHorizontalBoxLayout = (WHorizontalBoxLayout)super.clone();
        wHorizontalBoxLayout.widgetsWidthList_DEC = (DynamicNumberList)this.widgetsWidthList_DEC.clone();
        return wHorizontalBoxLayout;
    }
}

