/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.Style;
import com.fr.form.event.Observer;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.finegrain.WidgetPrivilegeControl;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.fun.WidgetSwitcher;
import com.fr.stable.plugin.PluginReadListener;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Widget
extends Observer
implements XMLable,
Serializable {
    public static int DEFAULT_FONT_SIZE = 12;
    public static final String EVENT_CLICK = "click";
    public static final String AFTERINIT = "afterinit";
    public static final String BEFOREEDIT = "beforeedit";
    public static final String AFTEREDIT = "afteredit";
    public static final String CHANGE = "change";
    public static final String STOPEDIT = "stopedit";
    public static final String EVENT_STATECHANGE = "statechange";
    public static final String XML_TAG = "Widget";
    private static WidgetSwitcher flatWidgetsSwitcher;
    protected boolean disabled;
    protected boolean invisible;
    protected String widgetName;
    private WidgetPrivilegeControl widgetPrivilegeControl;
    private boolean isChartRelated = false;
    private String description = "";

    public abstract String getXType();

    public abstract boolean isEditor();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getWidgetName() {
        return this.widgetName == null ? "" : this.widgetName;
    }

    public void setWidgetName(String string) {
        this.widgetName = string;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setEnabled(boolean bl) {
        this.disabled = !bl;
    }

    public boolean isVisible() {
        return !this.invisible;
    }

    public boolean hasDataOnInit() {
        return false;
    }

    public void setVisible(boolean bl) {
        this.invisible = !bl;
    }

    public void dealInvisible() throws Exception {
    }

    public boolean isDirtyWidget(String string) {
        if (this.isVisible() && this.isEnabled()) {
            return this.isDoneVisibleAuthority(string) || this.isDoneUsableAuthority(string);
        }
        return this.isVisibleAuthority(string) || this.isUsableAuthority(string);
    }

    public boolean isVisibleAuthority(String string) {
        if (string == null) {
            return true;
        }
        return this.getWidgetPrivilegeControl().checkVisiable(string);
    }

    public boolean isUsableAuthority(String string) {
        if (string == null) {
            return true;
        }
        return this.getWidgetPrivilegeControl().checkUsable(string);
    }

    public boolean isDoneVisibleAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getWidgetPrivilegeControl().checkInvisible(string);
    }

    public boolean isDoneUsableAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getWidgetPrivilegeControl().checkUnusable(string);
    }

    public void changeVisibleAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        WidgetPrivilegeControl widgetPrivilegeControl = this.getWidgetPrivilegeControl();
        if (this.isVisible()) {
            this.changeVisibiltyWhenWidgetVisible(string, bl, widgetPrivilegeControl);
        } else {
            this.changeVisibiltyWhenWidgetInvisible(string, bl, widgetPrivilegeControl);
        }
    }

    private void changeVisibiltyWhenWidgetInvisible(String string, boolean bl, WidgetPrivilegeControl widgetPrivilegeControl) {
        if (bl) {
            widgetPrivilegeControl.addVisiableRole(string);
        } else {
            widgetPrivilegeControl.removeVisiableRole(string);
        }
    }

    private void changeVisibiltyWhenWidgetVisible(String string, boolean bl, WidgetPrivilegeControl widgetPrivilegeControl) {
        if (bl) {
            widgetPrivilegeControl.removeInvisibleRole(string);
        } else {
            widgetPrivilegeControl.addInvisibleRole(string);
            widgetPrivilegeControl.addUnusableRole(string);
        }
    }

    public void changeOnlyVisibleAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getWidgetPrivilegeControl().removeInvisibleRole(string);
        } else {
            this.getWidgetPrivilegeControl().addInvisibleRole(string);
        }
    }

    public void changeUsableAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        WidgetPrivilegeControl widgetPrivilegeControl = this.getWidgetPrivilegeControl();
        if (this.isEnabled()) {
            this.changeUsabiltyWhenWidgetEnabled(string, bl, widgetPrivilegeControl);
        } else {
            this.changeUsabiltyWhenWidgetDisabled(string, bl, widgetPrivilegeControl);
        }
    }

    private void changeUsabiltyWhenWidgetDisabled(String string, boolean bl, WidgetPrivilegeControl widgetPrivilegeControl) {
        if (bl) {
            widgetPrivilegeControl.addUsableRole(string);
        } else {
            widgetPrivilegeControl.removeUsableRole(string);
        }
    }

    private void changeUsabiltyWhenWidgetEnabled(String string, boolean bl, WidgetPrivilegeControl widgetPrivilegeControl) {
        if (bl) {
            widgetPrivilegeControl.removeUnusableRole(string);
        } else {
            widgetPrivilegeControl.addUnusableRole(string);
        }
    }

    public void cleanAuthority(String string) {
        if (string == null) {
            return;
        }
        WidgetPrivilegeControl widgetPrivilegeControl = this.getWidgetPrivilegeControl();
        if (widgetPrivilegeControl.checkInvisible(string)) {
            widgetPrivilegeControl.removeInvisibleRole(string);
        }
        if (widgetPrivilegeControl.checkUnusable(string)) {
            widgetPrivilegeControl.removeUnusableRole(string);
        }
        if (widgetPrivilegeControl.checkVisiable(string)) {
            widgetPrivilegeControl.removeVisiableRole(string);
        }
        if (widgetPrivilegeControl.checkUsable(string)) {
            widgetPrivilegeControl.removeUsableRole(string);
        }
    }

    public void setChartRelated(boolean bl) {
        this.isChartRelated = bl;
    }

    public boolean isChartRelated() {
        return this.isChartRelated;
    }

    public boolean acceptType(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            if (!StableUtils.objectInstanceOf(this, clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean supportMobile() {
        return true;
    }

    public void updateChildBounds(Rectangle rectangle) {
    }

    public WidgetPrivilegeControl getWidgetPrivilegeControl() {
        if (this.widgetPrivilegeControl == null) {
            this.widgetPrivilegeControl = new WidgetPrivilegeControl();
        }
        return this.widgetPrivilegeControl;
    }

    public void setWidgetPrivilegeControl(WidgetPrivilegeControl widgetPrivilegeControl) {
        this.widgetPrivilegeControl = widgetPrivilegeControl;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Widget widget = (Widget)super.clone();
        if (this.widgetPrivilegeControl != null && !this.widgetPrivilegeControl.isEmpty()) {
            widget.setWidgetPrivilegeControl((WidgetPrivilegeControl)this.widgetPrivilegeControl.clone());
        } else {
            widget.setWidgetPrivilegeControl(null);
        }
        return widget;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        Serializable serializable;
        JSONObject jSONObject = new JSONObject();
        String string = this.getXType();
        if (flatWidgetsSwitcher != null) {
            string = flatWidgetsSwitcher.toNewMarkType(string, repository);
        }
        jSONObject.put("type", string);
        if (this.widgetName != null) {
            jSONObject.put("widgetName", this.widgetName.toUpperCase());
        }
        this.createVisablityJson(jSONObject, calculator);
        if (this instanceof DataControl) {
            jSONObject.put("needSubmit", true);
            serializable = ((DataControl)((Object)this)).getWidgetValue();
            if (serializable != null) {
                ((WidgetValue)serializable).createJSONConfig(jSONObject, calculator);
            }
        }
        if (!repository.getDevice().isMobile()) {
            jSONObject.put("widgetUrl", repository.checkoutObject(this.widgetName, "widget"));
        }
        if (((JSONArray)(serializable = this.createJSONListener(repository))).length() > 0) {
            jSONObject.put("listeners", serializable);
        }
        return jSONObject;
    }

    private void createVisablityJson(JSONObject jSONObject, Calculator calculator) throws JSONException {
        Object[] objectArray = PrivilegeManager.getRoleFromCalculator(calculator);
        boolean bl = this.invisible;
        boolean bl2 = this.disabled;
        if (ArrayUtils.isNotEmpty(objectArray)) {
            WidgetPrivilegeControl widgetPrivilegeControl = this.getWidgetPrivilegeControl();
            bl = widgetPrivilegeControl.isInvisible(this.isVisible(), (String[])objectArray);
            bl2 = widgetPrivilegeControl.isDisable(this.isEnabled(), (String[])objectArray);
        }
        jSONObject.put("disabled", bl2);
        jSONObject.put("invisible", bl);
    }

    public void toImage(Calculator calculator, Rectangle rectangle, Graphics graphics) {
    }

    public BufferedImage toImage(Object object, int n2, int n3, Style style) {
        return null;
    }

    public Object value2Config(Object object, CalculatorProvider calculatorProvider) {
        return object;
    }

    public static String getEnableAction() {
        return "this.setEnable(true);";
    }

    public static String getDisableAction() {
        return "this.setEnable(false);";
    }

    public static String getVisibleAction() {
        return "this.setVisible(true)";
    }

    public static String getInvisibleAction() {
        return "this.setVisible(false)";
    }

    public int getContentWidth() {
        return 0;
    }

    public int getContentHeight() {
        return 0;
    }

    public void resize(double d2, double d3) {
        this.resize(d2, d3, 1.0);
    }

    public void resize(double d2, double d3, double d4) {
    }

    public Object dealWithPresentableValue(String string) throws Exception {
        return string;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        block2: {
            String string;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                super.readXML(xMLableReader);
                                if (!xMLableReader.isChildNode()) break block2;
                                string = xMLableReader.getTagName();
                                if (!string.equals("Disable")) break block3;
                                this.disabled = Boolean.valueOf(xMLableReader.getElementValue());
                                break block2;
                            }
                            if (!string.equals("WidgetName")) break block4;
                            this.setWidgetName(xMLableReader.getAttrAsString("name", null));
                            break block2;
                        }
                        if (!string.equals("WidgetAttr")) break block5;
                        this.disabled = xMLableReader.getAttrAsBoolean("disabled", false);
                        this.invisible = xMLableReader.getAttrAsBoolean("invisible", false);
                        this.description = xMLableReader.getAttrAsString("description", "");
                        break block2;
                    }
                    if (!string.equals("PrivilegeControl")) break block6;
                    WidgetPrivilegeControl widgetPrivilegeControl = new WidgetPrivilegeControl();
                    xMLableReader.readXMLObject(widgetPrivilegeControl);
                    this.setWidgetPrivilegeControl(widgetPrivilegeControl);
                    break block2;
                }
                if (!string.equals("PrivilegeInvisible")) break block7;
                String[] stringArray = xMLableReader.getAttrAsString("privilegeInvisibleSet", "").split(",");
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.getWidgetPrivilegeControl().addInvisibleRole(stringArray[i2]);
                }
                break block2;
            }
            if (!string.equals("PrivilegeUnusable")) break block2;
            String[] stringArray = xMLableReader.getAttrAsString("privilegeUnusableSet", "").split(",");
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.getWidgetPrivilegeControl().addUnusableRole(stringArray[i3]);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.widgetName)) {
            xMLPrintWriter.startTAG("WidgetName").attr("name", this.widgetName).end();
        }
        xMLPrintWriter.startTAG("WidgetAttr");
        if (this.disabled) {
            xMLPrintWriter.attr("disabled", this.disabled);
        }
        if (this.invisible) {
            xMLPrintWriter.attr("invisible", this.invisible);
        }
        xMLPrintWriter.attr("description", this.description);
        WidgetPrivilegeControl widgetPrivilegeControl = this.getWidgetPrivilegeControl();
        if (widgetPrivilegeControl != null) {
            widgetPrivilegeControl.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 89 * n2 + (this.disabled ? 1 : 0);
        n2 = 89 * n2 + (this.invisible ? 1 : 0);
        n2 = 89 * n2 + (this.widgetName != null ? this.widgetName.hashCode() : 0);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Widget && super.equals(object) && ComparatorUtils.equals(((Widget)object).widgetName, this.widgetName) && this.disabled == ((Widget)object).disabled && this.invisible == ((Widget)object).invisible && ComparatorUtils.equals(this.description, ((Widget)object).description);
    }

    static {
        GeneralContext.addPluginReadListener(new PluginReadListener(){

            public void success(PluginReadListener.Status status) {
                flatWidgetsSwitcher = (WidgetSwitcher)ExtraClassManager.getInstance().getSingle("WidgetSwitcher");
                if (flatWidgetsSwitcher == null) {
                    flatWidgetsSwitcher = StableFactory.getMarkedObject("WidgetSwitcher", WidgetSwitcher.class);
                }
            }
        });
    }
}

