/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.WriteUnableRepeatEditor;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class ListEditor
extends WriteUnableRepeatEditor {
    public static final String XML_TAG = "List";
    private boolean needHead;
    private Color selectionBG;
    private Color selectionFG;

    public String getXType() {
        return "list";
    }

    public boolean isEditor() {
        return false;
    }

    public Color getSelectionBackground() {
        return this.selectionBG;
    }

    public int[] getValueType() {
        return new int[]{1, 2, 3};
    }

    public void setSelectionBackground(Color color) {
        this.selectionBG = color;
    }

    public Color getSelectionForeground() {
        return this.selectionFG;
    }

    public void setSelectionForeground(Color color) {
        this.selectionFG = color;
    }

    public boolean isNeedHead() {
        return this.needHead;
    }

    public void setNeedHead(boolean bl) {
        this.needHead = bl;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "click"};
    }

    public boolean supportMobile() {
        return false;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (this.needHead) {
            jSONObject.put("needHead", this.needHead);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.needHead = xMLableReader.getAttrAsBoolean("needHead", false);
            } else if (string.equals("selectionBG")) {
                String string2 = xMLableReader.getAttrAsString("background", null);
                if (string2 != null) {
                    this.setSelectionBackground(new Color(Integer.parseInt(string2), true));
                } else {
                    this.setSelectionBackground(null);
                }
            } else if (string.equals("selectionFG")) {
                String string3 = xMLableReader.getAttrAsString("foreground", null);
                if (string3 != null) {
                    this.setSelectionForeground(new Color(Integer.parseInt(string3), true));
                } else {
                    this.setSelectionForeground(null);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.needHead) {
            xMLPrintWriter.startTAG(XML_TAG).attr("needHead", this.needHead).end();
        }
        if (this.selectionBG != null) {
            xMLPrintWriter.startTAG("selectionBG").attr("background", this.selectionBG.getRGB()).end();
        }
        if (this.selectionFG != null) {
            xMLPrintWriter.startTAG("selectionFG").attr("foreground", this.selectionFG.getRGB()).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof ListEditor && super.equals(object) && ((ListEditor)object).needHead == this.needHead && ComparatorUtils.equals(((ListEditor)object).selectionBG, this.selectionBG) && ComparatorUtils.equals(((ListEditor)object).selectionFG, this.selectionFG);
    }
}

