/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.ResizableElement;
import com.fr.base.mobile.ElementCaseMobileAttrProvider;
import com.fr.base.mobile.MobileFitAttrState;
import com.fr.form.FormElementCaseProvider;
import com.fr.form.ui.AbstractBorderStyleWidget;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.ElementCaseEditorProvider;
import com.fr.form.ui.FormHyperlinkEditor;
import com.fr.form.ui.PaddingMargin;
import com.fr.form.web.FormToolBarManager;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.fun.ReportFitProcessor;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.DependenceProvider;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.fun.ExtraAttrMapProvider;
import com.fr.stable.fun.IOFileAttrMark;
import com.fr.stable.fun.ReportFitAttrProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCaseEditor
extends AbstractBorderStyleWidget
implements FormHyperlinkEditor,
DependenceProvider,
ElementCaseEditorProvider,
ResizableElement {
    private static final int DEFAULT_PC = 1;
    private static final double DEFAULT_APP = 0.75;
    private static final double MAX_HEIGHT = 0.8;
    private double editorWidth;
    private double editorHeight;
    private double heightPercent;
    private FormElementCaseProvider elementcase;
    private FormToolBarManager[] toolBars = new FormToolBarManager[0];
    private boolean heightRestrict = false;
    private ReportFitAttrProvider reportFitAttr;
    private ElementCaseMobileAttrProvider mobileAttr;
    private static Map<String, IOFileAttrMark> extraAttrMarkMap = new HashMap<String, IOFileAttrMark>();
    private boolean isShared = false;
    private int reportFitInPc = 1;
    private Map<String, IOFileAttrMark> attrMarkMap;

    public ExtraAttrMapProvider getMapProvider() {
        Iterator<Map.Entry<String, IOFileAttrMark>> iterator;
        if (this.attrMarkMap != null && (iterator = this.attrMarkMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, IOFileAttrMark> entry = iterator.next();
            ExtraAttrMapProvider extraAttrMapProvider = (ExtraAttrMapProvider)this.getAttrMark(entry.getKey());
            return extraAttrMapProvider;
        }
        return null;
    }

    public boolean isShowRefresh() {
        if (this.attrMarkMap != null) {
            Set set = ExtraClassManager.getInstance().getArray("ExtraAttrMapProvider");
            for (ExtraAttrMapProvider extraAttrMapProvider : set) {
                if (extraAttrMapProvider == null) continue;
                extraAttrMapProvider = this.getMapProvider();
                return extraAttrMapProvider.isShowExtraAttr(this.attrMarkMap);
            }
        }
        return false;
    }

    public void setShowRefresh(boolean bl) {
        Set set = ExtraClassManager.getInstance().getArray("ExtraAttrMapProvider");
        for (ExtraAttrMapProvider extraAttrMapProvider : set) {
            if (extraAttrMapProvider == null) continue;
            if (this.attrMarkMap == null) {
                this.addAttrMark((IOFileAttrMark)((Object)extraAttrMapProvider));
            }
            extraAttrMapProvider = this.getMapProvider();
            extraAttrMapProvider.setShowExtraAttr(bl);
        }
    }

    public double getShowRefreshRrequency() {
        if (this.attrMarkMap != null) {
            Set set = ExtraClassManager.getInstance().getArray("ExtraAttrMapProvider");
            for (ExtraAttrMapProvider extraAttrMapProvider : set) {
                if (extraAttrMapProvider == null) continue;
                extraAttrMapProvider = this.getMapProvider();
                return extraAttrMapProvider.getAttrValue(this.attrMarkMap);
            }
        }
        return 0.0;
    }

    public void setShowRefreshRrequency(double d2) {
        if (this.attrMarkMap != null) {
            Set set = ExtraClassManager.getInstance().getArray("ExtraAttrMapProvider");
            for (ExtraAttrMapProvider extraAttrMapProvider : set) {
                if (extraAttrMapProvider == null) continue;
                extraAttrMapProvider = this.getMapProvider();
                extraAttrMapProvider.setAttrValue(d2);
            }
        }
    }

    public ElementCaseEditor() {
        this.elementcase = StableFactory.getMarkedInstanceObjectFromClass("FormElementCase", FormElementCaseProvider.class);
        this.mobileAttr = StableFactory.getMarkedInstanceObjectFromClass("ElementCaseMobileAttrProvider", ElementCaseMobileAttrProvider.class);
    }

    public MobileFitAttrState getHorziontalAttr() {
        return this.mobileAttr.getHorziontalAttr();
    }

    public void setHorziontalAttr(MobileFitAttrState mobileFitAttrState) {
        this.mobileAttr.setHorziontalAttr(mobileFitAttrState);
    }

    public MobileFitAttrState getVerticalAttr() {
        return this.mobileAttr.getVerticalAttr();
    }

    public void setVerticalAttr(MobileFitAttrState mobileFitAttrState) {
        this.mobileAttr.setVerticalAttr(mobileFitAttrState);
    }

    @Override
    public String getXType() {
        return "elementcase";
    }

    public boolean isHeightRestrict() {
        return this.heightRestrict;
    }

    public double getHeightPercent() {
        if (this.heightPercent == 0.0) {
            return 0.75;
        }
        return this.heightPercent;
    }

    public FormToolBarManager[] getToolBars() {
        return this.toolBars;
    }

    public void setToolBars(FormToolBarManager[] formToolBarManagerArray) {
        this.toolBars = formToolBarManagerArray;
    }

    public void setHeightRestrict(boolean bl) {
        this.heightRestrict = bl;
    }

    public void setHeightPercent(double d2) {
        if (d2 > 0.8) {
            d2 = 0.8;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.heightPercent = d2;
    }

    public void setReportFitInPc(int n2) {
        this.reportFitInPc = n2;
    }

    public int getFitStateInPC() {
        if (this.reportFitAttr != null) {
            return this.reportFitAttr.fitStateInPC();
        }
        return this.reportFitInPc;
    }

    public void setReportFitAttr(ReportFitAttrProvider reportFitAttrProvider) {
        this.reportFitAttr = reportFitAttrProvider;
    }

    @Override
    public ReportFitAttrProvider getReportFitAttr() {
        return this.reportFitAttr;
    }

    public void setFitStateInPC(int n2) {
        ReportFitProcessor reportFitProcessor;
        if (this.reportFitAttr == null && (reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor")) != null) {
            this.reportFitAttr = reportFitProcessor.newInstanceFitAttr();
        }
        this.reportFitAttr.setFitStateInPC(n2);
    }

    @Override
    public boolean isEditor() {
        return false;
    }

    @Override
    public String[] supportedEvents() {
        return new String[]{"click"};
    }

    @Override
    public FormElementCaseProvider getElementCase() {
        return this.elementcase;
    }

    public void setElementCase(FormElementCaseProvider formElementCaseProvider) {
        this.elementcase = formElementCaseProvider;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean bl) {
        this.isShared = bl;
    }

    @Override
    public void resize(double d2, double d3, double d4) {
        int n2 = GraphHelper.getLineStyleSize(this.getBorderStyle().getBorder());
        PaddingMargin paddingMargin = this.getMargin();
        int n3 = paddingMargin.getLeft() + paddingMargin.getRight();
        int n4 = paddingMargin.getTop() + paddingMargin.getBottom();
        FormToolBarManager[] formToolBarManagerArray = this.getToolBars();
        this.editorWidth = d2 - (double)(n2 * 2) - (double)n3;
        this.editorHeight = d3 - (double)(n2 * 2) - (double)n4 - (double)(formToolBarManagerArray.length * 28);
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor != null) {
            reportFitProcessor.scaleFontSize(d4, this.elementcase);
        }
    }

    @Override
    public int getContentHeight() {
        return (int)this.editorHeight;
    }

    @Override
    public int getContentWidth() {
        return (int)this.editorWidth - (this.margin.getLeft() + this.margin.getRight());
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("FormElementCase")) {
                FormElementCaseProvider formElementCaseProvider = StableFactory.getMarkedInstanceObjectFromClass("FormElementCase", FormElementCaseProvider.class);
                xMLableReader.readXMLObject(formElementCaseProvider);
                this.elementcase = formElementCaseProvider;
            } else if ("StyleList".equals(string)) {
                this.elementcase.readStyleXML(xMLableReader);
            } else if (string.equals("showToolbar") && xMLableReader.getAttrAsBoolean("showtoolbar", true)) {
                this.toolBars = new FormToolBarManager[]{FormToolBarManager.createDefaultNorthToolBar()};
            } else if (string.equals("toolBars")) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("FormToolBarManager")) {
                            FormToolBarManager formToolBarManager = new FormToolBarManager();
                            xMLableReader.readXMLObject(formToolBarManager);
                            arrayList.add(formToolBarManager);
                        }
                    }
                });
                this.toolBars = arrayList.toArray(new FormToolBarManager[arrayList.size()]);
            } else if (string.equals("heightRestrict")) {
                this.setHeightRestrict(xMLableReader.getAttrAsBoolean("heightrestrict", true));
            } else if (string.equals("heightPercent")) {
                this.setHeightPercent(xMLableReader.getAttrAsDouble("heightpercent", 0.75));
            } else if (string.equals("ReportFitAttr")) {
                this.readFitAttr(xMLableReader);
                this.compatiableOldXml(xMLableReader);
            } else if (string.equals("ElementCaseMobileAttrProvider")) {
                this.mobileAttr.readXML(xMLableReader);
            } else if (extraAttrMarkMap.containsKey(string)) {
                IOFileAttrMark iOFileAttrMark = extraAttrMarkMap.get(string).clone();
                xMLableReader.readXMLObject(iOFileAttrMark);
                this.addAttrMark(iOFileAttrMark);
            } else if (string.equals("isShared")) {
                this.setShared(xMLableReader.getAttrAsBoolean("isshared", false));
            }
        }
    }

    private void compatiableOldXml(XMLableReader xMLableReader) {
        int n2 = xMLableReader.getAttrAsInt("fitHorizontalInApp", -1);
        int n3 = xMLableReader.getAttrAsInt("fitVerticalInApp", -1);
        if (n2 != -1 || n3 != -1) {
            this.setHorziontalAttr(MobileFitAttrState.parse(n2));
            this.setVerticalAttr(MobileFitAttrState.parse(n3));
        }
    }

    private void readFitAttr(XMLableReader xMLableReader) {
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor == null) {
            return;
        }
        ReportFitAttrProvider reportFitAttrProvider = reportFitProcessor.newInstanceFitAttr();
        reportFitAttrProvider.readXML(xMLableReader);
        this.reportFitAttr = reportFitAttrProvider;
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.elementcase != null) {
            xMLPrintWriter.startTAG("FormElementCase");
            this.elementcase.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
            this.elementcase.writeStyleXML(xMLPrintWriter);
        }
        if (this.toolBars.length != 0) {
            xMLPrintWriter.startTAG("toolBars");
            for (FormToolBarManager formToolBarManager : this.toolBars) {
                formToolBarManager.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("heightRestrict").attr("heightrestrict", this.heightRestrict).end();
        xMLPrintWriter.startTAG("heightPercent").attr("heightpercent", this.getHeightPercent()).end();
        xMLPrintWriter.startTAG("isShared").attr("isshared", this.isShared).end();
        if (this.attrMarkMap != null) {
            for (Map.Entry entry : this.attrMarkMap.entrySet()) {
                GeneralXMLTools.writeXMLable(xMLPrintWriter, (XMLable)entry.getValue(), (String)entry.getKey());
            }
        }
        if (this.reportFitAttr != null) {
            this.reportFitAttr.writeXML(xMLPrintWriter);
        }
        this.mobileAttr.writeXML(xMLPrintWriter);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ElementCaseEditor elementCaseEditor = (ElementCaseEditor)super.clone();
        if (this.elementcase != null) {
            elementCaseEditor.elementcase = (FormElementCaseProvider)this.elementcase.clone();
        }
        if (this.attrMarkMap != null) {
            HashMap<String, IOFileAttrMark> hashMap = new HashMap<String, IOFileAttrMark>();
            for (Map.Entry<String, IOFileAttrMark> entry : this.attrMarkMap.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().clone());
            }
            elementCaseEditor.attrMarkMap = hashMap;
        }
        if (this.reportFitAttr != null) {
            elementCaseEditor.reportFitAttr = (ReportFitAttrProvider)this.reportFitAttr.clone();
        }
        elementCaseEditor.isShared = this.isShared;
        return elementCaseEditor;
    }

    @Override
    public void toImage(Calculator calculator, Rectangle rectangle, Graphics graphics) {
        this.elementcase.setName(this.getWidgetName());
        BufferedImage bufferedImage = this.elementcase.toImage(calculator, rectangle.width, rectangle.height);
        graphics.drawImage(bufferedImage, rectangle.x, rectangle.y, null);
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("maxHeightPercent4Phone", this.getHeightPercent());
        jSONObject.put("isMaxHeightLimit4Phone", this.heightRestrict);
        JSONArray jSONArray = JSONArray.create();
        for (FormToolBarManager formToolBarManager : this.toolBars) {
            jSONArray.put(formToolBarManager.toJSONConfig(repository, calculator));
        }
        if (repository.getDevice().isMobile()) {
            jSONObject.put("showToolbar", jSONArray.length() != 0);
        } else {
            jSONObject.put("toolBars", jSONArray);
        }
        this.mobileAttr.createJSONConfig(jSONObject);
        this.createExtraJSONConfig(jSONObject);
        Object[] objectArray = this.dependence(calculator);
        if (!ArrayUtils.isEmpty(objectArray)) {
            jSONObject.put("valueDependence", objectArray);
        }
        nodeVisitor.visit("report", jSONObject);
        return jSONObject;
    }

    public void createExtraJSONConfig(JSONObject jSONObject) throws JSONException {
        if (this.attrMarkMap != null) {
            for (Map.Entry<String, IOFileAttrMark> entry : this.attrMarkMap.entrySet()) {
                ExtraAttrMapProvider extraAttrMapProvider = (ExtraAttrMapProvider)this.getAttrMark(entry.getKey());
                extraAttrMapProvider.createJSONConfig(jSONObject);
            }
        }
    }

    public int[] getValueType() {
        return new int[0];
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        try {
            jSONObject.put(this.widgetName, "recal");
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage());
        }
    }

    @Override
    public String[] dependence(CalculatorProvider calculatorProvider) {
        return this.elementcase.dependence(calculatorProvider);
    }

    @Override
    public boolean canCurrentMarginAvailable(PaddingMargin paddingMargin) {
        return true;
    }

    public void addAttrMark(IOFileAttrMark iOFileAttrMark) {
        if (this.attrMarkMap == null) {
            this.attrMarkMap = new HashMap<String, IOFileAttrMark>();
        }
        this.attrMarkMap.put(iOFileAttrMark.xmlTag(), iOFileAttrMark);
    }

    public <T extends IOFileAttrMark> T getAttrMark(String string) {
        if (this.attrMarkMap == null) {
            return null;
        }
        IOFileAttrMark iOFileAttrMark = this.attrMarkMap.get(string);
        return (T)iOFileAttrMark;
    }

    public boolean batchRenameTdName(Map<String, String> map) {
        if (this.elementcase == null || map == null || map.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (this.elementcase.renameTableData(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean renameTableData(String string, String string2) {
        if (this.elementcase == null) {
            return true;
        }
        return this.elementcase.renameTableData(string, string2);
    }

    static {
        Set set = ExtraClassManager.getInstance().getArray("IOFileAttrMark");
        for (IOFileAttrMark iOFileAttrMark : set) {
            extraAttrMarkMap.put(iOFileAttrMark.xmlTag(), iOFileAttrMark);
        }
    }
}

